/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.io.DataOutputStream;
import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.dynamics.CylindricalSurfaceStepGenerator;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.StepGeneratorFactory;
import simulation.dynamics.StickyWalker;
import simulation.dynamics.Walker;
import simulation.geometry.substrates.StickyCylinderSubstrate;
import simulation.geometry.substrates.Substrate;
import simulation.geometry.substrates.SubstrateFactory;
import simulation.measurement.SyntheticScan;

public class WalkerFactory {
    private static final Logger logger = Logger.getLogger("simulation.dynamics.WalkerFactory");

    public static final Walker getWalker(double[] dArray, StepGenerator stepGenerator, Substrate substrate, SyntheticScan syntheticScan, DataOutputStream dataOutputStream, SimulationParams simulationParams) {
        if (SimulationParams.sim_geomType == SubstrateFactory.SubstrateType.CYL_1_STICKY) {
            double[] dArray2 = StepGeneratorFactory.getStepParamsArray(StepGeneratorFactory.StepType.CYLINDRICAL, simulationParams);
            simulationParams.setStepParams(dArray2);
            SimulationParams.sim_stepType = StepGeneratorFactory.StepType.CYLINDRICAL;
            CylindricalSurfaceStepGenerator cylindricalSurfaceStepGenerator = new CylindricalSurfaceStepGenerator(simulationParams, (StickyCylinderSubstrate)substrate);
            return new StickyWalker(dArray, stepGenerator, cylindricalSurfaceStepGenerator, substrate, syntheticScan, dataOutputStream, true, SimulationParams.sim_p_unstick);
        }
        return new Walker(dArray, stepGenerator, substrate, syntheticScan, dataOutputStream);
    }
}

