/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import data.OutputManager;
import imaging.DW_Scheme;
import imaging.RectGradSteTanScheme;
import imaging.SimulableScheme;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.MTRandom;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.substrates.Substrate;
import simulation.measurement.ScanFactory;
import simulation.measurement.SyntheticScan;
import tools.CL_Initializer;

public class AgnosticScan
implements SyntheticScan {
    private static final Logger logger = Logger.getLogger("simulation.measurement.AgnosticScan");
    private final SimulableScheme scheme;
    private final double GAMMA = 2.6751525E8;
    private final int numMeas;
    private final Walker[] walker;
    private final Substrate substrate;
    private final MTRandom twister = new MTRandom(0x677F635D | CL_Initializer.seed);

    public AgnosticScan(SimulableScheme simulableScheme, Walker[] walkerArray, Substrate substrate) {
        this.scheme = simulableScheme;
        this.numMeas = ((DW_Scheme)((Object)simulableScheme)).numMeasurements();
        this.walker = walkerArray;
        this.substrate = substrate;
    }

    @Override
    public double[] getCompartmentalSignals(boolean bl) {
        double[] dArray = new double[this.numMeas];
        int n = 0;
        boolean bl2 = false;
        logger.info("generating " + this.numMeas + " signals");
        for (int i = 0; i < this.numMeas; ++i) {
            double d = 0.0;
            n = 0;
            bl2 = false;
            int n2 = 100;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            for (int j = 0; j < this.walker.length; ++j) {
                double d4 = this.walker[j].getPhaseShift(i);
                if (d4 < d2) {
                    d2 = d4;
                }
                if (d4 > d3) {
                    d3 = d4;
                }
                d += Math.cos(d4);
                if (this.substrate.intracellular(this.walker[j]) != bl) continue;
                d += Math.cos(d4);
                ++n;
            }
            double d5 = 0.0;
            double d6 = CL_Initializer.SNR;
            double d7 = 0.0;
            if (d6 > 0.0) {
                d7 = (double)this.walker.length / d6;
            }
            if (d6 > 0.0) {
                d5 = this.twister.nextGaussian() * d7;
            }
            d += d5;
            if (d6 > 0.0) {
                d5 = this.twister.nextGaussian() * d7;
            }
            dArray[i] = Math.sqrt(d * d + d5 * d5);
        }
        return dArray;
    }

    @Override
    public int getNumMeasurements() {
        return this.numMeas;
    }

    @Override
    public double getPhaseShift(Walker walker, double d, int n, double d2) {
        double[] dArray = this.scheme.getGradImpulse(n, d, d2);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += dArray[i] * (walker.r[i] - walker.r0[i]);
        }
        return 2.6751525E8 * d3;
    }

    @Override
    public ScanFactory.ScanType getScanType() {
        return ScanFactory.ScanType.AGNOSTIC;
    }

    @Override
    public double[] getSignals() {
        double[] dArray = new double[this.numMeas];
        logger.info("generating " + this.numMeas + " signals");
        for (int i = 0; i < this.numMeas; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < this.walker.length; ++j) {
                if (!this.substrate.voxelContains(this.walker[j].r)) continue;
                double d4 = this.walker[j].getPhaseShift(i);
                double d5 = Math.exp(this.walker[j].getLogMagnetisation(i));
                d += d5 * Math.cos(d4);
                if (this.substrate.intracellular(this.walker[j])) {
                    d2 += d5 * Math.cos(d4);
                    ++n;
                    continue;
                }
                d3 += d5 * Math.cos(d4);
                ++n2;
            }
            double d6 = 0.0;
            double d7 = CL_Initializer.SNR;
            double d8 = 0.0;
            if (d7 > 0.0) {
                d8 = (double)this.walker.length / d7;
            }
            if (d7 > 0.0) {
                d6 = this.twister.nextGaussian() * d8;
            }
            d += d6;
            if (d7 > 0.0) {
                d6 = this.twister.nextGaussian() * d8;
            }
            dArray[i] = Math.sqrt(d * d + d6 * d6);
            double d9 = d2;
            double d10 = d3;
            double d11 = ((DW_Scheme)((Object)this.scheme)).getB_Value(i);
            double d12 = Math.exp(-d11 * CL_Initializer.DIFF_CONST);
            logger.info("signal = " + dArray[i] + "  intra= " + d9 + " extra= " + d10 + " (" + n + " in, " + n2 + " out)" + " free = " + d12);
        }
        return dArray;
    }

    @Override
    public void update(int n) {
    }

    public static void main(String[] stringArray) {
        String string;
        double d;
        int n;
        DW_Scheme dW_Scheme;
        Object object;
        int n2 = 3;
        double[] dArray = new double[2];
        int n3 = -1;
        double[] dArray2 = new double[2];
        int n4 = -1;
        double[] dArray3 = new double[2];
        int n5 = -1;
        logger.warning("scan command can only use PGSE sequences.");
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-Grange")) {
                dArray[0] = Double.parseDouble(stringArray[i + 1]);
                dArray[1] = Double.parseDouble(stringArray[i + 2]);
                n3 = Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (stringArray[i].equals("-delrange")) {
                dArray2[0] = Double.parseDouble(stringArray[i + 1]);
                dArray2[1] = Double.parseDouble(stringArray[i + 2]);
                n4 = Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (!stringArray[i].equals("-DELrange")) continue;
            dArray3[0] = Double.parseDouble(stringArray[i + 1]);
            dArray3[1] = Double.parseDouble(stringArray[i + 2]);
            n5 = Integer.parseInt(stringArray[i + 3]);
            CL_Initializer.markAsParsed(i, 4);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        try {
            object = DiffusionSimulation.class.getResource("/test/bmx7_ED.scheme1").toURI();
            String string2 = ((URI)object).getPath();
            dW_Scheme = RectGradSteTanScheme.readScheme(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new LoggedException(uRISyntaxException);
        }
        object = new double[dW_Scheme.numMeasurements()][];
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            int n6;
            object[i] = dW_Scheme.getG_Dir(i);
            double d2 = 0.0;
            for (n6 = 0; n6 < n2; ++n6) {
                d2 += object[i][n6] * object[i][n6];
            }
            if (!((d2 = Math.sqrt(d2)) > 0.0)) continue;
            n6 = 0;
            while (n6 < ((Object)object[i]).length) {
                Object object2 = object[i];
                int n7 = n6++;
                object2[n7] = object2[n7] / d2;
            }
        }
        OutputManager outputManager = new OutputManager();
        double[] dArray4 = new double[n3 + 1];
        double[] dArray5 = new double[n5 + 1];
        double[] dArray6 = new double[n4 + 1];
        dArray4[0] = dArray[0];
        dArray4[n3] = dArray[1];
        if (n3 > 0) {
            for (n = 1; n < n3; ++n) {
                d = (dArray[1] - dArray[0]) / (double)n3;
                dArray4[n] = dArray[0] + (double)n * d;
            }
        }
        dArray6[0] = dArray2[0];
        dArray6[n4] = dArray2[1];
        if (n4 > 0) {
            for (n = 1; n < n4; ++n) {
                d = (dArray2[1] - dArray2[0]) / (double)n4;
                dArray6[n] = dArray2[0] + (double)n * d;
            }
        }
        dArray5[0] = dArray3[0];
        dArray5[n5] = dArray3[1];
        if (n5 > 0) {
            for (n = 1; n < n5; ++n) {
                d = (dArray3[1] - dArray3[0]) / (double)n5;
                dArray5[n] = dArray3[0] + (double)n * d;
            }
        }
        if ((string = SimulationParams.trajFile) == null) {
            throw new LoggedException("trajectories filename has not been set.");
        }
        Object var16_24 = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n8 = 0;
        double[] dArray7 = new double[dW_Scheme.numMeasurements()];
        for (int i = 0; i < dArray5.length; ++i) {
            for (int j = 0; j < dArray6.length; ++j) {
                double d6;
                double d7;
                double d8;
                DataInputStream dataInputStream;
                System.err.println("i= " + i + " j= " + j);
                if (dArray6[j] > dArray5[i]) continue;
                try {
                    dataInputStream = new DataInputStream(new FileInputStream(string));
                    double d9 = dataInputStream.readDouble();
                    if (d9 < dArray6[j] + dArray5[i]) continue;
                    d8 = dataInputStream.readDouble();
                    d7 = dataInputStream.readDouble();
                    d6 = d9 / d7;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                double[][][] dArray8 = new double[(int)d8][n2][2];
                double d10 = 0.0;
                double d11 = dArray6[j];
                double d12 = dArray5[i];
                double d13 = dArray5[i] + dArray6[j];
                double[] dArray9 = new double[n2];
                try {
                    int n9;
                    int n10;
                    int n11;
                    block15: for (n11 = 0; n11 < (int)d7; ++n11) {
                        for (n10 = 0; n10 < (int)d8; ++n10) {
                            double d14 = dataInputStream.readDouble();
                            int n12 = dataInputStream.readInt();
                            for (n9 = 0; n9 < n2; ++n9) {
                                dArray9[n9] = dataInputStream.readDouble();
                                if (d14 >= d10 && d14 < d11) {
                                    double[] dArray10 = dArray8[n12][n9];
                                    dArray10[0] = dArray10[0] + dArray9[n9];
                                    continue;
                                }
                                if (!(d14 >= d12) || !(d14 < d13)) continue;
                                double[] dArray11 = dArray8[n12][n9];
                                dArray11[1] = dArray11[1] + dArray9[n9];
                            }
                            if (d14 > d13) continue block15;
                        }
                    }
                    for (n11 = 0; n11 < dArray4.length; ++n11) {
                        for (n10 = 0; n10 < ((Object)object).length; ++n10) {
                            dArray7[n10] = 0.0;
                            for (int k = 0; k < dArray8.length; ++k) {
                                double d15 = 0.0;
                                for (n9 = 0; n9 < n2; ++n9) {
                                    d15 += object[n10][n9] * (dArray8[k][n9][1] - dArray8[k][n9][0]);
                                }
                                int n13 = n10;
                                dArray7[n13] = dArray7[n13] + Math.cos(d15 *= 2.6751525E8 * dArray4[n11] * d6);
                            }
                            ++n8;
                        }
                        outputManager.output(dArray7);
                    }
                    dataInputStream.close();
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
        }
        outputManager.close();
        d4 = Math.sqrt((d5 /= (double)n8) - (d3 /= (double)n8) * d3);
        System.err.println("mean = " + d5 + "\tstdDev = " + d4);
    }
}

