/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.measurement.MSdispStatsModule;
import simulation.measurement.StatisticsModule;
import simulation.measurement.StickyStatsModule;

public class StatisticsModuleFactory {
    private static final Logger logger = Logger.getLogger("simulation.measurement.StatisticsModuleFactory");

    public static final StatisticsModule getStatsModule(Walker[] walkerArray) {
        if (SimulationParams.sim_StatsModType == StatsModuleType.MS_DISP) {
            return new MSdispStatsModule(walkerArray);
        }
        if (SimulationParams.sim_StatsModType == StatsModuleType.STICKY_STATS) {
            return new StickyStatsModule(walkerArray);
        }
        logger.warning("unrecognised statistics module type. returning mean-squared displacement type");
        return new MSdispStatsModule(walkerArray);
    }

    public static enum StatsModuleType {
        MS_DISP,
        STICKY_STATS;

    }
}

