/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import misc.LoggedException;
import misc.SphericalPoints;
import sphfunc.EvenSHS;
import sphfunc.LinearBasisSum;
import sphfunc.RBF_Sum;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class BasisSumFactory {
    public static final int TUCH_RBF = 1;
    public static final int SPHERICAL_HARMONICS = 2;
    private static final int DEFAULT_RBF_POINTSET = 246;

    public static LinearBasisSum getBasisSum(int n) {
        if (n == 1) {
            int n2 = RBF_Sum.numPoints();
            if (n2 > 0) {
                n2 += 2;
            } else {
                RBF_Sum.setPoints(SphericalPoints.getElecPointSet(246));
                n2 = 248;
            }
            double[] dArray = BasisSumFactory.getCoeffs(n2);
            return new TuchRBF_Sum(dArray);
        }
        if (n == 2) {
            int n3 = CL_Initializer.maxOrder;
            int n4 = (n3 * n3 + 3 * n3 + 2) / 2;
            double[] dArray = BasisSumFactory.getCoeffs(n4 += 2);
            return new EvenSHS(dArray, n3);
        }
        throw new LoggedException("Unrecognized basis type: " + n);
    }

    private static double[] getCoeffs(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0;
        }
        return dArray;
    }
}

