/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import java.net.URL;
import misc.LoggedException;
import sphfunc.ISCodesException;
import sphfunc.SphericalPointSet;

public class ISCodes {
    private static String directory = "/ISCodes/";
    private static String[] filenames = new String[]{"isc01082.txt", "isc01922.txt", "isc03002.txt", "isc04322.txt", "isc05882.txt", "isc08672.txt", "isc12002.txt", "isc15872.txt", "isc20282.txt", "isc27002.txt", "isc32672.txt", "isc38882.txt", "isc48002.txt", "isc55472.txt", "isc63482.txt", "isc72032.txt", "isc78032.txt"};
    private static String[] filenamesForMaxEnt = new String[]{"isc01082.txt", "isc01922.txt", "isc04322.txt", "isc08672.txt", "isc15872.txt", "isc32672.txt"};
    private static SphericalPointSet[] ptSets = new SphericalPointSet[filenames.length];
    private static SphericalPointSet[] ptSetsForME = new SphericalPointSet[filenamesForMaxEnt.length];

    public static SphericalPointSet getPointSet(int n) throws ISCodesException {
        if (n < 0 || n > filenames.length) {
            throw new ISCodesException("Point set out of range.");
        }
        if (ptSets[n] == null) {
            URL uRL = ISCodes.class.getResource(directory + filenames[n]);
            if (uRL == null) {
                throw new LoggedException("Could not find file: " + directory + filenames[n]);
            }
            ISCodes.ptSets[n] = new SphericalPointSet(uRL.getFile());
        }
        return ptSets[n];
    }

    public static SphericalPointSet getPointSetForMaxEnt(int n) throws ISCodesException {
        if (n < 0 || n > filenamesForMaxEnt.length) {
            throw new ISCodesException("Max. Ent. point set out of range.");
        }
        if (ptSetsForME[n] == null) {
            URL uRL = ISCodes.class.getResource(directory + filenamesForMaxEnt[n]);
            if (uRL == null) {
                throw new LoggedException("Could not find file: " + directory + filenamesForMaxEnt[n]);
            }
            ISCodes.ptSetsForME[n] = new SphericalPointSet(uRL.getFile());
        }
        return ptSetsForME[n];
    }

    public static int getNoPointSets() {
        return filenames.length;
    }

    public static int getNoPointSetsForMaxEnt() {
        return filenamesForMaxEnt.length;
    }
}

