/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import misc.LoggedException;

public class BufferedInflaterInputStream
extends FilterInputStream {
    private int bufferSize;
    private byte[] buffer;
    private boolean streamEOF = false;
    private int bufferIndex = 0;

    public BufferedInflaterInputStream(InflaterInputStream inflaterInputStream, int n) {
        super(inflaterInputStream);
        this.bufferSize = n;
        this.buffer = new byte[n];
        this.fillBuffer();
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        if (this.bufferIndex < this.bufferSize) {
            n = this.buffer[this.bufferIndex] & 0xFF;
            ++this.bufferIndex;
            if (this.bufferIndex == this.bufferSize && !this.streamEOF) {
                this.fillBuffer();
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufferIndex == this.bufferSize) {
            return -1;
        }
        int n3 = 0;
        if (n2 <= this.bufferSize - this.bufferIndex) {
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferSize && !this.streamEOF) {
                this.fillBuffer();
            }
            n3 = n2;
        } else {
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n, this.bufferSize - this.bufferIndex);
            this.bufferIndex += (n3 += this.bufferSize - this.bufferIndex);
            if (!this.streamEOF) {
                this.fillBuffer();
            } else {
                return n3;
            }
            while (n3 < n2 && this.bufferIndex < this.bufferSize) {
                int n4 = n3 + this.bufferSize < n2 ? this.bufferSize : n2 - n3;
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n + n3, n4);
                n3 += n4;
                this.bufferIndex += n4;
                if (this.bufferIndex == this.bufferSize && !this.streamEOF) {
                    this.fillBuffer();
                    continue;
                }
                return n3;
            }
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        for (long i = l; i > 0L; i -= (long)n) {
            int n2 = 0;
            n2 = i > (long)this.bufferSize ? this.bufferSize : (int)i;
            n = this.read(new byte[n2], 0, n2);
            if (n >= 0) continue;
            throw new IOException("Tried to skip past EOF");
        }
        return l;
    }

    private void fillBuffer() {
        if (this.streamEOF) {
            throw new LoggedException("Tried to read past EOF");
        }
        try {
            int n;
            int n2;
            for (n = 0; n < this.bufferSize && (n2 = this.in.read(this.buffer, n, this.bufferSize - n)) != -1; n += n2) {
            }
            if (n < this.bufferSize) {
                if (n > 0) {
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.buffer, 0, byArray, 0, n);
                    this.buffer = byArray;
                    this.bufferIndex = 0;
                    this.bufferSize = n;
                }
                this.streamEOF = true;
            } else {
                this.bufferIndex = 0;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

