/*
 * Decompiled with CFR 0.152.
 */
package tools;

import data.BootstrapDataSynthFromInput;
import data.BootstrapDataSynthFromSimulationInput;
import data.BootstrapDataSynthesizer;
import data.DataSource;
import data.DataSynthFromBallStickInput;
import data.DataSynthFromDT_Input;
import data.DataSynthFromInput;
import data.DataSynthFromMultiTensorInput;
import data.DataSynthFromThreeTensorInput;
import data.DataSynthFromTwoTensorInput;
import data.DataSynthesizer;
import data.GaussianMixture;
import data.ModelPDF;
import data.OutputManager;
import data.StandardTestFunctions;
import data.SyntheticBootstrapper;
import data.VoxelOrderDW_DataSource;
import data.VoxelOrderDataSource;
import data.WildBS_DT_DataSynth;
import imaging.B_VectorScheme;
import imaging.DW_Scheme;
import imaging.ImageHeader;
import imaging.Nifti1Dataset;
import imaging.SimulableScheme;
import inverters.ModelIndex;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import mesd.MESD_Inversion;
import misc.DT;
import misc.LoggedException;
import misc.SphericalPoints;
import models.compartments.CompartmentModel;
import models.compartments.CompartmentType;
import numerics.MTRandom;
import numerics.Rotations;
import numerics.SphericalHarmonics;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.StepGeneratorFactory;
import simulation.geometry.substrates.SubstrateFactory;
import sphfunc.MaxEntProfile;
import sphfunc.RBF_Sum;
import sphfunc.SphericalFunction;
import sphfunc.TuchRBF_Sum;
import tools.DB;

public class CL_Initializer {
    private static Logger logger = Logger.getLogger("camino.tools.CL_Initializer");
    public static final int BALLSTICKVALSPERVOXEL = 7;
    public static final int ONETENVALSPERVOXEL = 8;
    public static final int TWOTENVALSPERVOXEL = 17;
    public static final int THREETENVALSPERVOXEL = 24;
    public static int testFunction = -1;
    public static boolean nonStandardTestFunction = false;
    public static boolean brownianSimulation = false;
    public static boolean compartmentModel = false;
    public static boolean modelfitting = false;
    public static String fitModel = null;
    public static boolean fixedStartPoint = false;
    public static String noiseModel = "GAUSSIAN";
    public static String fitAlgorithm = null;
    public static SimulationParams simParams = null;
    public static double DIFF_CONST = 2.02E-9;
    public static double volFrac = 1.0;
    public static int[] dataDims = new int[]{0, 0, 0};
    public static double[] voxelDims = new double[]{0.0, 0.0, 0.0};
    public static double centreDist = 0.0;
    public static double[] testFunctionData = new double[0];
    public static ModelIndex[] inversionIndices = new ModelIndex[]{ModelIndex.LDT};
    public static int rotationIndex = 0;
    public static int numVoxels = 0;
    public static double lambda1 = -1.0;
    public static double dt2rotangle = 0.0;
    public static double dt2mix = -1.0;
    public static double scale = -1.0;
    public static int numElements = -1;
    public static int M = -1;
    public static int N = -1;
    public static double bValue = 0.0;
    public static double SNR = -1.0;
    public static int bootstrap = -1;
    public static String wildBootstrapModel = null;
    public static String[] bsDataFiles = null;
    public static int seed = 36558013;
    public static String voxelClassMap = null;
    public static int maxTensorComponents = 2;
    public static double gamma_k = 1.84037;
    public static double gamma_beta = 7.8E-7;
    public static double mmwmddiff = -1.0;
    public static ModelIndex[][] classifiedModelIndices = new ModelIndex[][]{{ModelIndex.LDT}, {ModelIndex.LDT}, {ModelIndex.LDT}, {ModelIndex.POSPOS, ModelIndex.LDT}};
    public static String inputFile = null;
    public static String bgMaskFile = null;
    public static String schemeFile = null;
    public static double sigma = -1.0;
    public static String noiseType = "rician";
    public static String outlierMapFile = null;
    public static String noiseVarianceMapFile = null;
    public static String residualVectorMapFile = null;
    public static String matrixFile;
    public static boolean lrNormalize;
    public static boolean lrLog;
    public static String inputDataType;
    public static String bgMaskType;
    public static String inputModel;
    public static String[] compartmentNames;
    public static double[] compParams;
    public static int basisType;
    public static int pointSetInd;
    public static boolean pointSetIndSet;
    public static int numPDsIO;
    public static int maxOrder;
    public static double f1;
    public static double f2;
    public static double f3;
    public static double[] kernelParams;
    public static int mePointSet;
    public static double BACKGROUNDTHRESHOLD;
    public static double CSFTHRESHOLD;
    public static DW_Scheme imPars;
    public static ModelPDF p;
    public static DataSource data;
    public static DataSource bgMask;
    private static boolean[] parsed;
    public static String transformFile;
    public static String transformFileX;
    public static String transformFileY;
    public static String transformFileZ;
    public static String reorientation;
    public static int burnInTime;
    public static int samples;
    public static int interval;
    public static String mcmcStatsFile;
    public static String headerTemplateFile;
    public static ImageHeader headerTemplate;

    private CL_Initializer() {
    }

    public static void CL_init(String[] stringArray) {
        int n;
        int n2;
        parsed = new boolean[stringArray.length];
        for (n2 = 0; n2 < parsed.length; ++n2) {
            CL_Initializer.parsed[n2] = false;
        }
        n2 = 0;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            int n3;
            Object[] objectArray;
            if (stringArray[n].equals("-argfile")) {
                try {
                    stringArray = CL_Initializer.augmentArgs(stringArray, stringArray[n + 1]);
                    objectArray = new boolean[stringArray.length];
                    for (n3 = 0; n3 < n; ++n3) {
                        objectArray[n3] = parsed[n3];
                    }
                    for (n3 = n; n3 < objectArray.length; ++n3) {
                        objectArray[n3] = false;
                    }
                    parsed = objectArray;
                    CL_Initializer.markAsParsed(n);
                    CL_Initializer.markAsParsed(n + 1);
                }
                catch (Exception exception) {
                    throw new LoggedException(exception.toString() + "\nAttempting to continue...");
                }
            }
            if (stringArray[n].equals("-testfunc")) {
                testFunction = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-gaussmix")) {
                nonStandardTestFunction = true;
                int n4 = Integer.parseInt(stringArray[n + 1]);
                testFunctionData = new double[1 + n4 * 7];
                CL_Initializer.testFunctionData[0] = n4;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                for (n3 = 0; n3 < n4 * 7; ++n3) {
                    try {
                        CL_Initializer.testFunctionData[n3 + 1] = Double.parseDouble(stringArray[n + n3 + 2]);
                        CL_Initializer.parsed[n + n3 + 2] = true;
                        continue;
                    }
                    catch (Exception exception) {
                        throw new LoggedException("Enter {Dxx, Dxy, Dxz, Dyy, Dyz, Dzz, mix} for each component diffusion tensor.");
                    }
                }
            }
            if (stringArray[n].equals("-rotation")) {
                rotationIndex = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inversion")) {
                inversionIndices = ModelIndex.getIndices(new String[]{stringArray[n + 1]});
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equalsIgnoreCase("-fitmodel")) {
                fitModel = stringArray[n + 1];
                compartmentModel = true;
                modelfitting = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-noiseModel")) {
                noiseModel = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-fitalgorithm")) {
                fitAlgorithm = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-model")) {
                objectArray = new String[1000];
                n3 = 0;
                while (n3 + n + 1 < stringArray.length && !stringArray[n + n3 + 1].startsWith("-")) {
                    objectArray[n3] = stringArray[n + n3 + 1];
                    ++n3;
                }
                String[] stringArray2 = new String[n3];
                System.arraycopy(objectArray, 0, stringArray2, 0, n3);
                inversionIndices = ModelIndex.getIndices(stringArray2);
                CL_Initializer.markAsParsed(n, n3 + 1);
            }
            if (stringArray[n].equals("-bootstrap")) {
                bootstrap = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-seed")) {
                seed = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxels")) {
                numVoxels = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-bmx")) {
                logger.warning("This option has been deprecated and is no longer functional. Use -schemefile.");
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxelelements")) {
                numElements = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-fixedmodq")) {
                M = Integer.parseInt(stringArray[n + 1]);
                N = Integer.parseInt(stringArray[n + 2]);
                double d = Double.parseDouble(stringArray[n + 3]);
                double d2 = Double.parseDouble(stringArray[n + 4]);
                bValue = d * d * d2;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                CL_Initializer.markAsParsed(n + 2);
                CL_Initializer.markAsParsed(n + 3);
                CL_Initializer.markAsParsed(n + 4);
            }
            if (stringArray[n].equals("-fixedbvalue")) {
                M = Integer.parseInt(stringArray[n + 1]);
                N = Integer.parseInt(stringArray[n + 2]);
                bValue = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                CL_Initializer.markAsParsed(n + 2);
                CL_Initializer.markAsParsed(n + 3);
            }
            if (stringArray[n].equals("-qscale")) {
                logger.warning("This option has been deprecated and is no longer functional.");
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-tau")) {
                logger.warning("This option has been deprecated and is no longer functional.");
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-tauscale")) {
                logger.warning("This option has been deprecated and is no longer functional.");
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-lambda1")) {
                lambda1 = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-scale")) {
                scale = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-dt2rotangle")) {
                dt2rotangle = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-dt2mix")) {
                dt2mix = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-snr")) {
                SNR = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outputfile")) {
                OutputManager.outputFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-gzip")) {
                OutputManager.gzipOut = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-inputfile")) {
                inputFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-bsdatafiles")) {
                String[] stringArray3 = new String[1000];
                n3 = 0;
                while (n3 + n + 1 < stringArray.length && !stringArray[n3 + n + 1].startsWith("-")) {
                    stringArray3[n3] = stringArray[n + n3 + 1];
                    ++n3;
                }
                bsDataFiles = new String[n3];
                bootstrap = n3;
                System.arraycopy(stringArray3, 0, bsDataFiles, 0, n3);
                CL_Initializer.markAsParsed(n, n3 + 1);
            }
            if (stringArray[n].equals("-wildbsmodel")) {
                wildBootstrapModel = stringArray[n + 1];
                bootstrap = 1;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-bgmask") || stringArray[n].equals("-brainmask")) {
                bgMaskFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-schemefile")) {
                schemeFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxclassmap")) {
                voxelClassMap = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outliermap")) {
                outlierMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-noisemap")) {
                noiseVarianceMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-residualmap")) {
                residualVectorMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-matrix")) {
                matrixFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-normalize")) {
                lrNormalize = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-log")) {
                lrLog = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-sigma")) {
                sigma = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-noisetype")) {
                noiseType = stringArray[n + 1].toLowerCase();
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inputdatatype")) {
                inputDataType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outputdatatype")) {
                OutputManager.outputDataType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-maskdatatype")) {
                bgMaskType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inputmodel")) {
                inputModel = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-synthmodel")) {
                CL_Initializer.initCompartmentModel(stringArray, n + 1);
                compartmentModel = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-startpoint")) {
                CL_Initializer.initCompartmentModel(stringArray, n + 1);
                fixedStartPoint = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-basistype")) {
                if (stringArray[n + 1].equals("rbf")) {
                    basisType = 1;
                } else if (stringArray[n + 1].equals("sh")) {
                    basisType = 2;
                } else {
                    throw new LoggedException("Unrecognized basis type: " + stringArray[n + 1]);
                }
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-order")) {
                maxOrder = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-fastmesd")) {
                MESD_Inversion.doNumIntTests = false;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-basepointset")) {
                MESD_Inversion.basePointSet = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-pointset")) {
                pointSetInd = Integer.parseInt(stringArray[n + 1]);
                pointSetIndSet = true;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-maxcomponents")) {
                maxTensorComponents = Integer.parseInt(stringArray[n + 1]);
                bl = true;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-classifiedmodels")) {
                int n5 = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                String[] stringArray4 = new String[n5];
                for (int i = 0; i < n5; ++i) {
                    stringArray4[i] = stringArray[n + 2 + i];
                    CL_Initializer.markAsParsed(n + 2 + i);
                }
                classifiedModelIndices = ModelIndex.getClassifiedModelIndices(stringArray4);
            }
            if (stringArray[n].equals("-rbfpointset")) {
                RBF_Sum.setPoints(SphericalPoints.getElecPointSet(Integer.parseInt(stringArray[n + 1])));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-rbfsigma")) {
                TuchRBF_Sum.setSigma(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-filter")) {
                CL_Initializer.markAsParsed(n);
                if (stringArray[n + 1].equals("SPIKE")) {
                    kernelParams = new double[2];
                    CL_Initializer.kernelParams[0] = 0.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else if (stringArray[n + 1].equals("PAS")) {
                    kernelParams = new double[2];
                    CL_Initializer.kernelParams[0] = 1.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else if (stringArray[n + 1].equals("TENSOR")) {
                    CL_Initializer.kernelParams[0] = 2.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else {
                    throw new LoggedException("Unrecognized filter type: " + stringArray[n + 1]);
                }
            }
            if (stringArray[n].equals("-mepointset")) {
                mePointSet = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ftest")) {
                f1 = Double.parseDouble(stringArray[n + 1]);
                f2 = Double.parseDouble(stringArray[n + 2]);
                f3 = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                CL_Initializer.markAsParsed(n + 2);
                CL_Initializer.markAsParsed(n + 3);
            }
            if (stringArray[n].equals("-bgthresh")) {
                BACKGROUNDTHRESHOLD = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-csfthresh")) {
                CSFTHRESHOLD = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-numpds")) {
                numPDsIO = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                n2 = 1;
            }
            if (stringArray[n].equals("-searchradius")) {
                SphericalFunction.setSearchRadius(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-paramscale")) {
                SphericalFunction.SFPD_PARAMSCALE = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-v")) {
                DB.setVerbosity(Integer.parseInt(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-trans")) {
                transformFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-xtrans")) {
                transformFileX = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ytrans")) {
                transformFileY = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ztrans")) {
                transformFileZ = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-reorientation")) {
                reorientation = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-diffusivity")) {
                DIFF_CONST = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-mmwmddiff")) {
                mmwmddiff = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-gamma")) {
                gamma_k = Double.parseDouble(stringArray[n + 1]);
                gamma_beta = Double.parseDouble(stringArray[n + 2]);
                CL_Initializer.markAsParsed(n, 3);
            }
            if (stringArray[n].equalsIgnoreCase("-drawcrosssection")) {
                SimulationParams.sim_drawCrossSection = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-walkers")) {
                SimulationParams.sim_N_walkers = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-tmax")) {
                SimulationParams.sim_tmax = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-p")) {
                SimulationParams.sim_p = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-pstick")) {
                SimulationParams.sim_p_stick = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-punstick")) {
                SimulationParams.sim_p_unstick = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-voxelsizefrac")) {
                SimulationParams.sim_voxelSizeFrac = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-crossangle")) {
                SimulationParams.sim_cAngle = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-D1")) {
                SimulationParams.sim_cyl_D1 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-D2")) {
                SimulationParams.sim_cyl_D2 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-compartmentsignal")) {
                if (stringArray[n + 1].equalsIgnoreCase("EXTRAONLY")) {
                    SimulationParams.sim_compartmentSignal = 1;
                    brownianSimulation = true;
                    CL_Initializer.markAsParsed(n, 2);
                }
                if (stringArray[n + 1].equalsIgnoreCase("INTRAONLY")) {
                    SimulationParams.sim_compartmentSignal = 2;
                    brownianSimulation = true;
                    CL_Initializer.markAsParsed(n, 2);
                }
                if (stringArray[n + 1].equalsIgnoreCase("ALL")) {
                    SimulationParams.sim_compartmentSignal = 3;
                    brownianSimulation = true;
                    CL_Initializer.markAsParsed(n, 2);
                }
            }
            if (stringArray[n].equals("-initial")) {
                if (stringArray[n + 1].equalsIgnoreCase("uniform")) {
                    SimulationParams.sim_initial = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("spike") || stringArray[n + 1].equalsIgnoreCase("delta")) {
                    SimulationParams.sim_initial = 0;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("special")) {
                    SimulationParams.sim_initial = 2;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("intra")) {
                    SimulationParams.sim_initial = 3;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("extra")) {
                    SimulationParams.sim_initial = 4;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("simulation initial conditions '" + stringArray[n + 1] + "' default value (UNIFORM) will be used");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equalsIgnoreCase("-duration")) {
                SimulationParams.duration = Double.parseDouble(stringArray[n + 1]);
                SimulationParams.trajectories = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-trajfile")) {
                SimulationParams.trajFile = stringArray[n + 1];
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-separateruns")) {
                SimulationParams.sim_separate_runs = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equalsIgnoreCase("-facets")) {
                SimulationParams.sim_num_facets = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-geometry") || stringArray[n].equals("-substrate")) {
                if (stringArray[n + 1].equalsIgnoreCase("cell-striped")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CELL_STRIPED;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cell-perc")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CELL_PERC;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cylinder")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_FIXED;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("inflammation")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_INFLAM;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("facetted")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_FACET;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("ply")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.TRI_PLY_MESH;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("percolation")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_PERC;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("myelinated")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_MYELIN;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("crossing")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_2_FIXED;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("distribcylinder")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_DISTRIB;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("stickycylinder")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.CYL_1_STICKY;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("empty")) {
                    SimulationParams.sim_geomType = SubstrateFactory.SubstrateType.EMPTY;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("unrecognised geometry type '" + stringArray[n + 1] + "' will use default (" + SimulationParams.sim_geomType + ")");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equalsIgnoreCase("-substrateinfo")) {
                SimulationParams.substrateInfo = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-packing")) {
                if (stringArray[n + 1].equalsIgnoreCase("square")) {
                    SimulationParams.sim_cyl_pack = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("hex")) {
                    SimulationParams.sim_cyl_pack = 2;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("cylinder packing '" + stringArray[n + 1] + "' not supported. will default to hexagonal packing");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-numcylinders")) {
                SimulationParams.sim_cyl_dist_size = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cylinderminrad")) {
                SimulationParams.sim_cyl_min_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cylindermaxrad")) {
                SimulationParams.sim_cyl_max_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cylinderrad")) {
                SimulationParams.sim_cyl_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cylinderinnerrad")) {
                SimulationParams.sim_cyl_r1 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cylindersep")) {
                SimulationParams.sim_cyl_R = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-increments")) {
                SimulationParams.sim_inflamm_increments = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-onlyrun")) {
                SimulationParams.sim_onlyRun = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-voxelsize")) {
                SimulationParams.sim_voxelSize = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-plyfile")) {
                SimulationParams.sim_plyfile = new String(stringArray[n + 1]);
                String string = SimulationParams.sim_plyfile.substring(SimulationParams.sim_plyfile.length() - 4);
                if (!string.equalsIgnoreCase(".ply")) {
                    SimulationParams.sim_plyfile = SimulationParams.sim_plyfile + ".ply";
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-steptype")) {
                if (stringArray[n + 1].equals("fixedlength")) {
                    SimulationParams.sim_stepType = StepGeneratorFactory.StepType.FIXEDLENGTH;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("step type '" + stringArray[n + 1] + "' unknown. default " + "(fixedlegnth) generator will be used");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-substratesize")) {
                SimulationParams.sim_L = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-latticesize")) {
                SimulationParams.sim_L = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-cellsize")) {
                SimulationParams.sim_l = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-stripethickness")) {
                SimulationParams.sim_stripethickness = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-pperc")) {
                SimulationParams.sim_p_perc = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equalsIgnoreCase("-statsfile")) {
                SimulationParams.sim_statsfile = stringArray[n + 1];
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-volfrac")) {
                volFrac = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-gridsize") || stringArray[n].equals("-datadims")) {
                CL_Initializer.dataDims[0] = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.dataDims[1] = Integer.parseInt(stringArray[n + 2]);
                CL_Initializer.dataDims[2] = Integer.parseInt(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
            }
            if (stringArray[n].equals("-voxeldims")) {
                CL_Initializer.voxelDims[0] = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.voxelDims[1] = Double.parseDouble(stringArray[n + 2]);
                CL_Initializer.voxelDims[2] = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
            }
            if (stringArray[n].equals("-centredist")) {
                centreDist = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-burnin")) {
                burnInTime = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-samples")) {
                samples = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-interval")) {
                interval = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equalsIgnoreCase("-mcmcstatsfile")) {
                mcmcStatsFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
            }
            if (!stringArray[n].equals("-header")) continue;
            headerTemplateFile = stringArray[n + 1];
            CL_Initializer.markAsParsed(n, 2);
        }
        if (n2 == 0 && inputModel != null) {
            if (inputModel.equals("dt")) {
                numPDsIO = 1;
            } else if (inputModel.equals("twotensor")) {
                numPDsIO = 2;
            } else if (inputModel.equals("threetensor")) {
                numPDsIO = 3;
            } else if (inputModel.equals("pico")) {
                numPDsIO = 1;
            } else if (inputModel.equals("ballstick")) {
                numPDsIO = 1;
            } else if (inputModel.equals("bayesdirac")) {
                numPDsIO = 1;
            } else if (inputModel.equals("multitensor")) {
                numPDsIO = maxTensorComponents;
            }
        } else if (n2 != 0 && inputModel != null) {
            n = 0;
            if (inputModel.equals("dt")) {
                if (numPDsIO != 1) {
                    n = 1;
                }
            } else if (inputModel.equals("twotensor")) {
                if (numPDsIO != 2) {
                    n = 1;
                }
            } else if (inputModel.equals("threetensor")) {
                if (numPDsIO != 3) {
                    n = 1;
                }
            } else if (inputModel.equals("ballstick") && numPDsIO != 1) {
                n = 1;
            }
            if (n != 0) {
                throw new LoggedException("Wrong number of PDs (" + numPDsIO + ") specified for input model " + inputModel);
            }
        }
        if (!bl && inputModel != null) {
            if (inputModel.equals("dt")) {
                maxTensorComponents = 1;
            } else if (inputModel.equals("twotensor")) {
                maxTensorComponents = 2;
            } else if (inputModel.equals("threetensor")) {
                maxTensorComponents = 3;
            }
        } else if (bl && inputModel != null) {
            n = 0;
            if (inputModel.equals("dt")) {
                if (maxTensorComponents != 1) {
                    n = 1;
                }
            } else if (inputModel.equals("twotensor")) {
                if (maxTensorComponents != 2) {
                    n = 1;
                }
            } else if (inputModel.equals("threetensor") && maxTensorComponents != 3) {
                n = 1;
            }
            if (n != 0) {
                throw new LoggedException("Wrong number of tensor components (" + maxTensorComponents + ") specified for input model " + inputModel);
            }
        }
    }

    public static final void checkParsing(String[] stringArray) {
        if (parsed == null) {
            RuntimeException runtimeException = new RuntimeException("attempt to check command line argument parsing made before parsing has been attempted!");
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            String string = new String();
            logger.severe(runtimeException.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i] + "\n";
            }
            logger.severe(string);
            throw runtimeException;
        }
        for (int i = 0; i < parsed.length; ++i) {
            if (parsed[i]) continue;
            logger.warning("WARNING: couldn't parse arg " + i + ": '" + stringArray[i] + "'");
        }
    }

    public static String[] augmentArgs(String[] stringArray, String string) throws FileNotFoundException {
        int n;
        Scanner scanner = new Scanner(new File(string));
        Vector<String> vector = new Vector<String>();
        while (scanner.hasNext()) {
            vector.add(scanner.next());
        }
        scanner.close();
        String[] stringArray2 = new String[stringArray.length + vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[stringArray.length + n] = (String)vector.elementAt(n);
        }
        return stringArray2;
    }

    public static void initImagingScheme() {
        if (M >= 0) {
            imPars = B_VectorScheme.elecPointSetScheme(M, N, bValue);
        } else if (schemeFile != null) {
            imPars = DW_Scheme.readScheme(schemeFile);
        } else if (!brownianSimulation) {
            throw new LoggedException("Tried to initialize imaging scheme, but no scheme parameters were specified");
        }
    }

    public static void initMaxEnt() {
        if (mePointSet > 0) {
            MaxEntProfile.setReconDirs(SphericalPoints.getElecPointSet(mePointSet));
        } else {
            MaxEntProfile.setReconDirs(imPars.getNonZeroG_Dirs());
        }
    }

    public static void setDataSource(DataSource dataSource) {
        data = dataSource;
    }

    public static void setMaskSource(DataSource dataSource) {
        bgMask = dataSource;
    }

    public static void initSphFuncDataSource() {
        if (inputModel == null) {
            data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
        } else if (inputModel.equals("dt")) {
            data = new VoxelOrderDataSource(inputFile, 8, inputDataType);
        } else if (inputModel.equals("ballstick")) {
            data = new VoxelOrderDataSource(inputFile, 7, inputDataType);
        } else if (inputModel.equals("sh")) {
            data = new VoxelOrderDataSource(inputFile, SphericalHarmonics.evenFuncsUpTo(maxOrder) + 2, inputDataType);
        } else if (inputModel.equals("rbf")) {
            data = new VoxelOrderDataSource(inputFile, RBF_Sum.numPoints() + 2, inputDataType);
        } else if (inputModel.equals("maxent")) {
            data = new VoxelOrderDataSource(inputFile, MaxEntProfile.numLambdas() + 2, inputDataType);
        } else {
            RuntimeException runtimeException = new RuntimeException("Unknown input model type: " + inputModel);
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            String string = new String();
            logger.severe(runtimeException.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i] + "\n";
            }
            logger.severe(string);
            throw runtimeException;
        }
        CL_Initializer.initMaskSource();
    }

    public static void initTensorDataSource() {
        if (inputModel.equals("dt")) {
            data = new VoxelOrderDataSource(inputFile, 8, inputDataType);
        } else if (inputModel.equals("twotensor")) {
            data = new VoxelOrderDataSource(inputFile, 17, inputDataType);
        } else if (inputModel.equals("threetensor")) {
            data = new VoxelOrderDataSource(inputFile, 24, inputDataType);
        } else if (inputModel.equals("multitensor")) {
            data = new VoxelOrderDataSource(inputFile, 3 + 7 * maxTensorComponents, inputDataType);
        } else {
            throw new LoggedException("Cannot process non-tensor data from model: " + inputModel);
        }
        CL_Initializer.initMaskSource();
    }

    public static void initMaskSource() {
        if (bgMaskFile != null) {
            if (ImageHeader.imageExists(bgMaskFile)) {
                ImageHeader imageHeader = null;
                try {
                    imageHeader = ImageHeader.readHeader(bgMaskFile);
                }
                catch (IOException iOException) {
                    throw new LoggedException("Cannot read mask header " + bgMaskFile);
                }
                bgMask = imageHeader.getImageDataSource();
            } else {
                bgMask = new VoxelOrderDataSource(bgMaskFile, 1, bgMaskType);
            }
        }
    }

    private static void initCompartmentModel(String[] stringArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = Integer.parseInt(stringArray[n + 1]);
        CL_Initializer.markAsParsed(n + 1);
        String[] stringArray2 = new String[n5];
        CompartmentType[] compartmentTypeArray = new CompartmentType[n5];
        double[][] dArrayArray = new double[n5][];
        int n6 = 2;
        double d = 0.0;
        int n7 = n5 + 1;
        for (int i = 0; i < n5; ++i) {
            CompartmentType compartmentType;
            stringArray2[i] = stringArray[n + n6];
            compartmentTypeArray[i] = compartmentType = CompartmentType.getCompartmentType(stringArray2[i]);
            n4 = compartmentType.numParams;
            dArrayArray[i] = new double[n4 + 1];
            CL_Initializer.markAsParsed(n + n6);
            ++n6;
            n7 += n4;
            if (i < n5 - 1) {
                dArrayArray[i][0] = Double.parseDouble(stringArray[n + n6]);
                if (dArrayArray[i][0] < 0.0) {
                    throw new LoggedException("negative volume fraction specified in compartment model initialisation");
                }
                d += dArrayArray[i][0];
                CL_Initializer.markAsParsed(n + n6);
                ++n6;
            } else if (d < 1.0) {
                dArrayArray[i][0] = 1.0 - d;
            } else {
                throw new LoggedException("specified volume fractions in compartment model sum to greater than 1.");
            }
            for (n3 = 0; n3 < n4; ++n3) {
                dArrayArray[i][n3 + 1] = Double.parseDouble(stringArray[n + n6]);
                CL_Initializer.markAsParsed(n + n6);
                ++n6;
            }
        }
        logger.info("Compartment model specified");
        logger.info("There are " + n5 + " compartments:");
        String string = new String();
        for (int i = 0; i < stringArray2.length; ++i) {
            string = string + "\n\t" + (Object)((Object)compartmentTypeArray[i]) + ": vol frac= " + dArrayArray[i][0] + " params = ";
            for (n4 = 1; n4 < dArrayArray[i].length; ++n4) {
                string = string + " " + dArrayArray[i][n4];
            }
        }
        logger.info(string + "\n");
        double[] dArray = new double[n7];
        n4 = n5 + 1;
        dArray[0] = 1.0;
        for (n3 = 0; n3 < dArrayArray.length; ++n3) {
            dArray[n3 + 1] = dArrayArray[n3][0];
            for (n2 = 1; n2 < dArrayArray[n3].length; ++n2) {
                dArray[n4] = dArrayArray[n3][n2];
                ++n4;
            }
        }
        String string2 = new String("linearised params array is:");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            string2 = string2 + dArray[n2] + " ";
        }
        logger.info(string2);
        compartmentNames = stringArray2;
        compParams = dArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initDataSynthesizer() {
        if (testFunction >= 0) {
            if (rotationIndex > 0) {
                StandardTestFunctions.setTransformation(Rotations.randomRotMat(new Random(rotationIndex)));
            }
            if (scale > 0.0) {
                StandardTestFunctions.setScale(scale);
            }
            if (dt2rotangle != 0.0) {
                StandardTestFunctions.setDT2RotationAngle(dt2rotangle);
            }
            if (dt2mix > 0.0) {
                StandardTestFunctions.setMix3(1.0 - dt2mix);
            }
            if (lambda1 > 0.0) {
                StandardTestFunctions.setLambda1(lambda1);
            }
            p = StandardTestFunctions.getFunction(testFunction);
        }
        if (nonStandardTestFunction) {
            p = CL_Initializer.constructTestFunction(testFunctionData);
        }
        if (p != null) {
            if (bootstrap > 0 && wildBootstrapModel != null) {
                DataSource dataSource = CL_Initializer.getDataSynthesizer(p, imPars, SNR, 1, seed, -1);
                if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                data = new WildBS_DT_DataSynth(dataSource, imPars, numVoxels, seed);
                return;
            } else {
                data = CL_Initializer.getDataSynthesizer(p, imPars, SNR, numVoxels, seed, bootstrap);
            }
            return;
        }
        if (inputModel == null) {
            if (compartmentModel && !modelfitting) {
                data = new CompartmentModel(compartmentNames, compParams, imPars);
            }
            if (brownianSimulation) {
                SimulableScheme simulableScheme;
                Object var0_1 = null;
                if (SimulationParams.trajectories) {
                    simParams = new SimulationParams(SimulationParams.sim_N_walkers, SimulationParams.sim_tmax, SimulationParams.sim_p, SimulationParams.sim_initial, SimulationParams.sim_geomType, SimulationParams.sim_stepType, SimulationParams.sim_voxelSize, SimulationParams.duration);
                } else {
                    try {
                        simulableScheme = (SimulableScheme)((Object)imPars);
                    }
                    catch (ClassCastException classCastException) {
                        throw new LoggedException("specified schemefile is not compatible with simulation. dynamics require all scan params to be specified.");
                    }
                    simParams = new SimulationParams(SimulationParams.sim_N_walkers, SimulationParams.sim_tmax, SimulationParams.sim_p, SimulationParams.sim_initial, SimulationParams.sim_geomType, SimulationParams.sim_stepType, SimulationParams.sim_voxelSize, (SimulableScheme)((Object)imPars));
                }
                double[] dArray = StepGeneratorFactory.getStepParamsArray(SimulationParams.sim_stepType, simParams);
                simParams.setStepParams(dArray);
                if (bootstrap > 0) {
                    Object object;
                    int n = numVoxels;
                    numVoxels = bootstrap;
                    try {
                        object = (SimulableScheme)((Object)imPars);
                    }
                    catch (ClassCastException classCastException) {
                        throw new LoggedException("specified schemefile is not compatible with simulation. dynamics require all scan params to be specified.");
                    }
                    object = new DiffusionSimulation(simParams, (SimulableScheme)((Object)imPars));
                    numVoxels = n;
                    if (wildBootstrapModel != null) {
                        if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                        data = new WildBS_DT_DataSynth(data, imPars, numVoxels, seed);
                    }
                    data = new BootstrapDataSynthFromSimulationInput((DiffusionSimulation)object, bootstrap, imPars.numMeasurements(), numVoxels, seed);
                    return;
                }
                if (SimulationParams.trajectories) {
                    data = new DiffusionSimulation(simParams);
                    return;
                }
                try {
                    simulableScheme = (SimulableScheme)((Object)imPars);
                }
                catch (ClassCastException classCastException) {
                    throw new LoggedException("specified schemefile is not compatible with simulation. dynamics require all scan params to be specified.");
                }
                data = new DiffusionSimulation(simParams, (SimulableScheme)((Object)imPars));
                return;
            }
            if (bootstrap > 0) {
                if (SNR > -1.0) {
                    logger.warning("Cannot set SNR when bootstrapping raw data.Program will continue but will not add noise");
                }
                if (wildBootstrapModel != null) {
                    data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
                    if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                    data = new WildBS_DT_DataSynth(data, imPars, numVoxels, seed);
                    return;
                } else {
                    data = new BootstrapDataSynthesizer(bsDataFiles, imPars.numMeasurements(), numVoxels, inputDataType, seed);
                }
                return;
            } else {
                if (compartmentModel && !modelfitting && (compartmentModel || modelfitting)) return;
                data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
                CL_Initializer.initMaskSource();
            }
            return;
        }
        if (bootstrap > 0) {
            void var0_9;
            Object var0_3 = null;
            double d = -1.0;
            if (wildBootstrapModel != null) {
                d = SNR;
            }
            if (inputModel.equals("dt")) {
                DataSynthFromDT_Input dataSynthFromDT_Input = new DataSynthFromDT_Input(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("twotensor")) {
                DataSynthFromTwoTensorInput dataSynthFromTwoTensorInput = new DataSynthFromTwoTensorInput(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("threetensor")) {
                DataSynthFromThreeTensorInput dataSynthFromThreeTensorInput = new DataSynthFromThreeTensorInput(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("multitensor")) {
                DataSynthFromMultiTensorInput dataSynthFromMultiTensorInput = new DataSynthFromMultiTensorInput(inputFile, inputDataType, imPars, maxTensorComponents, d, seed);
            } else {
                if (!inputModel.equals("ballstick")) throw new LoggedException("Unrecognized input model: " + inputModel);
                DataSynthFromBallStickInput dataSynthFromBallStickInput = new DataSynthFromBallStickInput(inputFile, inputDataType, imPars, d, seed);
            }
            if (wildBootstrapModel != null) {
                if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                data = new WildBS_DT_DataSynth((DataSource)var0_9, imPars, numVoxels, seed);
                return;
            } else {
                data = new BootstrapDataSynthFromInput((DataSynthFromInput)var0_9, bootstrap, imPars, numVoxels, SNR, seed);
            }
            return;
        } else if (inputModel.equals("dt")) {
            data = new DataSynthFromDT_Input(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("twotensor")) {
            data = new DataSynthFromTwoTensorInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("threetensor")) {
            data = new DataSynthFromThreeTensorInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("multitensor")) {
            data = new DataSynthFromMultiTensorInput(inputFile, inputDataType, imPars, maxTensorComponents, SNR, seed);
            return;
        } else if (inputModel.equals("ballstick")) {
            data = new DataSynthFromBallStickInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else {
            if (inputModel.equals("sh") || inputModel.equals("rbf")) return;
            throw new LoggedException("Unrecognized input model: " + inputModel);
        }
    }

    public static ModelPDF constructTestFunction(double[] dArray) {
        int n = (int)dArray[0];
        DT[] dTArray = new DT[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dTArray[i] = new DT(dArray[i * 7 + 1], dArray[i * 7 + 2], dArray[i * 7 + 3], dArray[i * 7 + 4], dArray[i * 7 + 5], dArray[i * 7 + 6]);
            dArray2[i] = dArray[i * 7 + 7];
            if (rotationIndex <= 0) continue;
            dTArray[i] = dTArray[i].transform(Rotations.randomRotMat(new Random(rotationIndex)));
        }
        GaussianMixture gaussianMixture = new GaussianMixture(dTArray, dArray2);
        return gaussianMixture;
    }

    public static DataSource getDataSynthesizer(ModelPDF modelPDF, DW_Scheme dW_Scheme, double d, int n, int n2, int n3) {
        DataSource dataSource = null;
        if (n3 <= 0) {
            MTRandom mTRandom = new MTRandom(n2);
            dataSource = new DataSynthesizer(modelPDF, dW_Scheme, d, n, mTRandom);
        } else {
            dataSource = new SyntheticBootstrapper(modelPDF, dW_Scheme, d, n3, n, n2);
        }
        return dataSource;
    }

    public static final void markAsParsed(int n) {
        CL_Initializer.markAsParsed(n, 1);
    }

    public static final void markAsParsed(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            CL_Initializer.parsed[n + i] = true;
        }
    }

    public static void exceptionTest() throws Exception {
        throw new Exception("test exception thrown");
    }

    public static void testCompartmetnParsing() {
        System.err.println("well-formatted, 3-comp model:");
        String string = new String("-model compartment 3 Ball 0.01 1.0 STICK 0.02 2.0 0.2 0.2 cYlindergpd 0.3 1.3 0.3 0.03");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        parsed = new boolean[stringArray.length];
        for (n2 = 0; n2 < parsed.length; ++n2) {
            CL_Initializer.parsed[n2] = false;
        }
        CL_Initializer.initCompartmentModel(stringArray, 1);
        CompartmentModel compartmentModel = new CompartmentModel(compartmentNames, compParams);
        CL_Initializer.checkParsing(stringArray);
        System.err.println("\n\n3-comps, negative vol frac:");
        string = new String("-model compartment 3 Ball 0.09 1.0 tensor -0.02 1.0 0.0 0.0 1.0 0.0 1.0 cYlindergpd 0.1 1.1 0.3 0.4");
        stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        stringArray = new String[n];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        parsed = new boolean[stringArray.length];
        for (n3 = 0; n3 < parsed.length; ++n3) {
            CL_Initializer.parsed[n3] = false;
        }
        CL_Initializer.initCompartmentModel(stringArray, 1);
        try {
            compartmentModel = new CompartmentModel(compartmentNames, compParams);
        }
        catch (LoggedException loggedException) {
            System.err.println("exception caught:");
            loggedException.printStackTrace();
        }
        CL_Initializer.checkParsing(stringArray);
        System.err.println("\n\n3-comps, vol fracs > 1:");
        string = new String("-model compartment 3 Ball 0.09 1.0 tensor 0.99 1.0 0.0 0.0 1.0 0.0 1.0 cYlindergpd 0.1 1.1 0.3 0.4");
        stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        stringArray = new String[n];
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n4] = stringTokenizer.nextToken();
            ++n4;
        }
        parsed = new boolean[stringArray.length];
        for (n4 = 0; n4 < parsed.length; ++n4) {
            CL_Initializer.parsed[n4] = false;
        }
        CL_Initializer.initCompartmentModel(stringArray, 1);
        try {
            compartmentModel = new CompartmentModel(compartmentNames, compParams);
        }
        catch (LoggedException loggedException) {
            System.err.println("exception caught:");
            loggedException.printStackTrace();
        }
        CL_Initializer.checkParsing(stringArray);
        System.err.println("\n\n3-comps, too few parameters");
        string = new String("-model compartment 3 Ball 0.09 1.0 tensor 0.02 1.0 0.0 0.0 cYlindergpd 0.1 1.1 0.4");
        stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        stringArray = new String[n];
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n5] = stringTokenizer.nextToken();
            ++n5;
        }
        parsed = new boolean[stringArray.length];
        for (n5 = 0; n5 < parsed.length; ++n5) {
            CL_Initializer.parsed[n5] = false;
        }
        CL_Initializer.initCompartmentModel(stringArray, 1);
        try {
            compartmentModel = new CompartmentModel(compartmentNames, compParams);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("exception caught:");
            numberFormatException.printStackTrace();
        }
        CL_Initializer.checkParsing(stringArray);
    }

    public static void main(String[] stringArray) {
        CL_Initializer.testCompartmetnParsing();
    }

    public static void initInputSpaceAndHeaderOptions() {
        if (headerTemplateFile != null) {
            ImageHeader imageHeader;
            try {
                imageHeader = ImageHeader.readHeader(headerTemplateFile);
            }
            catch (Exception exception) {
                throw new LoggedException(exception + "\n\n    Can't use " + headerTemplateFile + " to define input space.");
            }
            if (dataDims[0] > 0) {
                int[] nArray = imageHeader.getDataDims();
                for (int i = 0; i < 3; ++i) {
                    if (nArray[i] == dataDims[i]) continue;
                    throw new LoggedException("Command line data dimensions inconsistent with input header");
                }
                double[] dArray = imageHeader.getVoxelDims();
                for (int i = 0; i < 3; ++i) {
                    if (!(Math.abs(dArray[i] - (double)dataDims[i]) > 1.0E-6)) continue;
                    throw new LoggedException("Command line voxel dimensions inconsistent with input header");
                }
            } else {
                dataDims = imageHeader.getDataDims();
                voxelDims = imageHeader.getVoxelDims();
                for (int i = 0; i < 3; ++i) {
                    if (!(voxelDims[i] < 0.0)) continue;
                    logger.warning("Negative voxel dimensions detected, using absolute values, physical space may be misaligned");
                    CL_Initializer.voxelDims[i] = Math.abs(voxelDims[i]);
                }
            }
            headerTemplate = imageHeader;
            headerTemplate.setDataType(OutputManager.outputDataType);
            if (headerTemplateFile.endsWith(".gz")) {
                headerTemplate.setGzip(true);
            } else {
                headerTemplate.setGzip(OutputManager.gzipOut);
            }
        } else {
            Nifti1Dataset nifti1Dataset = new Nifti1Dataset();
            nifti1Dataset.setDims(4, dataDims[0], dataDims[1], dataDims[2], 1, 0, 0, 0);
            nifti1Dataset.setPixDims(1.0f, (float)voxelDims[0], (float)voxelDims[1], (float)voxelDims[2], 0.0f, 1.0f, 1.0f, 1.0f);
            nifti1Dataset.setQuaternion((short)1, (short)1, new float[]{0.0f, 0.0f, 0.0f}, new float[]{0.0f, 0.0f, 0.0f});
            nifti1Dataset.setDataType(OutputManager.outputDataType);
            nifti1Dataset.setFilename("caminoHeaderTemplate", true, OutputManager.gzipOut);
            headerTemplate = nifti1Dataset;
        }
    }

    static {
        lrNormalize = false;
        lrLog = false;
        inputDataType = "float";
        bgMaskType = "short";
        inputModel = null;
        compartmentNames = null;
        compParams = null;
        basisType = 1;
        pointSetInd = 3;
        pointSetIndSet = false;
        numPDsIO = 3;
        maxOrder = 4;
        f1 = -1.0;
        f2 = -1.0;
        f3 = -1.0;
        kernelParams = new double[]{0.0, 1.0};
        mePointSet = -1;
        BACKGROUNDTHRESHOLD = 0.0;
        CSFTHRESHOLD = -1.0;
        imPars = null;
        p = null;
        data = null;
        bgMask = null;
        parsed = null;
        transformFile = null;
        transformFileX = null;
        transformFileY = null;
        transformFileZ = null;
        reorientation = "ppd";
        burnInTime = 1000;
        samples = 100;
        interval = 100;
        mcmcStatsFile = null;
    }
}

