/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.ArrayList;
import java.util.Hashtable;
import tractography.Voxel;

public abstract class CP_StatMap {
    protected int numberOfImages;
    protected final int xDataDim;
    protected final int yDataDim;
    protected final int zDataDim;
    protected final Hashtable<Object, ArrayList<Double>> voxels;

    public CP_StatMap(int n, int n2, int n3) {
        this.xDataDim = n;
        this.yDataDim = n2;
        this.zDataDim = n3;
        this.numberOfImages = 0;
        this.voxels = new Hashtable();
    }

    public void addImage(double[][][] dArray) {
        ++this.numberOfImages;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (!(dArray[i][j][k] > 0.0)) continue;
                    Voxel voxel = new Voxel(i, j, k);
                    ArrayList<Double> arrayList = this.voxels.get(voxel);
                    if (arrayList != null) {
                        arrayList.add(new Double(dArray[i][j][k]));
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(new Double(dArray[i][j][k]));
                    this.voxels.put(voxel, arrayList);
                }
            }
        }
    }

    public abstract double[][][] result();
}

