/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Arrays;
import tractography.Tract;
import tractography.TractCollection;
import tractography.Voxel;

public class ConnectionProbabilityImage {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private final int[][][] streamlineCounts;
    private int totalStreamlines = 0;

    public ConnectionProbabilityImage(int n, int n2, int n3, double d, double d2, double d3) {
        this.xDataDim = n;
        this.yDataDim = n2;
        this.zDataDim = n3;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        this.streamlineCounts = new int[n][n2][n3];
    }

    public final void processTracts(TractCollection tractCollection) {
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            this.processTract(tractCollection.getTract(i));
        }
    }

    public final void processTract(Tract tract) {
        ++this.totalStreamlines;
        Object[] objectArray = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim).getVoxels();
        int n = objectArray.length;
        Arrays.sort(objectArray);
        Object object = objectArray[0];
        int[] nArray = this.streamlineCounts[((Voxel)objectArray[0]).x][((Voxel)objectArray[0]).y];
        int n2 = ((Voxel)objectArray[0]).z;
        nArray[n2] = nArray[n2] + 1;
        for (int i = 1; i < n; ++i) {
            if (((Voxel)objectArray[i]).x == ((Voxel)object).x && ((Voxel)objectArray[i]).y == ((Voxel)object).y && ((Voxel)objectArray[i]).z == ((Voxel)object).z) continue;
            int[] nArray2 = this.streamlineCounts[((Voxel)objectArray[i]).x][((Voxel)objectArray[i]).y];
            int n3 = ((Voxel)objectArray[i]).z;
            nArray2[n3] = nArray2[n3] + 1;
            object = objectArray[i];
        }
    }

    public double[][][] getStreamlineCounts() {
        double[][][] dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    dArray[i][j][k] = this.streamlineCounts[i][j][k];
                }
            }
        }
        return dArray;
    }

    public double[][][] getConnectionProbabilities() {
        double[][][] dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        double d = this.totalStreamlines;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    dArray[i][j][k] = (double)this.streamlineCounts[i][j][k] / d;
                }
            }
        }
        return dArray;
    }

    public int totalStreamlines() {
        return this.totalStreamlines;
    }
}

