/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.logging.Logger;
import numerics.Vector3D;
import tractography.RegionOfInterest;
import tractography.TargetCP_Image;
import tractography.TractCollection;
import tractography.Voxel;

public class ConnectivitySegmentedImage {
    private static Logger logger = Logger.getLogger("camino.tractography.ConnectivitySegmentedImage");
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private RegionOfInterest roi = null;
    private Voxel[] seedVoxels = null;
    private int numSeeds = 0;
    private int[][][] targets;
    private boolean directional = false;
    private Vector3D forwards = null;
    private boolean countFirstEntry = true;
    private double[][][] labelledSeedImage = null;
    private double[][][] targetSCImage;
    private double[][][] targetCPImage;
    TargetCP_Image[] seedTargetCP;

    public ConnectivitySegmentedImage(RegionOfInterest regionOfInterest, int[][][] nArray, double d, double d2, double d3) {
        this.roi = regionOfInterest;
        this.seedVoxels = this.roi.getSeedVoxels(d, d2, d3);
        this.numSeeds = this.seedVoxels.length;
        this.seedTargetCP = new TargetCP_Image[this.numSeeds];
        for (int i = 0; i < this.numSeeds; ++i) {
            this.seedTargetCP[i] = new TargetCP_Image(nArray, d, d2, d3);
        }
        this.targets = nArray;
        this.xDataDim = nArray.length;
        this.yDataDim = nArray[0].length;
        this.zDataDim = nArray[0][0].length;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
    }

    public void processTracts(int n, TractCollection tractCollection) {
        this.labelledSeedImage = null;
        this.targetSCImage = null;
        this.targetCPImage = null;
        this.seedTargetCP[n].processTracts(tractCollection);
    }

    public double[][][] getSegmentedSeeds() {
        double[][][] dArray;
        if (this.labelledSeedImage == null) {
            dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            double[][][] dArray2 = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            double[][][] dArray3 = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            for (int i = 0; i < this.numSeeds; ++i) {
                double d = this.seedTargetCP[i].totalStreamlines();
                int n = this.seedVoxels[i].x;
                int n2 = this.seedVoxels[i].y;
                int n3 = this.seedVoxels[i].z;
                int[][] nArray = this.seedTargetCP[i].getNonZeroStreamlineCounts();
                int n4 = 0;
                int n5 = 0;
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j][1] <= n4) continue;
                    n5 = nArray[j][0];
                    n4 = nArray[j][1];
                }
                dArray[n][n2][n3] = n5;
                dArray2[n][n2][n3] = n4;
                dArray3[n][n2][n3] = d > 0.0 ? (double)n4 / d : 0.0;
            }
            this.targetCPImage = dArray3;
            this.targetSCImage = dArray2;
            this.labelledSeedImage = dArray;
        }
        dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                System.arraycopy(this.labelledSeedImage[i][j], 0, dArray[i][j], 0, this.zDataDim);
            }
        }
        return dArray;
    }

    public double[][][] getMaxTargetCP() {
        if (this.targetCPImage == null) {
            this.getSegmentedSeeds();
        }
        double[][][] dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                System.arraycopy(this.targetCPImage[i][j], 0, dArray[i][j], 0, this.zDataDim);
            }
        }
        return dArray;
    }

    public double[][][] getMaxTargetSC() {
        if (this.targetSCImage == null) {
            this.getSegmentedSeeds();
        }
        double[][][] dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                System.arraycopy(this.targetSCImage[i][j], 0, dArray[i][j], 0, this.zDataDim);
            }
        }
        return dArray;
    }

    public void setCountFirstEntry(boolean bl) {
        this.countFirstEntry = bl;
        for (int i = 0; i < this.numSeeds; ++i) {
            this.seedTargetCP[i].setCountFirstEntry(this.countFirstEntry);
        }
    }
}

