/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import misc.LoggedException;
import numerics.Vector3D;
import tractography.TractographyImage;

public class PD_TractographyImage
extends TractographyImage {
    public PD_TractographyImage(VoxelOrderDataSource voxelOrderDataSource, int n, int[] nArray, double[] dArray) {
        super(nArray, dArray, 1);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double[] dArray2 = voxelOrderDataSource.nextVoxel();
                    if (dArray2[0] < 0.0) {
                        this.numPDs[k][j][i] = 0;
                    } else {
                        this.numPDs[k][j][i] = (int)dArray2[2];
                        if (this.numPDs[k][j][i] > n) {
                            this.numPDs[k][j][i] = n;
                        }
                    }
                    if (this.numPDs[k][j][i] < 0) {
                        throw new LoggedException("Invalid number of components in input data. Check -inputmodel and -numpds options");
                    }
                    this.vectors[k][j][i] = new Vector3D[this.numPDs[k][j][i]];
                    for (int i2 = 0; i2 < this.numPDs[k][j][i]; ++i2) {
                        int n2 = 6 + i2 * 8;
                        this.vectors[k][j][i][i2] = new Vector3D(dArray2[n2], dArray2[n2 + 1], dArray2[n2 + 2]);
                    }
                }
            }
        }
        this.computeIsotropicMask();
    }

    public PD_TractographyImage(Vector3D[][][][] vector3DArray, double[] dArray, int n) {
        super(vector3DArray, dArray, n);
    }

    public PD_TractographyImage(int[] nArray, double[] dArray, int n) {
        super(nArray, dArray, n);
    }

    protected PD_TractographyImage(PD_TractographyImage pD_TractographyImage) {
        super(new int[]{pD_TractographyImage.xDataDim, pD_TractographyImage.yDataDim, pD_TractographyImage.zDataDim}, new double[]{pD_TractographyImage.xVoxelDim, pD_TractographyImage.yVoxelDim, pD_TractographyImage.zVoxelDim}, 1);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int n = pD_TractographyImage.vectors[k][j][i].length;
                    this.vectors[k][j][i] = new Vector3D[n];
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.vectors[k][j][i][i2] = pD_TractographyImage.vectors[k][j][i][i2];
                    }
                    this.numPDs[k][j][i] = pD_TractographyImage.numPDs[k][j][i];
                }
            }
        }
        this.computeIsotropicMask();
    }

    public static final PD_TractographyImage getPD_TractographyImage(String string, String string2, int n, double[][][] dArray, double d, int[] nArray, double[] dArray2) {
        int n2 = 6 + 8 * n;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n2, string2);
        PD_TractographyImage pD_TractographyImage = new PD_TractographyImage(voxelOrderDataSource, n, nArray, dArray2);
        if (dArray != null) {
            pD_TractographyImage.computeIsotropicMask(dArray, d);
        }
        return pD_TractographyImage;
    }
}

