/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.ImageHeader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.Point3D;
import numerics.RealMatrix;
import tractography.RegionOfInterest;
import tractography.Voxel;

public final class PointListROI
implements RegionOfInterest {
    private final Point3D[] points;
    private final int label;

    public PointListROI(Point3D[] point3DArray, int n) {
        this.points = new Point3D[point3DArray.length];
        System.arraycopy(point3DArray, 0, this.points, 0, this.points.length);
        this.label = n;
    }

    protected PointListROI(int[][][] nArray, int n, double d, double d2, double d3) {
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = nArray[0][0].length;
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>(100);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (nArray[k][j][i] != n) continue;
                    Point3D point3D = new Point3D(((double)k + 0.5) * d, ((double)j + 0.5) * d2, ((double)i + 0.5) * d3);
                    arrayList.add(point3D);
                }
            }
        }
        this.points = arrayList.toArray(new Point3D[0]);
        this.label = n;
    }

    public static PointListROI readPoints(String string, ImageHeader imageHeader) {
        Object object;
        Object object2;
        Object object3;
        Point3D[] point3DArray = null;
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>(100);
        try {
            object3 = new InputStreamReader(new FileInputStream(string));
            object2 = new BufferedReader((Reader)object3);
            String string2 = ((BufferedReader)object2).readLine();
            while (string2 != null && ((String[])(object = string2.split("\\s+"))).length >= 3) {
                Point3D point3D = new Point3D(Double.parseDouble(object[0]), Double.parseDouble(object[1]), Double.parseDouble(object[2]));
                arrayList.add(point3D);
                string2 = ((BufferedReader)object2).readLine();
            }
            point3DArray = new Point3D[arrayList.size()];
            arrayList.toArray(point3DArray);
            ((InputStreamReader)object3).close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        object3 = imageHeader.getPhysicalToVoxelTransform();
        object2 = imageHeader.getVoxelDims();
        for (int i = 0; i < point3DArray.length; ++i) {
            object = point3DArray[i].transform((RealMatrix)object3);
            point3DArray[i] = new Point3D((object.x + 0.5) * object2[0], (object.y + 0.5) * object2[1], (object.z + 0.5) * object2[2]);
        }
        return new PointListROI(point3DArray, 1);
    }

    @Override
    public Point3D[] getSeedPoints() {
        Point3D[] point3DArray = new Point3D[this.points.length];
        System.arraycopy(this.points, 0, point3DArray, 0, this.points.length);
        return point3DArray;
    }

    @Override
    public Voxel[] getSeedVoxels(double d, double d2, double d3) {
        Voxel[] voxelArray = new Voxel[this.points.length];
        for (int i = 0; i < voxelArray.length; ++i) {
            voxelArray[i] = new Voxel((int)(this.points[i].x / d), (int)(this.points[i].y / d2), (int)(this.points[i].z / d3));
        }
        return voxelArray;
    }

    @Override
    public int getRegionLabel() {
        return this.label;
    }
}

