/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import misc.DynamicScalarImage;
import misc.ScalarImage;
import misc.SparseVectorImage;
import misc.VoxelwiseStatisticalImage;
import numerics.Point3D;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractStatisticFilter;
import tractography.Voxel;

public class TractStatisticImage {
    private final int[] dataDims;
    private final double[] voxelDims;
    private ScalarImage scalars = null;
    private String imageStat = "mean";
    private TractStatisticFilter tractStat = null;
    private VoxelwiseStatisticalImage image = null;
    private boolean seedVoxelOnly = true;

    public TractStatisticImage(ScalarImage scalarImage) {
        this.scalars = scalarImage;
        this.dataDims = this.scalars.getDataDims();
        this.voxelDims = this.scalars.getVoxelDims();
        this.tractStat = new TractStatisticFilter(this.scalars);
    }

    public TractStatisticImage(double[][][] dArray, double[] dArray2) {
        this.scalars = new ScalarImage(dArray, dArray2);
        this.dataDims = this.scalars.getDataDims();
        this.voxelDims = this.scalars.getVoxelDims();
        this.tractStat = new TractStatisticFilter(dArray, dArray2);
    }

    public TractStatisticImage(int[] nArray, double[] dArray) {
        this.dataDims = nArray;
        this.voxelDims = dArray;
        this.tractStat = new TractStatisticFilter(nArray, dArray);
        this.tractStat.setTractStatistic("length");
    }

    public void setTractStatistic(String string) {
        this.tractStat.setTractStatistic(string);
    }

    public void setImageStatistic(String string) {
        this.imageStat = string;
        this.image = this.imageStat.equals("median") || this.imageStat.equals("var") ? new SparseVectorImage(this.dataDims, this.voxelDims) : new DynamicScalarImage(this.dataDims, this.voxelDims);
    }

    public void setInterpolate(boolean bl) {
        this.tractStat.setInterpolate(bl);
    }

    public void setCountIntersect(boolean bl) {
        this.seedVoxelOnly = !bl;
    }

    public void processTracts(TractCollection tractCollection) {
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            this.processTract(tractCollection.getTract(i));
        }
    }

    public void processTract(Tract tract) {
        double d = this.tractStat.processTract(tract)[0];
        if (this.seedVoxelOnly) {
            Point3D point3D = tract.getPoint(tract.seedPointIndex());
            this.image.addValue(point3D, d);
        } else {
            Voxel[] voxelArray = tract.toVoxelList(this.voxelDims[0], this.voxelDims[1], this.voxelDims[2]).getVoxels();
            double[] dArray = tract.getVoxelPathLengths(this.voxelDims[0], this.voxelDims[1], this.voxelDims[2]);
            for (int i = 0; i < voxelArray.length; ++i) {
                this.image.addValue(voxelArray[i].x, voxelArray[i].y, voxelArray[i].z, d, dArray[i]);
            }
        }
    }

    public double[][][] getImageStatistic() {
        return this.image.getVoxelStatistic(this.imageStat);
    }
}

