/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.ImageHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import misc.LoggedException;
import numerics.Point3D;
import numerics.RealMatrix;
import tractography.PointListROI;
import tractography.ROI_Collection;
import tractography.RegionOfInterest;

public final class VoxelROI
implements ROI_Collection {
    private final PointListROI[] regions;
    private final int[] regionLabels;
    private final int numberOfRegions;

    public VoxelROI(String string, ImageHeader imageHeader) {
        int n;
        ImageHeader imageHeader2 = null;
        try {
            imageHeader2 = ImageHeader.readHeader(string);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        RealMatrix realMatrix = imageHeader2.getVoxelToPhysicalTransform();
        RealMatrix realMatrix2 = imageHeader.getPhysicalToVoxelTransform();
        boolean bl = imageHeader2.sameSpace(imageHeader);
        double[][][] dArray = imageHeader2.readSingleVolumeData();
        int n2 = imageHeader2.xDataDim();
        int n3 = imageHeader2.yDataDim();
        int n4 = imageHeader2.zDataDim();
        HashMap hashMap = new HashMap(100, 0.75f);
        for (int i = 0; i < n4; ++i) {
            for (n = 0; n < n3; ++n) {
                for (int j = 0; j < n2; ++j) {
                    if (!(dArray[j][n][i] > 0.0)) continue;
                    Integer n5 = new Integer((int)dArray[j][n][i]);
                    ArrayList<Point3D> arrayList = null;
                    if (hashMap.containsKey(n5)) {
                        arrayList = (ArrayList<Point3D>)hashMap.get(n5);
                    } else {
                        arrayList = new ArrayList<Point3D>(100);
                        hashMap.put(n5, arrayList);
                    }
                    Point3D point3D = new Point3D(j, n, i);
                    if (!bl) {
                        point3D = new Point3D(j, n, i).transform(realMatrix).transform(realMatrix2);
                    }
                    Point3D point3D2 = new Point3D((point3D.x + 0.5) * imageHeader.xVoxelDim(), (point3D.y + 0.5) * imageHeader.yVoxelDim(), (point3D.z + 0.5) * imageHeader.zVoxelDim());
                    arrayList.add(point3D2);
                }
            }
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[hashMap.size()]);
        Arrays.sort(objectArray);
        this.numberOfRegions = objectArray.length;
        this.regionLabels = new int[this.numberOfRegions];
        this.regions = new PointListROI[this.numberOfRegions];
        for (n = 0; n < objectArray.length; ++n) {
            Point3D[] point3DArray = ((ArrayList)hashMap.get(objectArray[n])).toArray(new Point3D[((ArrayList)hashMap.get(objectArray[n])).size()]);
            this.regions[n] = new PointListROI(point3DArray, (Integer)objectArray[n]);
            this.regionLabels[n] = (Integer)objectArray[n];
        }
    }

    @Override
    public int numberOfRegions() {
        return this.numberOfRegions;
    }

    @Override
    public RegionOfInterest getRegion(int n) {
        int n2 = Arrays.binarySearch(this.regionLabels, n);
        if (n2 > -1) {
            return this.regions[n2];
        }
        throw new LoggedException("No such ROI label " + n);
    }

    @Override
    public RegionOfInterest[] getAllRegions() {
        RegionOfInterest[] regionOfInterestArray = new RegionOfInterest[this.numberOfRegions];
        System.arraycopy(this.regions, 0, regionOfInterestArray, 0, this.numberOfRegions);
        return regionOfInterestArray;
    }
}

