/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.axisbehavior;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.utils.behaviors.vp.AxisBehavior;

public class ObjLoadAxis
extends Applet {
    private boolean spin = false;
    private boolean noTriangulate = false;
    private boolean noStripify = false;
    private double creaseAngle = 60.0;
    private URL filename = null;
    private SimpleUniverse u;
    private BoundingSphere bounds;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        int flags = 64;
        if (!this.noTriangulate) {
            flags |= 0x80;
        }
        if (!this.noStripify) {
            flags |= 0x200;
        }
        ObjectFile f = new ObjectFile(flags, (float)(this.creaseAngle * Math.PI / 180.0));
        Scene s = null;
        try {
            s = f.load(this.filename);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        objTrans.addChild((Node)s.getSceneGroup());
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        if (this.spin) {
            Transform3D yAxis = new Transform3D();
            Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
            RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
            rotator.setSchedulingBounds((Bounds)this.bounds);
            objTrans.addChild((Node)rotator);
        }
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)this.bounds);
        objRoot.addChild((Node)bgNode);
        return objRoot;
    }

    private void usage() {
        System.out.println("Usage: java ObjLoadAxis [-s] [-n] [-t] [-c degrees] <.obj file>");
        System.out.println("  -s Spin (no user interaction)");
        System.out.println("  -n No triangulation");
        System.out.println("  -t No stripification");
        System.out.println("  -c Set crease angle for normal generation (default is 60 without");
        System.out.println("     smoothing group info, otherwise 180 within smoothing groups)");
        System.exit(0);
    }

    public void init() {
        if (this.filename == null) {
            try {
                URL path = this.getCodeBase();
                this.filename = new URL(String.valueOf(path.toString()) + "./galleon.obj");
            }
            catch (MalformedURLException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        View view = this.u.getViewer().getView();
        view.setMinimumFrameCycleTime(10L);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        PlatformGeometry pg = new PlatformGeometry();
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)this.bounds);
        pg.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)this.bounds);
        pg.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)this.bounds);
        pg.addChild((Node)light2);
        BranchGroup axisRoot = new BranchGroup();
        Transform3D t = new Transform3D();
        t.set(new Vector3d(-0.5, -0.5, -1.5));
        TransformGroup axisTranslation = new TransformGroup(t);
        axisRoot.addChild((Node)axisTranslation);
        TransformGroup axisTG = new TransformGroup();
        axisTG.setCapability(18);
        axisTG.setCapability(17);
        axisTranslation.addChild((Node)axisTG);
        Axis axis = new Axis();
        axisTG.addChild((Node)axis);
        pg.addChild((Node)axisRoot);
        TransformGroup viewPlatformTG = viewingPlatform.getViewPlatformTransform();
        AxisBehavior axisBehavior = new AxisBehavior(axisTG, viewPlatformTG);
        axisBehavior.setSchedulingBounds((Bounds)this.bounds);
        pg.addChild((Node)axisBehavior);
        viewingPlatform.setPlatformGeometry(pg);
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        orbit.setSchedulingBounds((Bounds)this.bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
    }

    public ObjLoadAxis(String[] args) {
        if (args.length != 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-")) {
                    if (args[i].equals("-s")) {
                        this.spin = true;
                    } else if (args[i].equals("-n")) {
                        this.noTriangulate = true;
                    } else if (args[i].equals("-t")) {
                        this.noStripify = true;
                    } else if (args[i].equals("-c")) {
                        if (i < args.length - 1) {
                            this.creaseAngle = new Double(args[++i]);
                        } else {
                            this.usage();
                        }
                    } else {
                        this.usage();
                    }
                } else {
                    try {
                        this.filename = args[i].indexOf("file:") == 0 || args[i].indexOf("http") == 0 ? new URL(args[i]) : (args[i].charAt(0) != '/' ? new URL("file:./" + args[i]) : new URL("file:" + args[i]));
                    }
                    catch (MalformedURLException e) {
                        System.err.println(e);
                        System.exit(1);
                    }
                }
                ++i;
            }
        }
    }

    public ObjLoadAxis() {
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new ObjLoadAxis(args), 700, 700);
    }

    static class Axis
    extends Group {
        private static final float[] axisCoords = new float[]{0.0f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.09f, 0.01f, 0.0f, 0.1f, 0.0f, 0.0f, 0.09f, -0.01f, 0.0f, 0.1f, 0.0f, 0.0f, 0.09f, 0.0f, 0.01f, 0.1f, 0.0f, 0.0f, 0.09f, 0.0f, -0.01f};

        Axis() {
            Transform3D t = new Transform3D();
            PolygonAttributes polygonAttributes = new PolygonAttributes();
            polygonAttributes.setCullFace(0);
            LineAttributes lineAttributes = new LineAttributes();
            lineAttributes.setLineWidth(2.0f);
            ColoringAttributes redColoringAttributes = new ColoringAttributes();
            redColoringAttributes.setColor(new Color3f(1.0f, 0.0f, 0.0f));
            Appearance redAppearance = new Appearance();
            redAppearance.setColoringAttributes(redColoringAttributes);
            redAppearance.setPolygonAttributes(polygonAttributes);
            redAppearance.setLineAttributes(lineAttributes);
            ColoringAttributes greenColoringAttributes = new ColoringAttributes();
            greenColoringAttributes.setColor(new Color3f(0.0f, 1.0f, 0.0f));
            Appearance greenAppearance = new Appearance();
            greenAppearance.setColoringAttributes(greenColoringAttributes);
            greenAppearance.setPolygonAttributes(polygonAttributes);
            greenAppearance.setLineAttributes(lineAttributes);
            ColoringAttributes blueColoringAttributes = new ColoringAttributes();
            blueColoringAttributes.setColor(new Color3f(0.0f, 0.0f, 1.0f));
            Appearance blueAppearance = new Appearance();
            blueAppearance.setColoringAttributes(blueColoringAttributes);
            blueAppearance.setPolygonAttributes(polygonAttributes);
            blueAppearance.setLineAttributes(lineAttributes);
            Font font = new Font(null, 0, 2);
            FontExtrusion extrude = null;
            Font3D f3d = new Font3D(font, extrude);
            t = new Transform3D();
            TransformGroup xAxisTG = new TransformGroup(t);
            LineArray xAxisLineArr = new LineArray(10, 1);
            xAxisLineArr.setCoordinates(0, axisCoords);
            Shape3D xAxisLines = new Shape3D((Geometry)xAxisLineArr, redAppearance);
            xAxisTG.addChild((Node)xAxisLines);
            Text3D xAxisText = new Text3D(f3d, "+X");
            Shape3D xAxisLabel = new Shape3D((Geometry)xAxisText, redAppearance);
            Transform3D xTextScale = new Transform3D();
            xTextScale.set(0.015);
            xTextScale.setTranslation(new Vector3d(0.11, 0.0, 0.0));
            TransformGroup xAxisLabelTG = new TransformGroup(xTextScale);
            xAxisLabelTG.addChild((Node)xAxisLabel);
            xAxisTG.addChild((Node)xAxisLabelTG);
            this.addChild((Node)xAxisTG);
            t = new Transform3D();
            t.rotZ(1.5707963267948966);
            TransformGroup yAxisTG = new TransformGroup(t);
            LineArray yAxisLineArr = new LineArray(10, 1);
            yAxisLineArr.setCoordinates(0, axisCoords);
            Shape3D yAxisLines = new Shape3D((Geometry)yAxisLineArr, greenAppearance);
            yAxisTG.addChild((Node)yAxisLines);
            Text3D yAxisText = new Text3D(f3d, "+Y");
            Shape3D yAxisLabel = new Shape3D((Geometry)yAxisText, greenAppearance);
            Transform3D yTextScale = new Transform3D();
            yTextScale.set(0.015);
            yTextScale.setTranslation(new Vector3d(0.11, 0.0, 0.0));
            TransformGroup yAxisLabelTG = new TransformGroup(yTextScale);
            yAxisLabelTG.addChild((Node)yAxisLabel);
            yAxisTG.addChild((Node)yAxisLabelTG);
            this.addChild((Node)yAxisTG);
            t = new Transform3D();
            t.rotY(-1.5707963267948966);
            TransformGroup zAxisTG = new TransformGroup(t);
            LineArray zAxisLineArr = new LineArray(10, 1);
            zAxisLineArr.setCoordinates(0, axisCoords);
            Shape3D zAxisLines = new Shape3D((Geometry)zAxisLineArr, blueAppearance);
            zAxisTG.addChild((Node)zAxisLines);
            Text3D zAxisText = new Text3D(f3d, "+Z");
            Shape3D zAxisLabel = new Shape3D((Geometry)zAxisText, blueAppearance);
            Transform3D zTextScale = new Transform3D();
            zTextScale.set(0.015);
            zTextScale.setTranslation(new Vector3d(0.11, 0.0, 0.0));
            TransformGroup zAxisLabelTG = new TransformGroup(zTextScale);
            zAxisLabelTG.addChild((Node)zAxisLabel);
            zAxisTG.addChild((Node)zAxisLabelTG);
            this.addChild((Node)zAxisTG);
        }
    }
}

