/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.boundsviewer;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.utils.scenegraph.visualtools.ShowBoundsBehavior;

public class BoundsViewer
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        BranchGroup cubeSet = new BranchGroup();
        ColorCube cube = new ColorCube(0.4);
        cubeSet.addChild((Node)cube);
        Transform3D t3d = new Transform3D();
        t3d.set(1.0, new Vector3d(0.65, 0.0, 0.0));
        TransformGroup cubePos = new TransformGroup(t3d);
        cubePos.addChild((Node)new ColorCube(0.2));
        cubeSet.addChild((Node)cubePos);
        objTrans.addChild((Node)cubeSet);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)rotator);
        BranchGroup toolGroup = new BranchGroup();
        objRoot.addChild((Node)toolGroup);
        ShowBoundsBehavior showBounds = new ShowBoundsBehavior(toolGroup);
        showBounds.showBounds((Node)cubeSet);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new BoundsViewer(), 256, 256);
    }
}

