/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.net.URL;
import java.util.HashMap;
import org.collada.colladaschema.Asset;
import org.collada.colladaschema.CommonNewparamType;
import org.jdesktop.j3d.loaders.collada.xml_walker.LightProcessor;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.SourceProcessor;
import org.jdesktop.j3d.loaders.collada.xml_walker.VerticesProcessor;

public class ElementCache {
    private HashMap<String, SourceProcessor> sourceMap = new HashMap();
    private HashMap<String, VerticesProcessor> verticesMap = new HashMap();
    private HashMap<String, float[]> floatArrayMap = new HashMap();
    private HashMap<String, LightProcessor> lightMap = new HashMap();
    private HashMap<String, String> materialMap = new HashMap();
    private HashMap<String, String> imageMap = new HashMap();
    private HashMap<String, CommonNewparamType> newparamMap = new HashMap();
    private HashMap<String, Processor> map = new HashMap();
    private static ElementCache elementCache = new ElementCache();
    private URL loadingURL = null;
    private Asset asset;

    private ElementCache() {
    }

    public static ElementCache cache() {
        return elementCache;
    }

    public void putSource(String id, SourceProcessor element) {
        this.sourceMap.put(id, element);
    }

    public SourceProcessor getSource(String id) {
        return this.sourceMap.get(this.trim(id));
    }

    public void putVertices(String id, VerticesProcessor element) {
        this.verticesMap.put(id, element);
    }

    public VerticesProcessor getVertices(String id) {
        return this.verticesMap.get(this.trim(id));
    }

    public void putFloatArray(String id, float[] floatArray) {
        assert (id != null);
        this.floatArrayMap.put(id, floatArray);
    }

    public float[] getFloatArray(String id) {
        return this.floatArrayMap.get(this.trim(id));
    }

    public void putLight(String id, LightProcessor light) {
        this.lightMap.put(id, light);
    }

    public LightProcessor getLight(String id) {
        return this.lightMap.get(this.trim(id));
    }

    public void putMaterial(String symbol, String target) {
        this.materialMap.put(symbol, target);
    }

    public String getMaterial(String symbol) {
        return this.materialMap.get(symbol);
    }

    public void putImage(String symbol, String target) {
        this.imageMap.put(symbol, target);
    }

    public String getImage(String symbol) {
        return this.imageMap.get(symbol);
    }

    public void putNewParam(String symbol, CommonNewparamType target) {
        this.newparamMap.put(symbol, target);
    }

    public CommonNewparamType getNewParam(String symbol) {
        return this.newparamMap.get(symbol);
    }

    public void put(String id, Processor proc) {
        this.map.put(id, proc);
    }

    public Processor get(String id) {
        return this.map.get(this.trim(id));
    }

    private String trim(String id) {
        if (id == null) {
            return "";
        }
        return id.substring(1, id.length());
    }

    public URL getLoadingURL() {
        return this.loadingURL;
    }

    public void setLoadingURL(URL loadingURL) {
        this.loadingURL = loadingURL;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }
}

