/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import org.collada.colladaschema.CommonColorOrTextureType;
import org.collada.colladaschema.CommonFloatOrParamType;
import org.collada.colladaschema.CommonNewparamType;
import org.collada.colladaschema.Image;
import org.collada.colladaschema.ProfileCOMMON;
import org.jdesktop.j3d.loaders.collada.utils.Collada14LoaderUtils;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;

public class PhongProcessor
extends Processor {
    private Appearance app = null;
    private ProfileCOMMON.Technique.Phong phong;

    public PhongProcessor(ProfileCOMMON.Technique.Phong phong, Processor parent) {
        super(phong, parent);
        this.phong = phong;
    }

    public void create(Node parent) {
        if (this.app != null) {
            ((Shape3D)parent).setAppearance(this.app);
            return;
        }
        if (parent instanceof Shape3D) {
            Shape3D s3d = (Shape3D)parent;
            this.app = s3d.getAppearance();
        }
        if (this.app == null) {
            this.app = new Appearance();
        }
        if (this.phong != null) {
            CommonFloatOrParamType.Float f;
            CommonFloatOrParamType shininess;
            CommonFloatOrParamType.Float f2;
            CommonFloatOrParamType transparency;
            this.app.setMaterial(new Material());
            CommonColorOrTextureType fccott = this.phong.getAmbient();
            if (fccott != null) {
                this.processColorOrTexture(fccott, this.app, Type.AMBIENT);
            }
            if ((fccott = this.phong.getDiffuse()) != null) {
                this.processColorOrTexture(fccott, this.app, Type.DIFFUSE);
            }
            if ((fccott = this.phong.getEmission()) != null) {
                this.processColorOrTexture(fccott, this.app, Type.EMISSION);
            }
            if ((fccott = this.phong.getSpecular()) != null) {
                this.processColorOrTexture(fccott, this.app, Type.SPECULAR);
            }
            if ((transparency = this.phong.getTransparency()) != null && (f2 = transparency.getFloat()) != null) {
                float fl = (float)f2.getValue();
                if (fl == 1.0f) {
                    fl = 0.0f;
                }
                if (fl > 0.0f) {
                    TransparencyAttributes ta = this.app.getTransparencyAttributes();
                    if (ta == null) {
                        ta = new TransparencyAttributes();
                        this.app.setTransparencyAttributes(ta);
                    }
                    ta.setTransparency(fl);
                    ta.setTransparencyMode(1);
                    ta.setTransparencyMode(2);
                }
            }
            if ((shininess = this.phong.getShininess()) != null && (f = shininess.getFloat()) != null && f.getValue() > 0.0) {
                this.app.getMaterial().setShininess((float)f.getValue());
            }
        }
        ((Shape3D)parent).setAppearance(this.app);
    }

    private void processColorOrTexture(CommonColorOrTextureType colorOrTexture, Appearance app, Type t) {
        CommonColorOrTextureType.Color color = colorOrTexture.getColor();
        if (color != null) {
            Material mat = app.getMaterial();
            List<Double> c = color.getValues();
            float[] result = new float[c.size()];
            int i = 0;
            for (Double d : c) {
                result[i++] = d.floatValue();
            }
            switch (t) {
                case AMBIENT: {
                    mat.setAmbientColor(new Color3f(result));
                    break;
                }
                case DIFFUSE: {
                    if (result.length == 3) {
                        mat.setDiffuseColor(new Color3f(result));
                        break;
                    }
                    mat.setDiffuseColor(result[0], result[1], result[2], result[3]);
                    break;
                }
                case EMISSION: {
                    mat.setEmissiveColor(new Color3f(result));
                    break;
                }
                case SPECULAR: {
                    mat.setSpecularColor(new Color3f(result));
                }
            }
        } else {
            CommonColorOrTextureType.Texture te = colorOrTexture.getTexture();
            String tex = te.getTexture();
            ElementCache ec = ElementCache.cache();
            CommonNewparamType cnt = ec.getNewParam(tex);
            tex = cnt.getSampler2D().getSource();
            cnt = ec.getNewParam(tex);
            Image im = (Image)cnt.getSurface().getInitFroms().get(0).getValue();
            tex = im.getId();
            String path = ElementCache.cache().getImage(tex);
            URL url = ElementCache.cache().getLoadingURL();
            BufferedImage image = Collada14LoaderUtils.readImage(url, path);
            if (image != null) {
                Texture2D tex2d = (Texture2D)new TextureLoader(image).getTexture();
                app.setTexture((Texture)tex2d);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        AMBIENT,
        EMISSION,
        DIFFUSE,
        SPECULAR;

    }
}

