/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Stripifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import org.collada.colladaschema.InputLocalOffset;
import org.jdesktop.j3d.loaders.collada.Collada14LoaderOptions;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.MaterialProcessor;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.SourceProcessor;
import org.jdesktop.j3d.loaders.collada.xml_walker.VerticesProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveProcessor
extends Processor {
    private int[] prim = null;
    private int[] coordinateIndices = null;
    private float[] coordinates = null;
    private int[] normalIndices = null;
    private float[] normals = null;
    private int[] texCoordinateIndices = null;
    private float[] texCoordinates = null;
    private String materialId = null;

    public PrimitiveProcessor(Object colladaSchema, Processor parent) {
        super(colladaSchema, parent);
    }

    protected void initiate(List<InputLocalOffset> inputs, List<BigInteger> pList, String matId) {
        if (pList != null) {
            this.prim = new int[pList.size()];
            int i = 0;
            for (BigInteger p : pList) {
                this.prim[i++] = p.intValue();
            }
        }
        int maxOffset = 0;
        for (InputLocalOffset in : inputs) {
            maxOffset = Math.max(in.getOffset().intValue(), maxOffset);
        }
        for (InputLocalOffset in : inputs) {
            this.logger.info("Inputs " + in.getSemantic() + " source " + in.getSource() + "  offset " + in.getOffset());
            if (in.getSemantic().equalsIgnoreCase("VERTEX")) {
                this.processVertices(in, maxOffset);
                continue;
            }
            if (in.getSemantic().equalsIgnoreCase("NORMAL")) {
                this.processNormals(in, maxOffset);
                continue;
            }
            if (in.getSemantic().equalsIgnoreCase("TEXCOORD")) {
                this.processTexCoordinates(in, maxOffset);
                continue;
            }
            this.logger.warning("UNIMPLEMENTED SEMANTIC " + in.getSemantic());
        }
        this.materialId = matId;
    }

    private void processVertices(InputLocalOffset in, int maxOffset) {
        VerticesProcessor source = ElementCache.cache().getVertices(in.getSource());
        int offset = in.getOffset().intValue();
        if (source == null) {
            this.logger.warning("Failed to get Vertices " + in.getSource());
        } else {
            this.coordinates = source.getFloatArray();
            ArrayList<Integer> coordInd = new ArrayList<Integer>();
            int i = offset;
            while (i < this.prim.length) {
                coordInd.add(this.prim[i]);
                i += maxOffset + 1;
            }
            this.coordinateIndices = new int[coordInd.size()];
            i = 0;
            Iterator iterator = coordInd.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.coordinateIndices[i++] = index;
            }
        }
    }

    private void processTexCoordinates(InputLocalOffset in, int maxOffset) {
        SourceProcessor source = ElementCache.cache().getSource(in.getSource());
        int offset = in.getOffset().intValue();
        if (source == null) {
            this.logger.warning("Failed to get texcoords " + in.getSource());
        } else {
            this.texCoordinates = source.getFloatArray();
            ArrayList<Integer> coordInd = new ArrayList<Integer>();
            int i = offset;
            while (i < this.prim.length) {
                coordInd.add(this.prim[i]);
                i += maxOffset + 1;
            }
            this.texCoordinateIndices = new int[coordInd.size()];
            i = 0;
            Iterator iterator = coordInd.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.texCoordinateIndices[i++] = index;
            }
        }
    }

    private void processNormals(InputLocalOffset in, int maxOffset) {
        SourceProcessor source = ElementCache.cache().getSource(in.getSource());
        int offset = in.getOffset().intValue();
        if (source == null) {
            this.logger.warning("Failed to get Normals " + in.getSource());
        } else {
            this.normals = source.getFloatArray();
            ArrayList<Integer> normInd = new ArrayList<Integer>();
            int i = offset;
            while (i < this.prim.length) {
                normInd.add(this.prim[i]);
                i += maxOffset + 1;
            }
            this.normalIndices = new int[normInd.size()];
            i = 0;
            Iterator iterator = normInd.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.normalIndices[i++] = index;
            }
        }
    }

    protected Shape3D getShape3D(int type) {
        this.logger.info("TrianglesTypeProcessor#getShape3D");
        Shape3D s3d = new Shape3D();
        s3d.setAppearance(new Appearance());
        GeometryInfo gi = new GeometryInfo(type);
        gi.setCoordinates(this.coordinates);
        gi.setCoordinateIndices(this.coordinateIndices);
        if (this.texCoordinates != null) {
            gi.setTextureCoordinateParams(1, 2);
            gi.setTextureCoordinates(0, this.texCoordinates);
            gi.setTextureCoordinateIndices(0, this.texCoordinateIndices);
        }
        if (this.normals != null) {
            gi.setNormals(this.normals);
            gi.setNormalIndices(this.normalIndices);
        }
        Stripifier strip = new Stripifier();
        strip.stripify(gi);
        s3d.addGeometry((Geometry)gi.getGeometryArray());
        String s = ElementCache.cache().getMaterial(this.materialId);
        MaterialProcessor matProc = (MaterialProcessor)ElementCache.cache().get(s);
        if (matProc != null) {
            matProc.create((Node)s3d);
        }
        if (Collada14LoaderOptions.getInstance().isColored()) {
            Appearance ap = new Appearance();
            ap.setColoringAttributes(new ColoringAttributes(new Color3f((float)Math.random(), (float)Math.random(), (float)Math.random()), 1));
            s3d.setAppearance(ap);
        }
        return s3d;
    }
}

