/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;

public class ProcessorFactory {
    protected static Logger logger = Logger.getLogger("collada.loader");
    private static Exception lastException;
    private static final String walkerPackage = "org.jdesktop.j3d.loaders.collada.xml_walker.";

    public static Processor createProcessor(Object schemaObj, Processor parentProcessor) {
        if (schemaObj == null) {
            return null;
        }
        Class<?> schemaClass = schemaObj.getClass();
        String schemaClassName = schemaClass.getName();
        String schemaObjName = schemaClassName.substring(schemaClassName.lastIndexOf(46) + 1);
        if (schemaObjName.indexOf(36) != 0) {
            schemaObjName = schemaObjName.substring(schemaObjName.lastIndexOf(36) + 1);
        }
        try {
            Class<?> walkerClass = Class.forName(walkerPackage + schemaObjName + "Processor");
            Constructor<?> con = walkerClass.getConstructor(schemaClass, Processor.class);
            return (Processor)con.newInstance(schemaObj, parentProcessor);
        }
        catch (ClassNotFoundException ex) {
            if (lastException == null || !lastException.getMessage().equals(ex.getMessage())) {
                logger.warning("No Handler for " + schemaClass);
            }
            lastException = ex;
        }
        catch (NoSuchMethodException ex) {
            logger.warning("No constructor " + schemaObjName + "(" + schemaClassName + ")");
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

