/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import org.collada.colladaschema.CommonNewparamType;
import org.collada.colladaschema.Extra;
import org.collada.colladaschema.ProfileCOMMON;
import org.collada.colladaschema.Technique;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.ProcessorFactory;
import org.w3c.dom.Element;

public class ProfileCOMMONProcessor
extends Processor {
    private ArrayList<Processor> children = new ArrayList();
    private boolean doubleSided = false;

    public ProfileCOMMONProcessor(ProfileCOMMON profileCommon, Processor parent) {
        super(profileCommon, parent);
        Processor p;
        String id = profileCommon.getId();
        if (id != null) {
            ElementCache.cache().put(id, this);
        }
        List<Object> fcnts = profileCommon.getImagesAndNewparams();
        for (Object o : fcnts) {
            CommonNewparamType cnt = (CommonNewparamType)o;
            ElementCache.cache().putNewParam(cnt.getSid(), cnt);
        }
        for (Extra ex : profileCommon.getExtras()) {
            for (Technique teq : ex.getTechniques()) {
                if (teq.getProfile().equals("GOOGLEEARTH")) {
                    for (Element e : teq.getAnies()) {
                        if (!e.getTagName().equals("double_sided") || !e.getTextContent().trim().equals("1")) continue;
                        this.doubleSided = true;
                    }
                }
                if (!teq.getProfile().equals("MAX3D")) continue;
                for (Element e : teq.getAnies()) {
                    if (!e.getTagName().equals("double_sided") || !e.getTextContent().trim().equals("1")) continue;
                    this.doubleSided = true;
                }
            }
        }
        ProfileCOMMON.Technique tech = profileCommon.getTechnique();
        if (tech.getPhong() != null && (p = ProcessorFactory.createProcessor(tech.getPhong(), this)) != null) {
            this.children.add(p);
        }
        if (tech.getLambert() != null && (p = ProcessorFactory.createProcessor(tech.getLambert(), this)) != null) {
            this.children.add(p);
        }
        if (tech.getBlinn() != null && (p = ProcessorFactory.createProcessor(tech.getBlinn(), this)) != null) {
            this.children.add(p);
        }
    }

    public void create(Node parent) {
        if (this.doubleSided && parent instanceof Shape3D) {
            Shape3D s3d = (Shape3D)parent;
            PolygonAttributes pa = s3d.getAppearance().getPolygonAttributes();
            if (pa == null) {
                pa = new PolygonAttributes();
                s3d.getAppearance().setPolygonAttributes(pa);
            }
            pa.setPolygonMode(2);
            pa.setCullFace(0);
            pa.setBackFaceNormalFlip(true);
            pa.setPolygonOffset(1.0f);
            pa.setPolygonOffsetFactor(1.0f);
        }
        for (Processor p : this.children) {
            p.create(parent);
        }
    }
}

