/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.util.List;
import java.util.logging.Logger;
import javax.vecmath.Tuple3f;
import org.collada.colladaschema.InputLocal;
import org.collada.colladaschema.Vertices;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.SourceProcessor;

public class VerticesProcessor
extends Processor {
    private Logger logger = Logger.getLogger("collada.loader");
    private SourceProcessor positionSource = null;

    public VerticesProcessor(Vertices vert, Processor parent) {
        super(vert, parent);
        this.logger.info("Processing Vertices");
        ElementCache.cache().putVertices(vert.getId(), this);
        List<InputLocal> inputs = vert.getInputs();
        for (InputLocal input : inputs) {
            this.logger.info("Semantic " + input.getSemantic() + "  source " + input.getSource());
            if (input.getSemantic().equals("TRANSLATION") || input.getSemantic().equals("POSITION")) {
                this.positionSource = ElementCache.cache().getSource(input.getSource());
                continue;
            }
            this.logger.warning("Ignoring vertices semantic " + input.getSemantic());
        }
    }

    Tuple3f getTuple3f(Tuple3f result, int index) {
        return this.positionSource.getTuple3f(result, index);
    }

    float[] getFloatArray() {
        return this.positionSource.getFloatArray();
    }
}

