/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.wrappers;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.scenegraph.io.NamedObjectException;
import com.sun.j3d.utils.scenegraph.io.ObjectNotLoadedException;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Reader;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;

public class J3fLoader
extends LoaderBase {
    private SceneGraphFileReader reader = null;
    private BranchGroup[] graphs = null;
    private static ClassLoader classLoader = null;

    public static void setClassLoader(ClassLoader cLoader) {
        classLoader = cLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public Scene load(String filename) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        SceneBase scenebase = null;
        Scene scene = null;
        try {
            this.reader = new SceneGraphFileReader(new File(filename));
            if (classLoader != null) {
                this.reader.setClassLoader(classLoader);
            }
            int size = this.reader.getBranchGraphCount();
            scenebase = new SceneBase();
            BranchGroup bg = new BranchGroup();
            this.graphs = new BranchGroup[size];
            if (size > 1) {
                int i = 0;
                while (i < size) {
                    this.graphs[i] = this.reader.readBranchGraph(i)[0];
                    bg.addChild((Node)this.graphs[i]);
                    ++i;
                }
            } else {
                this.graphs[0] = bg = this.reader.readBranchGraph(0)[0];
            }
            scenebase.setSceneGroup(bg);
            String[] objectNames = this.reader.getNames();
            int i = 0;
            while (i < objectNames.length) {
                try {
                    scenebase.addNamedObject(objectNames[i], (Object)this.reader.getNamedObject(objectNames[i]));
                }
                catch (ObjectNotLoadedException objectNotLoadedException) {
                }
                catch (NamedObjectException namedObjectException) {
                    // empty catch block
                }
                ++i;
            }
            this.reader.close();
        }
        catch (InvalidClassException ex) {
            throw new IncorrectFormatException(ex.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(filename);
        }
        catch (IOException exc) {
            throw new FileNotFoundException(exc.getMessage());
        }
        if (scenebase == null) {
            return scene;
        }
        return scenebase;
    }

    public BranchGroup[] getBranchGraphs() {
        return this.graphs;
    }

    public Object getFileUserData() throws IOException {
        return this.reader.readUserData();
    }

    public Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }
}

