/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.behaviors;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.utils.behaviors.PerfBehaviorListener;

public class PerfBehavior
extends Behavior {
    WakeupOnElapsedFrames FPSwakeup = new WakeupOnElapsedFrames(0);
    private int numFramesToDiscard = 8;
    private boolean doCalibration = true;
    private int discardedFrames = 0;
    private int numframes = 0;
    private int maxframes = 1;
    private long currtime = 0L;
    private long lasttime = 0L;
    private long deltatime;
    private boolean finiteLoop = false;
    private int loop = 0;
    private int loopCount = 6;
    private int testDuration = 1000;
    private ArrayList<PerfBehaviorListener> listeners;

    public PerfBehavior() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        this.setEnable(true);
    }

    public void printToSystemOut() {
        this.addPerfBehaviorListener(new PerfBehaviorListener(){

            public void updatePerformanceFigures(float framesPerSecond) {
                System.out.println("fps " + framesPerSecond);
            }
        });
    }

    public void calibrate() {
        this.calibrate(8, 1000);
    }

    public void calibrate(int framesToDiscard, int testDuration) {
        this.doCalibration = true;
        this.discardedFrames = 0;
        this.numframes = 0;
        this.maxframes = 1;
        this.currtime = 0L;
        this.lasttime = 0L;
        this.loop = 0;
        this.loopCount = 6;
        this.testDuration = testDuration;
        this.numFramesToDiscard = framesToDiscard;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    public void addPerfBehaviorListener(PerfBehaviorListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removePerfBehaviorListener(PerfBehaviorListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(float fps) {
        for (PerfBehaviorListener l : this.listeners) {
            l.updatePerformanceFigures(fps);
        }
    }

    public void processStimulus(Enumeration critera) {
        if (this.doCalibration) {
            if (this.discardedFrames <= this.numFramesToDiscard) {
                ++this.discardedFrames;
                this.lasttime = this.currentTimeMillis();
            } else {
                ++this.numframes;
                if (this.numframes >= this.maxframes) {
                    this.currtime = this.currentTimeMillis();
                    this.deltatime = this.currtime - this.lasttime;
                    if (this.deltatime > (long)this.testDuration && this.maxframes >= 8) {
                        this.maxframes = (int)Math.ceil((double)this.maxframes * 1000.0 / (double)this.deltatime);
                        this.doCalibration = false;
                        this.numframes = 0;
                        this.lasttime = this.currentTimeMillis();
                    } else {
                        this.maxframes *= 2;
                    }
                }
            }
        } else {
            ++this.numframes;
            if (this.numframes >= this.maxframes) {
                this.currtime = this.currentTimeMillis();
                this.deltatime = this.currtime - this.lasttime;
                double fps = (double)this.numframes / ((double)this.deltatime / 1000.0);
                if (this.listeners != null) {
                    this.notifyListeners((float)fps);
                }
                if (this.finiteLoop) {
                    ++this.loop;
                    if (this.loop >= this.loopCount) {
                        System.exit(0);
                    }
                }
                this.lasttime = this.currentTimeMillis();
                this.numframes = 0;
            }
        }
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    private long currentTimeMillis() {
        return System.nanoTime() / 1000000L;
    }
}

