/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.capability;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.SceneGraphObject;

public class Capabilities {
    public static void printCapabilities(SceneGraphObject obj) {
        ArrayList list = new ArrayList();
        Capabilities.getCapabilities(obj, list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            System.out.println((String)it.next());
        }
    }

    public static void getCapabilities(SceneGraphObject obj, ArrayList capabilityStrings) {
        Class<?> cl = obj.getClass();
        Field[] fields = cl.getFields();
        try {
            int i = 0;
            while (i < fields.length) {
                String str = fields[i].getName();
                int value = fields[i].getInt(fields[i]);
                if ((str.indexOf("ALLOW") != -1 || str.indexOf("ENABLE_") != -1) && obj.getCapability(value)) {
                    capabilityStrings.add(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Internal Error");
        }
    }

    public static int[] getCapabilities(SceneGraphObject obj) {
        ArrayList<Integer> bits = new ArrayList<Integer>();
        Class<?> cl = obj.getClass();
        Field[] fields = cl.getFields();
        try {
            int i = 0;
            while (i < fields.length) {
                String str = fields[i].getName();
                int value = fields[i].getInt(fields[i]);
                if ((str.indexOf("ALLOW_") != -1 || str.indexOf("ENABLE_") != -1) && obj.getCapability(value)) {
                    bits.add(new Integer(value));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Internal Error");
        }
        int[] ret = new int[bits.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Integer)bits.get(i);
            ++i;
        }
        return ret;
    }
}

