/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.math;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Math3D {
    public static float pointLineDistance(Point3f lineStart, Point3f lineEnd, Point3f point) {
        Vector3f a = new Vector3f((Tuple3f)lineEnd);
        a.sub((Tuple3f)lineStart);
        Vector3f b = new Vector3f((Tuple3f)lineStart);
        b.sub((Tuple3f)point);
        Vector3f cross = new Vector3f();
        cross.cross(a, b);
        return cross.length() / a.length();
    }

    public static void toEuler(Matrix3d matrix, Vector3d euler) {
        Vector3d v3d = new Vector3d();
        Vector3d zAxis = new Vector3d(0.0, 0.0, -1.0);
        Vector3d yAxis = new Vector3d(0.0, 1.0, 0.0);
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        v3d.set((Tuple3d)xAxis);
        matrix.transform((Tuple3d)v3d);
        v3d.x = Math.abs(v3d.x);
        v3d.z = 0.0;
        v3d.normalize();
        euler.x = xAxis.angle(v3d);
        v3d.set((Tuple3d)yAxis);
        matrix.transform((Tuple3d)v3d);
        v3d.z = Math.abs(v3d.z);
        v3d.x = 0.0;
        v3d.normalize();
        euler.y = yAxis.angle(v3d);
        v3d.set((Tuple3d)zAxis);
        matrix.transform((Tuple3d)v3d);
        v3d.y = 0.0;
        v3d.normalize();
        euler.z = zAxis.angle(v3d);
        if (v3d.x < 0.0) {
            euler.z = Math.PI * 2 - euler.z;
        }
    }

    public static boolean epsilonEquals(float f1, float f2, float epsilon) {
        float diff = f1 - f2;
        float f = diff < 0.0f ? -diff : diff;
        return !(f > epsilon);
    }

    public static boolean epsilonEquals(Tuple3f t1, Tuple3f t2, float epsilon) {
        return Math3D.epsilonEquals(t1.x, t2.x, epsilon) && Math3D.epsilonEquals(t1.y, t2.y, epsilon) && Math3D.epsilonEquals(t1.z, t2.z, epsilon);
    }

    public static boolean encloses(Bounds parent, Bounds child) {
        if (parent instanceof BoundingBox) {
            if (child instanceof BoundingBox) {
                return Math3D.encloses((BoundingBox)parent, (BoundingBox)child);
            }
            if (child instanceof BoundingSphere) {
                return Math3D.encloses((BoundingBox)parent, (BoundingSphere)child);
            }
            if (parent instanceof BoundingSphere) {
                if (child instanceof BoundingBox) {
                    return Math3D.encloses((BoundingSphere)parent, (BoundingBox)child);
                }
                if (child instanceof BoundingSphere) {
                    return Math3D.encloses((BoundingSphere)parent, (BoundingSphere)child);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported bounds combination");
    }

    public static boolean encloses(BoundingBox parent, BoundingSphere child) {
        Point3d upper = new Point3d();
        Point3d lower = new Point3d();
        Point3d center = new Point3d();
        parent.getUpper(upper);
        parent.getLower(lower);
        child.getCenter(center);
        double radius = child.getRadius();
        if (center.x + radius > upper.x || center.y + radius > upper.y || center.z + radius > upper.z) {
            return false;
        }
        return !(center.x - radius < lower.x) && !(center.y - radius < lower.y) && !(center.z - radius < lower.z);
    }

    public static boolean encloses(BoundingBox parent, BoundingBox child) {
        Point3d pUpper = new Point3d();
        Point3d pLower = new Point3d();
        Point3d cUpper = new Point3d();
        Point3d cLower = new Point3d();
        parent.getUpper(pUpper);
        parent.getLower(pLower);
        child.getUpper(cUpper);
        child.getLower(cLower);
        if (cUpper.x > pUpper.x || cUpper.y > pUpper.y || cUpper.z > pUpper.z) {
            return false;
        }
        return !(cLower.x < pLower.x) && !(cLower.y < pLower.y) && !(cLower.z < pLower.z);
    }

    public static boolean encloses(BoundingSphere parent, BoundingBox child) {
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        Point3d parentCenter = new Point3d();
        child.getLower(lower);
        child.getUpper(upper);
        parent.getCenter(parentCenter);
        double xDim = upper.x - lower.x;
        double yDim = upper.y - lower.y;
        double radiusSquared = Math.pow(parent.getRadius(), 2.0);
        Vector3d tmp = new Vector3d();
        tmp.set((Tuple3d)lower);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(lower.x + xDim, lower.y, lower.z);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(lower.x, lower.y + yDim, lower.z);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(lower.x + xDim, lower.y + yDim, lower.z);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set((Tuple3d)upper);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(upper.x - xDim, upper.y, upper.z);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(upper.x, upper.y - yDim, upper.z);
        tmp.sub((Tuple3d)parentCenter);
        if (tmp.lengthSquared() > radiusSquared) {
            return false;
        }
        tmp.set(upper.x - xDim, upper.y - yDim, upper.z);
        tmp.sub((Tuple3d)parentCenter);
        return !(tmp.lengthSquared() > radiusSquared);
    }

    public static boolean encloses(BoundingSphere parent, BoundingSphere child) {
        Point3d childCenter = new Point3d();
        Point3d parentCenter = new Point3d();
        child.getCenter(childCenter);
        parent.getCenter(parentCenter);
        double childR = child.getRadius();
        double parentR = parent.getRadius();
        if (childCenter.x + childR > parentCenter.x + parentR || childCenter.y + childR > parentCenter.y + parentR || childCenter.z + childR > parentCenter.z + parentR) {
            return false;
        }
        return !(childCenter.x - childR < parentCenter.x - parentR) && !(childCenter.y - childR < parentCenter.y - parentR) && !(childCenter.z - childR < parentCenter.z - parentR);
    }
}

