/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.transparency;

import com.sun.j3d.utils.scenegraph.transparency.TransparencySortController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GraphStructureChangeListener;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.utils.scenegraph.transparency.OrderingComparator;
import org.jdesktop.j3d.utils.scenegraph.transparency.TransparencyOrderedGroup;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class TransparencyOrderController
extends BranchGroup {
    private static TransparencyOrderController controller = null;
    private HashMap<Shape3D, Shape3DRecord> shapeMap = new HashMap();

    public TransparencyOrderController(View view) {
        if (controller != null) {
            throw new RuntimeException("TransparencyOrderering is only supported for a single view at this time");
        }
        controller = this;
        view.setTransparencySortingPolicy(1);
        TransparencySortController.setComparator((View)view, (Comparator)new OrderingComparator());
        this.addChild((Node)new TogBehavior());
    }

    static TransparencyOrderController getController() {
        return controller;
    }

    void adjustChildIndex(Shape3D shape3D, int indexAdjustment, TransparencyOrderedGroup tog) {
        Shape3DRecord record = this.shapeMap.get(shape3D);
        boolean done = false;
        int i = 0;
        while (i < record.togs.length && !done) {
            if (record.togs[i] == tog) {
                int n = i;
                record.childIndicies[n] = record.childIndicies[n] + indexAdjustment;
                done = true;
            }
            ++i;
        }
    }

    int compare(Shape3D s1, Shape3D s2) {
        Shape3DRecord r1 = this.shapeMap.get(s1);
        Shape3DRecord r2 = this.shapeMap.get(s2);
        TransparencyOrderedGroup tog = null;
        if (r1 == null || r2 == null) {
            System.err.println("SEVERE : Unknown Shape in TransparencyOrderController.compare " + s1 + "   " + s2);
            return 0;
        }
        int i = Math.min(r1.togs.length, r2.togs.length) - 1;
        while (i >= 0 && tog == null) {
            if (r1.togs[i] == r2.togs[i]) {
                tog = r1.togs[i];
            }
            --i;
        }
        if (tog == null) {
            return 0;
        }
        return tog.getRenderingOrderForChild(r2.childIndicies[i + 1]) - tog.getRenderingOrderForChild(r1.childIndicies[i + 1]);
    }

    class Shape3DRecord {
        Shape3D shape;
        TransparencyOrderedGroup[] togs;
        int[] childIndicies;

        public Shape3DRecord(Shape3D shape, Object parent) {
            this.shape = shape;
            this.findTogs((Node)shape, 0, parent);
        }

        private void findTogs(Node node, int depth, Object graphParent) {
            boolean nextIndex = false;
            Node parent = node.getParent();
            int childIndexInParent = -1;
            if (parent == null && graphParent != null) {
                if (graphParent instanceof Node && (parent = (Node)graphParent) instanceof TransparencyOrderedGroup) {
                    childIndexInParent = ((Group)parent).numChildren();
                }
                graphParent = null;
            } else if (parent instanceof TransparencyOrderedGroup) {
                childIndexInParent = ((Group)parent).indexOfChild(node);
            }
            if (parent != null) {
                if (parent instanceof SharedGroup) {
                    throw new RuntimeException("TransparencySort utility does not support SharedGroups");
                }
                if (parent instanceof TransparencyOrderedGroup) {
                    this.findTogs(parent, depth + 1, graphParent);
                } else {
                    this.findTogs(parent, depth, graphParent);
                }
            } else {
                this.togs = new TransparencyOrderedGroup[depth];
                this.childIndicies = new int[depth];
            }
            if (parent instanceof TransparencyOrderedGroup) {
                this.togs[this.togs.length - depth - 1] = (TransparencyOrderedGroup)parent;
                this.childIndicies[this.togs.length - depth - 1] = childIndexInParent;
            }
        }
    }

    class TogBehavior
    extends Behavior
    implements GraphStructureChangeListener {
        private WakeupCondition wakeup = new WakeupOnElapsedFrames(0, false);
        private ArrayList<Shape3D> currentFrameRemoveList = new ArrayList();
        private ArrayList<Shape3D> lastFrameRemoveList = new ArrayList(1);

        TogBehavior() {
        }

        public void initialize() {
            TransparencyOrderController.this.shapeMap.clear();
            this.getLocale().getVirtualUniverse().addGraphStructureChangeListener((GraphStructureChangeListener)this);
            Enumeration en = this.getLocale().getAllBranchGraphs();
            while (en.hasMoreElements()) {
                this.graphAdded(this.getLocale(), (BranchGroup)en.nextElement());
            }
            this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), Double.POSITIVE_INFINITY));
            this.wakeupOn(this.wakeup);
        }

        public synchronized void processStimulus(Enumeration e) {
            if (this.lastFrameRemoveList != null) {
                for (Shape3D s : this.lastFrameRemoveList) {
                    TransparencyOrderController.this.shapeMap.remove(s);
                }
            }
            this.lastFrameRemoveList = this.currentFrameRemoveList;
            this.currentFrameRemoveList = new ArrayList();
            this.wakeupOn(this.wakeup);
        }

        private synchronized void graphAdded(final Object parent, BranchGroup child) {
            TreeScan.findNode((Node)child, Shape3D.class, new ProcessNodeInterface(){

                public boolean processNode(Node node) {
                    TransparencyOrderController.this.shapeMap.put((Shape3D)node, new Shape3DRecord((Shape3D)node, parent));
                    TogBehavior.this.currentFrameRemoveList.remove((Shape3D)node);
                    TogBehavior.this.lastFrameRemoveList.remove((Shape3D)node);
                    return true;
                }
            }, false, true);
        }

        private synchronized void graphRemoved(BranchGroup child) {
            TreeScan.findNode((Node)child, Shape3D.class, new ProcessNodeInterface(){

                public boolean processNode(Node node) {
                    Boolean ret = TogBehavior.this.currentFrameRemoveList.add((Shape3D)node);
                    if (ret == null) {
                        throw new RuntimeException("Unknown Shape3D found during graphRemoval");
                    }
                    return true;
                }
            }, false, true);
        }

        public void branchGroupAdded(Object parent, BranchGroup child) {
            this.graphAdded(parent, child);
        }

        public void branchGroupMoved(Object oldParent, Object newParent, BranchGroup child) {
            this.graphAdded(newParent, child);
        }

        public void branchGroupRemoved(Object parent, BranchGroup child) {
            this.graphRemoved(child);
        }
    }
}

