/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import org.jdesktop.j3d.utils.scenegraph.traverser.AppearanceChangeProcessor;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class ChangePolygonAttributes {
    public static void setPolygonMode(Node treeRoot, int polygonMode) {
        ChangePolygonAttributes.setPolygonMode(treeRoot, polygonMode, false);
    }

    public static void setPolygonMode(Node treeRoot, final int polygonMode, final boolean createAttribute) {
        AppearanceChangeProcessor processor = new AppearanceChangeProcessor(){

            public void changeAppearance(Shape3D shape, Appearance app) {
                PolygonAttributes poly;
                if (app == null) {
                    if (createAttribute) {
                        app = new Appearance();
                        shape.setAppearance(app);
                    } else {
                        return;
                    }
                }
                if ((poly = app.getPolygonAttributes()) != null) {
                    poly.setPolygonMode(polygonMode);
                } else if (createAttribute) {
                    poly = new PolygonAttributes();
                    poly.setPolygonMode(polygonMode);
                    app.setPolygonAttributes(poly);
                }
            }
        };
        ChangePolygonAttributes.scanTree(treeRoot, processor);
    }

    public static void setCullFace(Node treeRoot, int cullFace) {
        ChangePolygonAttributes.setCullFace(treeRoot, cullFace, false);
    }

    public static void setCullFace(Node treeRoot, final int cullFace, final boolean createAttribute) {
        AppearanceChangeProcessor processor = new AppearanceChangeProcessor(){

            public void changeAppearance(Shape3D shape, Appearance app) {
                PolygonAttributes poly;
                if (app == null) {
                    if (createAttribute) {
                        app = new Appearance();
                        shape.setAppearance(app);
                    } else {
                        return;
                    }
                }
                if ((poly = app.getPolygonAttributes()) != null) {
                    poly.setCullFace(cullFace);
                } else if (createAttribute) {
                    poly = new PolygonAttributes();
                    poly.setCullFace(cullFace);
                    app.setPolygonAttributes(poly);
                }
            }
        };
        ChangePolygonAttributes.scanTree(treeRoot, processor);
    }

    private static void scanTree(Node treeRoot, AppearanceChangeProcessor processor) {
        try {
            Class<?> shapeClass = Class.forName("javax.media.j3d.Shape3D");
            TreeScan.findNode(treeRoot, shapeClass, (ProcessNodeInterface)processor, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR ChangePolygonAttributes, SceneGraph contains Live or compiled nodes, without correct capabilities");
        }
    }
}

