/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureUnitState;
import org.jdesktop.j3d.utils.scenegraph.traverser.AppearanceChangeProcessor;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class ChangeTextureAttributes {
    public static void setTextureEnable(Node treeRoot, final boolean enabled) {
        AppearanceChangeProcessor processor = new AppearanceChangeProcessor(){

            public void changeAppearance(Shape3D shape, Appearance app) {
                if (app == null) {
                    return;
                }
                Texture texture = app.getTexture();
                if (texture != null) {
                    texture.setEnable(enabled);
                }
                if (app.getTextureUnitState() != null) {
                    TextureUnitState[] states = app.getTextureUnitState();
                    int i = 0;
                    while (i < states.length) {
                        if (states[i].getTexture() != null) {
                            states[i].getTexture().setEnable(enabled);
                        }
                        ++i;
                    }
                }
            }
        };
        ChangeTextureAttributes.scanTree(treeRoot, processor);
    }

    private static void scanTree(Node treeRoot, AppearanceChangeProcessor processor) {
        try {
            Class<?> shapeClass = Class.forName("javax.media.j3d.Shape3D");
            TreeScan.findNode(treeRoot, shapeClass, (ProcessNodeInterface)processor, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR ChangeTextureAttributes, SceneGraph contains Live or compiled nodes, without correct capabilities");
        }
    }
}

