/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import java.util.Enumeration;
import java.util.HashSet;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;

public class GeometrySizeProcessor
implements ProcessNodeInterface {
    private long triangleCount = 0L;
    private long quadCount = 0L;
    private long lineCount = 0L;
    private long pointCount = 0L;
    private long vertexInStrips = 0L;
    private long vertexInArrays = 0L;
    private int[] triangleStripDistribution;
    private int[] triangleFanDistribution;
    private long stripCount = 0L;
    private int shape3Dcount = 0;
    private HashSet appearanceSet = new HashSet();

    public GeometrySizeProcessor() {
        this.triangleStripDistribution = new int[15];
        this.triangleFanDistribution = new int[15];
        int i = 0;
        while (i < this.triangleStripDistribution.length) {
            this.triangleStripDistribution[i] = 0;
            this.triangleFanDistribution[i] = 0;
            ++i;
        }
        this.appearanceSet.clear();
    }

    public boolean processNode(Node node) {
        if (!Shape3D.class.isAssignableFrom(node.getClass())) {
            throw new RuntimeException("Node class " + node.getClass().getName() + " is not a (subclass) of Shape3D as expected");
        }
        ++this.shape3Dcount;
        this.appearanceSet.add(((Shape3D)node).getAppearance());
        Enumeration e = ((Shape3D)node).getAllGeometries();
        while (e.hasMoreElements()) {
            int c;
            int i;
            int[] vertexCounts;
            int numStrips;
            Geometry geom = (Geometry)e.nextElement();
            if (geom instanceof GeometryStripArray) {
                numStrips = ((GeometryStripArray)geom).getNumStrips();
                vertexCounts = new int[numStrips];
                ((GeometryStripArray)geom).getStripVertexCounts(vertexCounts);
                i = 0;
                while (i < numStrips) {
                    this.vertexInStrips += (long)vertexCounts[i];
                    ++i;
                }
                this.stripCount += (long)numStrips;
                if (geom instanceof TriangleFanArray) {
                    i = 0;
                    while (i < numStrips) {
                        c = vertexCounts[i] - 2;
                        this.storeTriangleFanSize(c);
                        this.triangleCount += (long)c;
                        ++i;
                    }
                    continue;
                }
                if (geom instanceof TriangleStripArray) {
                    i = 0;
                    while (i < numStrips) {
                        c = vertexCounts[i] - 2;
                        this.storeTriangleStripSize(c);
                        this.triangleCount += (long)c;
                        ++i;
                    }
                    continue;
                }
                if (geom instanceof LineStripArray) {
                    i = 0;
                    while (i < numStrips) {
                        this.lineCount += (long)(vertexCounts[i] - 1);
                        ++i;
                    }
                    continue;
                }
                this.unsupportedGeom(geom);
                continue;
            }
            if (geom instanceof IndexedGeometryStripArray) {
                numStrips = ((IndexedGeometryStripArray)geom).getNumStrips();
                vertexCounts = new int[numStrips];
                ((IndexedGeometryStripArray)geom).getStripIndexCounts(vertexCounts);
                i = 0;
                while (i < numStrips) {
                    this.vertexInStrips += (long)vertexCounts[i];
                    ++i;
                }
                this.stripCount += (long)numStrips;
                if (geom instanceof IndexedTriangleFanArray) {
                    i = 0;
                    while (i < numStrips) {
                        c = vertexCounts[i] - 2;
                        this.triangleCount += (long)c;
                        this.storeTriangleFanSize(c);
                        ++i;
                    }
                    continue;
                }
                if (geom instanceof IndexedTriangleStripArray) {
                    i = 0;
                    while (i < numStrips) {
                        c = vertexCounts[i] - 2;
                        this.triangleCount += (long)c;
                        this.storeTriangleStripSize(c);
                        ++i;
                    }
                    continue;
                }
                if (geom instanceof IndexedLineStripArray) {
                    i = 0;
                    while (i < numStrips) {
                        this.lineCount += (long)(vertexCounts[i] - 1);
                        ++i;
                    }
                    continue;
                }
                this.unsupportedGeom(geom);
                continue;
            }
            if (geom instanceof IndexedGeometryArray) {
                if (geom instanceof IndexedTriangleArray) {
                    this.triangleCount += (long)(((IndexedGeometryArray)geom).getIndexCount() / 3);
                    this.vertexInArrays += (long)((IndexedGeometryArray)geom).getIndexCount();
                    continue;
                }
                if (geom instanceof IndexedQuadArray) {
                    this.quadCount += (long)(((IndexedGeometryArray)geom).getIndexCount() / 4);
                    this.vertexInArrays += (long)((IndexedGeometryArray)geom).getIndexCount();
                    continue;
                }
                if (geom instanceof IndexedLineArray) {
                    this.lineCount += (long)(((IndexedGeometryArray)geom).getIndexCount() / 2);
                    this.vertexInArrays += (long)((IndexedGeometryArray)geom).getIndexCount();
                    continue;
                }
                if (geom instanceof IndexedPointArray) {
                    this.pointCount += (long)((IndexedGeometryArray)geom).getIndexCount();
                    this.vertexInArrays += (long)((IndexedGeometryArray)geom).getIndexCount();
                    continue;
                }
                this.unsupportedGeom(geom);
                continue;
            }
            if (geom instanceof LineArray) {
                this.lineCount += (long)(((LineArray)geom).getVertexCount() / 2);
                this.vertexInArrays += (long)((LineArray)geom).getVertexCount();
                continue;
            }
            if (geom instanceof TriangleArray) {
                this.triangleCount += (long)(((TriangleArray)geom).getVertexCount() / 3);
                this.vertexInArrays += (long)((TriangleArray)geom).getVertexCount();
                continue;
            }
            if (geom instanceof QuadArray) {
                this.quadCount += (long)(((QuadArray)geom).getVertexCount() / 4);
                this.vertexInArrays += (long)((QuadArray)geom).getVertexCount();
                continue;
            }
            if (geom instanceof PointArray) {
                this.pointCount += (long)((PointArray)geom).getVertexCount();
                this.vertexInArrays += (long)((PointArray)geom).getVertexCount();
                continue;
            }
            this.unsupportedGeom(geom);
        }
        return true;
    }

    private void storeTriangleStripSize(int size) {
        if (size < 10) {
            int n = size;
            this.triangleStripDistribution[n] = this.triangleStripDistribution[n] + 1;
        } else if (size < 20) {
            this.triangleStripDistribution[10] = this.triangleStripDistribution[10] + 1;
        } else if (size < 50) {
            this.triangleStripDistribution[11] = this.triangleStripDistribution[11] + 1;
        } else if (size < 100) {
            this.triangleStripDistribution[12] = this.triangleStripDistribution[12] + 1;
        } else if (size < 1000) {
            this.triangleStripDistribution[13] = this.triangleStripDistribution[13] + 1;
        } else {
            this.triangleStripDistribution[14] = this.triangleStripDistribution[14] + 1;
        }
    }

    private void storeTriangleFanSize(int size) {
        if (size < 10) {
            int n = size;
            this.triangleFanDistribution[n] = this.triangleFanDistribution[n] + 1;
        } else if (size < 20) {
            this.triangleFanDistribution[10] = this.triangleFanDistribution[10] + 1;
        } else if (size < 50) {
            this.triangleFanDistribution[11] = this.triangleFanDistribution[11] + 1;
        } else if (size < 100) {
            this.triangleFanDistribution[12] = this.triangleFanDistribution[12] + 1;
        } else if (size < 1000) {
            this.triangleFanDistribution[13] = this.triangleFanDistribution[13] + 1;
        } else {
            this.triangleFanDistribution[14] = this.triangleFanDistribution[14] + 1;
        }
    }

    private void unsupportedGeom(Geometry geom) {
        if (geom == null) {
            return;
        }
        System.err.println("GeometrySizeProcessor: Unsupported Geometry Type " + geom.getClass().getName());
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(long lineCount) {
        this.lineCount = lineCount;
    }

    public long getQuadCount() {
        return this.quadCount;
    }

    public void setQuadCount(long quadCount) {
        this.quadCount = quadCount;
    }

    public long getPointCount() {
        return this.pointCount;
    }

    public void setPointCount(long pointCount) {
        this.pointCount = pointCount;
    }

    public long getTriangleCount() {
        return this.triangleCount;
    }

    public void setTriangleCount(long triangleCount) {
        this.triangleCount = triangleCount;
    }

    public int[] getTriangleStripDistribution() {
        return this.triangleStripDistribution;
    }

    public int[] getTriangleFanDistribution() {
        return this.triangleFanDistribution;
    }

    public int getShape3DCount() {
        return this.shape3Dcount;
    }

    public void setShape3DCount(int count) {
        this.shape3Dcount = count;
    }

    public int getAppearanceCount() {
        return this.appearanceSet.size();
    }

    public float getStripPercentage() {
        if (this.vertexInStrips + this.vertexInArrays == 0L) {
            return 0.0f;
        }
        return (float)this.vertexInStrips / (float)(this.vertexInStrips + this.vertexInArrays) * 100.0f;
    }

    public float getAverageStripLength() {
        if (this.stripCount == 0L) {
            return 0.0f;
        }
        return (float)this.vertexInStrips / (float)this.stripCount;
    }
}

