/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.jinput;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;
import org.j3d.device.input.Tracker;
import org.j3d.device.input.TrackerDevice;
import org.j3d.device.input.WheelDevice;
import org.j3d.device.input.WheelState;
import org.j3d.device.input.jinput.AxisTracker;

public class Wheel
implements WheelDevice,
TrackerDevice {
    private static final float DEVICE_THRESHOLD = 0.02f;
    private Controller controller;
    private String name;
    private Tracker[] trackers;
    private int[] controllerFuncs;
    private Component[] axes;
    private float[] lastVals;
    private Rumbler rumblerWheel;
    private int[] rumblerFuncs;

    public Wheel(Controller controller, String string) {
        this.controller = controller;
        this.name = string;
        this.axes = controller.getComponents();
        this.trackers = new Tracker[1];
        Component[] componentArray = new Component[2];
        int[] nArray = new int[2];
        this.controllerFuncs = new int[this.axes.length];
        this.lastVals = new float[this.axes.length];
        int n = this.axes.length;
        for (int i = 0; i < n; ++i) {
            String string2 = this.axes[i].getName();
            if (string2.equals("Wheel axis") || string2.equalsIgnoreCase("X Axis")) {
                componentArray[0] = this.axes[i];
                nArray[0] = 1;
                this.controllerFuncs[i] = 14;
                continue;
            }
            if (string2.equals("Combined pedals") || string2.equalsIgnoreCase("Y Axis")) {
                componentArray[1] = this.axes[i];
                nArray[1] = 5;
                this.controllerFuncs[i] = 0;
                continue;
            }
            this.controllerFuncs[i] = string2.equals("Left Paddle") ? 15 : (string2.equals("Right Paddle") ? 16 : (string2.equals("Button 3") ? 17 : (string2.equals("Button 4") ? 18 : -1)));
        }
        AxisTracker axisTracker = new AxisTracker(componentArray, nArray);
        this.trackers[0] = axisTracker;
        Rumbler[] rumblerArray = controller.getRumblers();
        n = rumblerArray.length;
        this.rumblerFuncs = new int[rumblerArray.length];
        for (int i = 0; i < n; ++i) {
            string = rumblerArray[i].getAxisName();
            if (string == null) {
                if (this.rumblerWheel != null) continue;
                this.rumblerWheel = rumblerArray[i];
                continue;
            }
            if (!string.equals("Wheel axis")) continue;
            this.rumblerWheel = rumblerArray[i];
        }
    }

    public String getName() {
        return this.name;
    }

    public void getState(WheelState wheelState) {
        this.controller.poll();
        int n = this.axes.length;
        block8: for (int i = 0; i < n; ++i) {
            float f = this.axes[i].getPollData();
            if (Math.abs(this.lastVals[i] - f) < 0.02f) continue;
            this.lastVals[i] = f;
            switch (this.controllerFuncs[i]) {
                case 14: {
                    wheelState.wheelX = f;
                    wheelState.wheelX_changed = true;
                    continue block8;
                }
                case 0: {
                    wheelState.throttleSlider = -f;
                    wheelState.throttleSlider_changed = true;
                    continue block8;
                }
                case 15: {
                    wheelState.button1 = f == 1.0f;
                    wheelState.button1_changed = true;
                    continue block8;
                }
                case 16: {
                    wheelState.button2 = f == 1.0f;
                    wheelState.button2_changed = true;
                    continue block8;
                }
                case 17: {
                    wheelState.button3 = f == 1.0f;
                    wheelState.button3_changed = true;
                    continue block8;
                }
                case 18: {
                    wheelState.button4 = f == 1.0f;
                    wheelState.button4_changed = true;
                }
            }
        }
    }

    public void setEquilibriumPoint(float f) {
        if (this.rumblerWheel != null) {
            this.rumblerWheel.rumble(f);
        }
    }

    public int getTrackerCount() {
        return this.trackers.length;
    }

    public Tracker[] getTrackers() {
        return this.trackers;
    }
}

