/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.j3d.geom.CharacterData;
import org.j3d.geom.TriangulationUtils;
import org.j3d.util.CharHashMap;
import org.j3d.util.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterCreator {
    private static final float[] FACE_NORMAL = new float[]{0.0f, 0.0f, -1.0f};
    private final Font font;
    private final double flatness;
    private TriangulationUtils triangulator;
    private FontRenderContext fontContext;
    private CharHashMap charDataMap;
    private float[] newCoords;
    private float[] charCoords;
    private int[] charIndex;
    private int[] triOutputIndex;
    private char[] sourceChar;

    public CharacterCreator(Font font, double d) {
        this.font = font;
        this.flatness = d;
        this.fontContext = new FontRenderContext(null, true, true);
        this.charDataMap = new CharHashMap();
        this.newCoords = new float[6];
        this.charCoords = new float[1024];
        this.charIndex = new int[512];
        this.triOutputIndex = new int[512];
        this.triangulator = new TriangulationUtils();
        this.sourceChar = new char[1];
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontContext;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public synchronized void createCharacterTriangles(char[] cArray, int n, ArrayList arrayList) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.charDataMap.containsKey(cArray[n2])) continue;
            ++n3;
        }
        if (n3 != 0) {
            n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (this.charDataMap.containsKey(cArray[n2])) continue;
                this.createNewGlyph(cArray[n2]);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            arrayList.add(this.charDataMap.get(cArray[n2]));
        }
    }

    private void createNewGlyph(char c) {
        int n;
        int n2;
        Object object;
        this.sourceChar[0] = c;
        GlyphVector glyphVector = this.font.createGlyphVector(this.fontContext, this.sourceChar);
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        double d = rectangle2D.getX() + 0.5 * rectangle2D.getWidth();
        double d2 = rectangle2D.getY() + 0.5 * rectangle2D.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(-d, -d2);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(d, -d2);
        CharacterData characterData = new CharacterData();
        Rectangle2D rectangle2D2 = glyphVector.getLogicalBounds();
        float f = 1.0f / (float)rectangle2D2.getHeight();
        characterData.bounds = new Rectangle2D.Float((float)rectangle2D2.getX() * f, (float)rectangle2D2.getY() * f, (float)rectangle2D2.getWidth() * f, 1.0f);
        characterData.scale = f;
        if (Character.isWhitespace(c)) {
            characterData.numIndex = 0;
            this.charDataMap.put(c, characterData);
            return;
        }
        Shape shape = glyphVector.getOutline();
        PathIterator pathIterator = shape.getPathIterator(affineTransform, this.flatness / (double)f);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(this.newCoords)) {
                case 0: {
                    arrayList.add(new int[]{n5, -1});
                    this.resizeCharCoords(n5 + 3);
                    this.charCoords[n5++] = this.newCoords[0] * f;
                    this.charCoords[n5++] = this.newCoords[1] * f;
                    this.charCoords[n5++] = 0.0f;
                    ++n3;
                    break;
                }
                case 1: {
                    this.resizeCharCoords(n5 + 3);
                    this.charCoords[n5++] = this.newCoords[0] * f;
                    this.charCoords[n5++] = this.newCoords[1] * f;
                    this.charCoords[n5++] = 0.0f;
                    ++n3;
                    break;
                }
                case 4: {
                    object = arrayList.get(arrayList.size() - 1);
                    object[1] = n5;
                }
            }
            pathIterator.next();
        }
        object = this.group(this.charCoords, arrayList);
        n5 = 0;
        int[] nArray = ((IntHashMap)object).keySet();
        int n7 = nArray.length;
        float[][] fArrayArray = new float[n7][];
        for (n2 = 0; n2 < n7; ++n2) {
            int[] nArray2;
            int n8;
            int n9;
            int n10;
            n = nArray[n2];
            int[] nArray3 = arrayList.get(n);
            int n11 = nArray3[0];
            if (!this.isClockwise(this.charCoords, n11, n10 = ((n9 = nArray3[1]) - n11) / 3)) {
                this.invertOrder(this.charCoords, n11, n10);
            }
            if ((n8 = (nArray2 = (int[])((IntHashMap)object).get(n)).length) > 0) {
                float f2 = this.charCoords[n11];
                float f3 = this.charCoords[n11 + 1];
                for (int i = 0; i < n8; ++i) {
                    int n12;
                    int n13;
                    int n14;
                    int n15 = nArray2[i];
                    int[] nArray4 = arrayList.get(n15);
                    int n16 = nArray4[0];
                    if (!this.isClockwise(this.charCoords, n16, n14 = (n13 = (n12 = nArray4[1]) - n16) / 3)) continue;
                    this.invertOrder(this.charCoords, n16, n14);
                }
            }
            fArrayArray[n2] = this.combine(this.charCoords, arrayList, (IntHashMap)object, n);
            n5 += fArrayArray[n2].length;
        }
        this.resizeCharCoords(n5);
        n2 = 0;
        for (n = 0; n < n7; ++n) {
            int n17 = fArrayArray[n].length;
            System.arraycopy(fArrayArray[n], 0, this.charCoords, n2, n17);
            n2 += n17;
        }
        n4 = 0;
        for (n = 0; n < n7; ++n) {
            int n18;
            int n19 = fArrayArray[n].length;
            n3 = n19 / 3;
            if (this.triOutputIndex.length < n3 * 3) {
                this.triOutputIndex = new int[n3 * 3];
            }
            if ((n18 = this.triangulator.triangulateConcavePolygon(this.charCoords, n4, n3, this.triOutputIndex, FACE_NORMAL)) > 0) {
                n18 *= 3;
                int n20 = 0;
                while (n20 < n18) {
                    int n21 = n20++;
                    this.triOutputIndex[n21] = this.triOutputIndex[n21] / 3;
                }
                if (this.charIndex.length < n6 + n18) {
                    int[] nArray5 = new int[n6 + n18];
                    System.arraycopy(this.charIndex, 0, nArray5, 0, n6);
                    this.charIndex = nArray5;
                }
                System.arraycopy(this.triOutputIndex, 0, this.charIndex, n6, n18);
                n6 += n18;
            } else if (n18 < 0) {
                System.out.println("can't tesselate '" + c + "'");
            }
            n4 += n19;
        }
        for (n = 0; n < n6 / 3; ++n) {
            int n22 = this.charIndex[n * 3];
            this.charIndex[n * 3] = this.charIndex[n * 3 + 2];
            this.charIndex[n * 3 + 2] = n22;
        }
        characterData.coordinates = this.createFloatBuffer(n5);
        characterData.coordinates.put(this.charCoords, 0, n5);
        characterData.coordIndex = this.createIntBuffer(n6);
        characterData.coordIndex.put(this.charIndex, 0, n6);
        characterData.numIndex = n6;
        this.charDataMap.put(c, characterData);
    }

    private FloatBuffer createFloatBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    private IntBuffer createIntBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        return intBuffer;
    }

    private boolean isInsideEvenOdd(float f, float f2, float[] fArray, int n, int n2) {
        boolean bl = false;
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 < n2) {
            if ((fArray[n + n4 * 3 + 1] <= f2 && f2 < fArray[n + n3 * 3 + 1] || fArray[n + n3 * 3 + 1] <= f2 && f2 < fArray[n + n4 * 3 + 1]) && f < (fArray[n + n3 * 3] - fArray[n + n4 * 3]) * (f2 - fArray[n + n4 * 3 + 1]) / (fArray[n + n3 * 3 + 1] - fArray[n + n4 * 3 + 1]) + fArray[n + n4 * 3]) {
                bl = !bl;
            }
            n3 = n4++;
        }
        return bl;
    }

    private int findClosestPoint(float f, float f2, float[] fArray, int n, int n2) {
        float f3 = f - fArray[n];
        float f4 = f2 - fArray[n + 1];
        float f5 = f3 * f3 + f4 * f4;
        int n3 = n;
        for (int i = 1; i < n2; ++i) {
            f3 = f - fArray[n + i * 3];
            f4 = f2 - fArray[n + i * 3 + 1];
            float f6 = f3 * f3 + f4 * f4;
            if (!(f6 < f5)) continue;
            f5 = f6;
            n3 = n + i * 3;
        }
        return n3;
    }

    private void resizeCharCoords(int n) {
        int n2 = this.charCoords.length;
        if (n2 < n) {
            while (n2 < n) {
                n2 += 256;
            }
            float[] fArray = new float[n2];
            System.arraycopy(this.charCoords, 0, fArray, 0, this.charCoords.length);
            this.charCoords = fArray;
        }
    }

    private float[] resize(float[] fArray, int n) {
        float[] fArray2 = null;
        if (fArray == null) {
            fArray2 = new float[n];
        } else {
            int n2 = fArray.length;
            if (n2 < n) {
                while (n2 < n) {
                    n2 += 256;
                }
                fArray2 = new float[n2];
                System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            }
        }
        return fArray2;
    }

    private void invertOrder(float[] fArray, int n, int n2) {
        int n3 = n + (n2 - 1) * 3;
        int n4 = n2 / 2;
        for (int i = 0; i < n4; ++i) {
            float f = fArray[n3];
            float f2 = fArray[n3 + 1];
            float f3 = fArray[n3 + 2];
            fArray[n3] = fArray[n];
            fArray[n3 + 1] = fArray[n + 1];
            fArray[n3 + 2] = fArray[n + 2];
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f3;
            n += 3;
            n3 -= 3;
        }
    }

    private void reorder(float[] fArray, int n, int n2, int n3) {
        if (n3 == n) {
            return;
        }
        int n4 = n + n2 * 3;
        if (n3 > n && n3 < n4) {
            int n5 = n4 - n;
            float[] fArray2 = new float[n5];
            int n6 = n4 - n3;
            System.arraycopy(fArray, n3, fArray2, 0, n6);
            int n7 = n3 - n;
            System.arraycopy(fArray, n, fArray2, n6, n7);
            System.arraycopy(fArray2, 0, fArray, n, n5);
        }
    }

    private boolean isClockwise(float[] fArray, int n, int n2) {
        float f = 0.0f;
        int n3 = n;
        for (int i = 0; i < n2 - 1; ++i) {
            float f2 = fArray[n3];
            float f3 = fArray[n3 + 1];
            float f4 = fArray[n3 += 3];
            float f5 = fArray[n3 + 1];
            f += f2 * f5 - f4 * f3;
        }
        return f < 0.0f;
    }

    private float[] getBounds(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[]{Float.MAX_VALUE, Float.MIN_VALUE, Float.MAX_VALUE, Float.MIN_VALUE};
        int n3 = n;
        while (n3 < n2) {
            float f = fArray[n3++];
            float f2 = fArray[n3++];
            ++n3;
            if (f < fArray2[0]) {
                fArray2[0] = f;
            }
            if (f > fArray2[1]) {
                fArray2[1] = f;
            }
            if (f2 < fArray2[2]) {
                fArray2[2] = f2;
            }
            if (!(f2 > fArray2[3])) continue;
            fArray2[3] = f2;
        }
        return fArray2;
    }

    private boolean contains(float[] fArray, float[] fArray2) {
        return fArray2[0] > fArray[0] && fArray2[1] < fArray[1] && fArray2[2] > fArray[2] && fArray2[3] < fArray[3];
    }

    private IntHashMap group(float[] fArray, ArrayList<int[]> arrayList) {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = arrayList.size();
        IntHashMap intHashMap = new IntHashMap(n3);
        float[][] fArrayArray = new float[n3][];
        for (int i = 0; i < n3; ++i) {
            int[] nArray = arrayList.get(i);
            fArrayArray[i] = this.getBounds(fArray, nArray[0], nArray[1]);
        }
        int[] nArray = new int[n3 - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = fArrayArray[n2];
            n = 0;
            for (int i = 0; i < n3; ++i) {
                if (i == n2 || !this.contains((float[])objectArray, fArrayArray[i])) continue;
                nArray[n++] = i;
            }
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = nArray[i];
            }
            intHashMap.put(n2, nArray2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = (int[])intHashMap.get(n2);
            if (objectArray == null) continue;
            for (n = 0; n < objectArray.length; ++n) {
                intHashMap.remove((int)objectArray[n]);
            }
        }
        return intHashMap;
    }

    private float[] combine(float[] fArray, ArrayList<int[]> arrayList, IntHashMap intHashMap, int n) {
        float[] fArray2 = null;
        int[] nArray = arrayList.get(n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = n3 - n2;
        int n5 = n4 / 3;
        int[] nArray2 = (int[])intHashMap.get(n);
        int n6 = nArray2.length;
        if (n6 > 0) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = n4;
            int[] nArray3 = new int[n6];
            int n13 = -1;
            int[] nArray4 = null;
            int n14 = -1;
            int n15 = -1;
            int n16 = -1;
            for (int i = 0; i < n6; ++i) {
                n13 = nArray2[i];
                nArray4 = arrayList.get(n13);
                n14 = nArray4[0];
                float f = fArray[n14];
                float f2 = fArray[n14 + 1];
                n15 = nArray4[1];
                n16 = n15 - n14;
                nArray3[i] = this.findClosestPoint(f, f2, fArray, n2, n5);
                n12 += n16 + 3;
            }
            int[] nArray5 = new int[n6];
            boolean[] blArray = new boolean[n6];
            Arrays.fill(blArray, false);
            for (n11 = 0; n11 < n6; ++n11) {
                n10 = 0;
                n9 = Integer.MAX_VALUE;
                for (n8 = 0; n8 < n6; ++n8) {
                    if (blArray[n8] || (n7 = nArray3[n8]) >= n9) continue;
                    n10 = n8;
                    n9 = n7;
                }
                nArray5[n11] = nArray2[n10];
                blArray[n10] = true;
            }
            fArray2 = new float[n12];
            n13 = nArray5[0];
            n11 = -1;
            for (n10 = 0; n10 < n6; ++n10) {
                if (n13 != nArray2[n10]) continue;
                n11 = nArray3[n10];
            }
            n10 = n11 - n2 + 3;
            n9 = 0;
            System.arraycopy(fArray, n2, fArray2, n9, n10);
            n9 += n10;
            for (n8 = 0; n8 < n6; ++n8) {
                n13 = nArray5[n8];
                nArray4 = arrayList.get(n13);
                n14 = nArray4[0];
                n15 = nArray4[1];
                n10 = n15 - n14;
                System.arraycopy(fArray, n14, fArray2, n9, n10);
                n9 += n10;
                if (n8 + 1 >= n6) continue;
                n13 = nArray5[n8 + 1];
                n7 = -1;
                for (int i = 0; i < n6; ++i) {
                    if (n13 != nArray2[i]) continue;
                    n7 = nArray3[i];
                }
                n10 = n7 - n11 + 3;
                System.arraycopy(fArray, n11, fArray2, n9, n10);
                n9 += n10;
                n11 = n7;
            }
            n10 = n3 - n11;
            System.arraycopy(fArray, n11, fArray2, n9, n10);
        } else {
            fArray2 = new float[n4];
            System.arraycopy(fArray, n2, fArray2, 0, n4);
        }
        return fArray2;
    }
}

