/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import org.j3d.geom.EarCutTriangulator;
import org.j3d.geom.SeidelTriangulator;

public class TriangulationUtils {
    private static final int DEFAULT_POLY_SIZE = 6;
    private EarCutTriangulator ecTriangulator;
    private SeidelTriangulator holeTriangulator;
    private int initSize;

    public TriangulationUtils() {
        this(6);
    }

    public TriangulationUtils(int n) {
        this.initSize = n;
    }

    public void triangulatePolygon2D(int n, int[] nArray, float[] fArray, int[] nArray2) {
        if (this.holeTriangulator == null) {
            this.holeTriangulator = new SeidelTriangulator();
        }
        this.holeTriangulator.triangulatePolygon(n, nArray, fArray, nArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int[] nArray, int[] nArray2, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, n, n2, nArray, 0, null, 0, null, 0, null, nArray2, null, null, null, fArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int[] nArray, int[] nArray2, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, 0, nArray.length, nArray, 0, null, 0, null, 0, null, nArray2, null, null, null, fArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, n, n2, nArray, n3, nArray2, n4, nArray3, n5, nArray4, nArray5, nArray6, nArray7, nArray8, fArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int[] nArray, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, n, n2, 0, 0, 0, nArray, null, null, null, fArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int[] nArray, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, 0, fArray.length / 3, 0, 0, 0, nArray, null, null, null, fArray2);
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, float[] fArray2) {
        if (this.ecTriangulator == null) {
            this.ecTriangulator = new EarCutTriangulator(this.initSize);
        }
        return this.ecTriangulator.triangulateConcavePolygon(fArray, n, n2, n3, n4, n5, nArray, nArray2, nArray3, nArray4, fArray2);
    }

    public void clearCachedObjects() {
        this.ecTriangulator.clearCachedObjects();
    }

    public static boolean isConvexVertex(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        float f = fArray[n2 + 1] - fArray[n + 1];
        float f2 = fArray[n3 + 2] - fArray[n2 + 2];
        float f3 = fArray[n2 + 2] - fArray[n + 2];
        float f4 = fArray[n3 + 1] - fArray[n2 + 1];
        float f5 = f * f2 - f3 * f4;
        float f6 = fArray[n3] - fArray[n2];
        float f7 = fArray[n2] - fArray[n];
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = f5 * fArray2[0] + f8 * fArray2[1] + f9 * fArray2[2];
        return f10 >= 0.0f;
    }
}

