/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Random;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.util.I18nManager;

public abstract class BaseEmitter
implements ParticleInitializer {
    private static final String LIFETIME_ERR_PROP = "org.j3d.geom.particle.BaseEmitter.negLifeTimeMsg";
    private static final String NEG_MASS_ERR_PROP = "org.j3d.geom.particle.BaseEmitter.negMassMsg";
    private static final String NEG_AREA_ERR_PROP = "org.j3d.geom.particle.BaseEmitter.negSurfaceAreaMsg";
    private static final String LIFE_VAR_ERR_PROP = "org.j3d.geom.particle.BaseEmitter.lifeVariationMsg";
    protected int lifetime;
    protected int particleCount;
    protected float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float speed;
    protected float variation;
    protected float lifetimeVariation;
    protected float initialMass;
    protected float surfaceArea;
    protected Random randomiser = new Random();

    protected BaseEmitter() {
    }

    protected BaseEmitter(int n, int n2, float[] fArray, float f, float f2) {
        this();
        if (n <= 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(LIFETIME_ERR_PROP);
            throw new IllegalArgumentException(string);
        }
        this.lifetime = n;
        this.particleCount = n2;
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
        this.speed = f;
        this.variation = f2;
        this.initialMass = 0.0f;
        this.surfaceArea = 0.0f;
    }

    public void setMaxParticleCount(int n) {
        this.particleCount = n;
    }

    public int getMaxParticleCount() {
        return this.particleCount;
    }

    public void setParticleLifetime(int n) throws IllegalArgumentException {
        if (n <= 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(LIFETIME_ERR_PROP);
            throw new IllegalArgumentException(string);
        }
        this.lifetime = n;
    }

    public int getParticleLifetime() {
        return this.lifetime;
    }

    public void setLifetimeVariation(float f) throws IllegalArgumentException {
        if (f < 0.0f || f > 1.0f) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(LIFE_VAR_ERR_PROP);
            throw new IllegalArgumentException(string);
        }
        this.lifetimeVariation = f;
    }

    public float getLifetimeVariation() {
        return this.lifetimeVariation;
    }

    public void setParticleVariation(float f) {
        this.variation = f;
    }

    public float getParticleVariation() {
        return this.variation;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
        fArray[3] = this.color[3];
    }

    public void setSurfaceArea(float f) throws IllegalArgumentException {
        if (f < 0.0f) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_AREA_ERR_PROP);
            throw new IllegalArgumentException(string);
        }
        this.surfaceArea = f;
    }

    public float getSurfaceArea() {
        return this.surfaceArea;
    }

    public void setMass(float f) throws IllegalArgumentException {
        if (f < 0.0f) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_MASS_ERR_PROP);
            throw new IllegalArgumentException(string);
        }
        this.initialMass = f;
    }

    public float getMass() {
        return this.initialMass;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public float getSpeed() {
        return this.speed;
    }
}

