/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFactory;
import org.j3d.geom.particle.ParticleFunction;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.ParticleList;
import org.j3d.geom.particle.TexCoordInterpolator;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.I18nManager;

public abstract class ParticleSystem
implements ParticleFactory {
    private static final int NUM_INIT_FUNCTIONS = 5;
    private static final String NEG_PARTICLE_COUNT_PROP = "org.j3d.geom.particle.ParticleSystem.negParticleCountMsg";
    protected ErrorReporter errorReporter;
    private String systemName;
    protected int maxParticleCount;
    protected int particleCount;
    private int creationResidue;
    protected int frameTime;
    protected long timeNow;
    private ArrayList particleFunctions;
    private Particle[] deadParticles;
    private ParticleFunction[] activeFunctions;
    private int numActiveFunctions;
    private int numDeadParticles;
    protected ParticleList particleList;
    protected TexCoordInterpolator texCoordInterp;
    private ParticleInitializer particleInitializer;
    private boolean createParticles;
    private boolean zeroFrame;
    protected boolean genTexCoords;

    public ParticleSystem(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(NEG_PARTICLE_COUNT_PROP);
            throw new IllegalArgumentException(string2);
        }
        this.systemName = string;
        this.particleFunctions = new ArrayList(5);
        this.particleList = new ParticleList();
        this.deadParticles = new Particle[n];
        this.maxParticleCount = n;
        this.numDeadParticles = 0;
        this.frameTime = -1;
        this.createParticles = true;
        this.zeroFrame = false;
        this.genTexCoords = true;
        this.numActiveFunctions = 0;
        this.activeFunctions = new ParticleFunction[5];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void initialize(long l) {
        this.timeNow = l;
        if (this.particleInitializer == null) {
            return;
        }
        if (this.createParticles) {
            this.createNewParticles();
        }
        this.updateGeometry();
    }

    public abstract void onRemove();

    protected abstract void updateGeometry();

    public void enableParticleCreation(boolean bl) {
        this.createParticles = bl;
    }

    public boolean isParticleCreationEnabled() {
        return this.createParticles;
    }

    public void setParticleInitializer(ParticleInitializer particleInitializer) {
        this.particleInitializer = particleInitializer;
    }

    public ParticleInitializer getParticleInitializer() {
        return this.particleInitializer;
    }

    public void addParticleFunction(ParticleFunction particleFunction) {
        if (particleFunction != null) {
            this.particleFunctions.add(particleFunction);
        }
        if (this.activeFunctions.length < this.particleFunctions.size()) {
            this.activeFunctions = new ParticleFunction[this.particleFunctions.size()];
        }
    }

    public void insertParticleFunction(int n, ParticleFunction particleFunction) {
        if (particleFunction != null) {
            int n2 = this.particleFunctions.size();
            if (n > n2) {
                this.particleFunctions.add(particleFunction);
            } else {
                this.particleFunctions.add(n, particleFunction);
            }
            if (this.activeFunctions.length < n2) {
                this.activeFunctions = new ParticleFunction[n2];
            }
        }
    }

    public void removeParticleFunction(ParticleFunction particleFunction) {
        this.particleFunctions.remove(particleFunction);
    }

    public void enableTextureCoordinates(boolean bl) {
        this.genTexCoords = bl;
    }

    public boolean isTextureCoordinateEnabled() {
        return this.genTexCoords;
    }

    public void setTexCoordFunction(float[] fArray, int n, float[] fArray2) {
        if (n == 0) {
            this.texCoordInterp = null;
        } else {
            if (this.texCoordInterp == null) {
                this.texCoordInterp = new TexCoordInterpolator(this.coordinatesPerParticle());
            }
            this.texCoordInterp.setupInterpolants(fArray, n, fArray2);
        }
    }

    public boolean update(long l) {
        if (this.particleInitializer == null) {
            return true;
        }
        this.frameTime = (int)(l - this.timeNow);
        if (this.frameTime == 0) {
            this.frameTime = 1;
            this.zeroFrame = true;
        } else if (this.zeroFrame) {
            this.zeroFrame = false;
            --this.frameTime;
        }
        this.timeNow = l;
        if (this.createParticles) {
            this.createNewParticles();
        }
        this.updateParticleFunctions(this.frameTime);
        this.runParticleFunctions();
        this.updateGeometry();
        return true;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public void setMaxParticleCount(int n) throws IllegalArgumentException {
        if (n < 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_PARTICLE_COUNT_PROP);
            throw new IllegalArgumentException(string);
        }
        if (n > this.deadParticles.length) {
            Particle[] particleArray = new Particle[n];
            System.arraycopy(this.deadParticles, 0, particleArray, 0, this.numDeadParticles);
            this.deadParticles = particleArray;
        }
        this.maxParticleCount = n;
        if (this.particleInitializer != null) {
            this.particleInitializer.setMaxParticleCount(n);
        }
    }

    public int getMaxParticleCount() {
        return this.maxParticleCount;
    }

    private void updateParticleFunctions(int n) {
        int n2 = 0;
        int n3 = this.particleFunctions.size();
        for (int i = 0; i < n3; ++i) {
            ParticleFunction particleFunction = (ParticleFunction)this.particleFunctions.get(i);
            if (!particleFunction.isEnabled()) continue;
            this.activeFunctions[n2++] = particleFunction;
            particleFunction.newFrame(n);
        }
        this.numActiveFunctions = n2;
    }

    private void runParticleFunctions() {
        if (this.particleFunctions.size() == 0 || this.particleList.size() == 0) {
            return;
        }
        int n = this.particleFunctions.size();
        int n2 = this.particleList.size();
        block0: for (int i = 0; i < n2; ++i) {
            Particle particle = this.particleList.next();
            particle.resultantForce.set(0.0f, 0.0f, 0.0f);
            for (int j = 0; j < this.numActiveFunctions; ++j) {
                if (this.activeFunctions[j].apply(particle)) continue;
                this.particleList.remove();
                this.releaseParticle(particle);
                --this.particleCount;
                continue block0;
            }
        }
        this.particleList.reset();
    }

    private void createNewParticles() {
        int n = this.maxParticleCount - this.particleCount;
        int n2 = this.particleInitializer.numParticlesToCreate(this.frameTime) + this.creationResidue;
        int n3 = 0;
        if (n < n2) {
            n3 = n;
            this.creationResidue = n2 - n;
        } else {
            n3 = n2;
            this.creationResidue = 0;
        }
        for (int i = 0; i < n3; ++i) {
            Particle particle = this.fetchParticle();
            particle.wallClockBirth = this.timeNow;
            this.particleInitializer.initialize(particle);
            this.particleList.add(particle);
        }
        this.particleCount += n3;
    }

    private Particle fetchParticle() {
        Particle particle;
        if (this.numDeadParticles != 0) {
            particle = this.deadParticles[this.numDeadParticles - 1];
            this.deadParticles[this.numDeadParticles - 1] = null;
            --this.numDeadParticles;
        } else {
            particle = this.createParticle();
        }
        return particle;
    }

    private void releaseParticle(Particle particle) {
        this.deadParticles[this.numDeadParticles] = particle;
        ++this.numDeadParticles;
    }
}

