/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Random;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFunction;
import org.j3d.util.I18nManager;

public class WindParticleFunction
implements ParticleFunction {
    private static final String NEG_GUSTINESS_MSG = "org.j3d.geom.particle.WindParticleFunction.negGustinessMsg.";
    private float pressure;
    private float currentPressure;
    private float gustiness;
    private float turbulence;
    private boolean enabled;
    private float[] direction;
    private float speed;
    private Random randomiser;

    public WindParticleFunction() {
        this.direction = new float[3];
        this.pressure = 0.0f;
        this.currentPressure = 0.0f;
        this.gustiness = 0.0f;
        this.turbulence = 0.0f;
        this.speed = 0.0f;
        this.enabled = true;
        this.randomiser = new Random();
    }

    public WindParticleFunction(float[] fArray, float f, float f2, float f3) {
        if (f2 < 0.0f) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_GUSTINESS_MSG);
            throw new IllegalArgumentException(string);
        }
        this.direction = new float[3];
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
        this.speed = f;
        this.gustiness = f2;
        this.turbulence = f3;
        this.randomiser = new Random();
        this.enabled = true;
        this.recalculatePressure();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean newFrame(int n) {
        this.currentPressure = this.pressure * this.gustiness * this.randomiser.nextFloat();
        return true;
    }

    public boolean apply(Particle particle) {
        float f = this.currentPressure * this.direction[0];
        float f2 = this.currentPressure * this.direction[1];
        float f3 = this.currentPressure * this.direction[2];
        if (this.turbulence != 0.0f) {
            f += this.randomiser.nextFloat() * this.turbulence;
            f2 += this.randomiser.nextFloat() * this.turbulence;
            f3 += this.randomiser.nextFloat() * this.turbulence;
        }
        particle.resultantForce.x += (f *= particle.surfaceArea);
        particle.resultantForce.y += (f2 *= particle.surfaceArea);
        particle.resultantForce.z += (f3 *= particle.surfaceArea);
        return true;
    }

    public void setSpeed(float f) {
        this.speed = f;
        this.recalculatePressure();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setDirection(float f, float f2, float f3) {
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
    }

    public void getDirection(float[] fArray) {
        fArray[0] = this.direction[0];
        fArray[0] = this.direction[1];
        fArray[0] = this.direction[2];
    }

    public void setGustiness(float f) throws IllegalArgumentException {
        if (f < 0.0f) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_GUSTINESS_MSG);
            throw new IllegalArgumentException(string);
        }
        this.gustiness = f;
    }

    public float getGustiness() {
        return this.gustiness;
    }

    public void setTurbulence(float f) {
        this.turbulence = f;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    private void recalculatePressure() {
        this.pressure = (float)(Math.pow(10.0, 2.0 * Math.log(this.speed)) * 0.64615);
    }
}

