/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import org.j3d.geom.triangulation.Triangulator;

class BBox {
    int imin;
    int imax;
    double ymin;
    double ymax;

    BBox(Triangulator triangulator, int n, int n2) {
        this.imin = Math.min(n, n2);
        this.imax = Math.max(n, n2);
        this.ymin = Math.min(triangulator.points[this.imin].y, triangulator.points[this.imax].y);
        this.ymax = Math.max(triangulator.points[this.imin].y, triangulator.points[this.imax].y);
    }

    boolean pntInBBox(Triangulator triangulator, int n) {
        return this.imax < n ? false : (this.imin > n ? false : (this.ymax < (double)triangulator.points[n].y ? false : !(this.ymin > (double)triangulator.points[n].y)));
    }

    boolean BBoxOverlap(BBox bBox) {
        return this.imax < bBox.imin ? false : (this.imin > bBox.imax ? false : (this.ymax < bBox.ymin ? false : !(this.ymin > bBox.ymax)));
    }

    boolean BBoxContained(BBox bBox) {
        return this.imin <= bBox.imin && this.imax >= bBox.imax && this.ymin <= bBox.ymin && this.ymax >= bBox.ymax;
    }

    boolean BBoxIdenticalLeaf(BBox bBox) {
        return this.imin == bBox.imin && this.imax == bBox.imax;
    }

    void BBoxUnion(BBox bBox, BBox bBox2) {
        bBox2.imin = Math.min(this.imin, bBox.imin);
        bBox2.imax = Math.max(this.imax, bBox.imax);
        bBox2.ymin = Math.min(this.ymin, bBox.ymin);
        bBox2.ymax = Math.max(this.ymax, bBox.ymax);
    }

    double BBoxArea(Triangulator triangulator) {
        return (double)(triangulator.points[this.imax].x - triangulator.points[this.imin].x) * (this.ymax - this.ymin);
    }
}

