/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import javax.vecmath.Tuple2f;
import org.j3d.geom.triangulation.BBox;
import org.j3d.geom.triangulation.Distance;
import org.j3d.geom.triangulation.Left;
import org.j3d.geom.triangulation.NoHash;
import org.j3d.geom.triangulation.Numerics;
import org.j3d.geom.triangulation.Triangulator;

class Bridge {
    Bridge() {
    }

    static void constructBridges(Triangulator triangulator, int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        if (!triangulator.noHashingEdges) {
            System.out.println("Bridge:constructBridges noHashingEdges is false");
        }
        if (n2 <= n) {
            System.out.println("Bridge:constructBridges loopMax<=loopMin");
        }
        if (n < 0) {
            System.out.println("Bridge:constructBridges loopMin<0");
        }
        if (n2 > triangulator.numLoops) {
            System.out.println("Bridge:constructBridges loopMax>triRef.numLoops");
        }
        if ((n4 = n2 - n - 1) > triangulator.maxNumLeftMost) {
            triangulator.maxNumLeftMost = n4;
            triangulator.leftMost = new Left[n4];
        }
        Bridge.findLeftMostVertex(triangulator, triangulator.loops[n], nArray2, nArray);
        int n5 = 0;
        for (int i = n + 1; i < n2; ++i) {
            Bridge.findLeftMostVertex(triangulator, triangulator.loops[i], nArray6, nArray5);
            triangulator.leftMost[n5] = new Left();
            triangulator.leftMost[n5].ind = nArray6[0];
            triangulator.leftMost[n5].index = nArray5[0];
            ++n5;
        }
        Bridge.sortLeft(triangulator.leftMost, n4);
        triangulator.maxNumDist = n3 = triangulator.numPoints + 2 * triangulator.numLoops;
        triangulator.distances = new Distance[n3];
        for (int i = 0; i < triangulator.maxNumDist; ++i) {
            triangulator.distances[i] = new Distance();
        }
        for (n5 = 0; n5 < n4; ++n5) {
            if (!Bridge.findBridge(triangulator, nArray2[0], nArray[0], triangulator.leftMost[n5].index, nArray4, nArray3)) {
                // empty if block
            }
            if (nArray3[0] == triangulator.leftMost[n5].index) {
                Bridge.simpleBridge(triangulator, nArray4[0], triangulator.leftMost[n5].ind);
                continue;
            }
            Bridge.insertBridge(triangulator, nArray4[0], nArray3[0], triangulator.leftMost[n5].ind, triangulator.leftMost[n5].index);
        }
    }

    static boolean findBridge(Triangulator triangulator, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        BBox bBox;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = 0;
        Distance[] distanceArray = null;
        nArray[0] = n;
        nArray2[0] = n2;
        if (nArray2[0] == n3) {
            return true;
        }
        if (n10 >= triangulator.maxNumDist) {
            triangulator.maxNumDist += 50;
            distanceArray = triangulator.distances;
            triangulator.distances = new Distance[triangulator.maxNumDist];
            System.arraycopy(distanceArray, 0, triangulator.distances, 0, distanceArray.length);
            for (n9 = distanceArray.length; n9 < triangulator.maxNumDist; ++n9) {
                triangulator.distances[n9] = new Distance();
            }
        }
        triangulator.distances[n10].dist = Numerics.baseLength((Tuple2f)triangulator.points[n3], (Tuple2f)triangulator.points[nArray2[0]]);
        triangulator.distances[n10].ind = nArray[0];
        ++n10;
        nArray[0] = triangulator.fetchNextData(nArray[0]);
        nArray2[0] = triangulator.fetchData(nArray[0]);
        while (nArray[0] != n) {
            if (nArray2[0] == n3) {
                return true;
            }
            if (n10 >= triangulator.maxNumDist) {
                triangulator.maxNumDist += 50;
                distanceArray = triangulator.distances;
                triangulator.distances = new Distance[triangulator.maxNumDist];
                System.arraycopy(distanceArray, 0, triangulator.distances, 0, distanceArray.length);
                for (n9 = distanceArray.length; n9 < triangulator.maxNumDist; ++n9) {
                    triangulator.distances[n9] = new Distance();
                }
            }
            triangulator.distances[n10].dist = Numerics.baseLength((Tuple2f)triangulator.points[n3], (Tuple2f)triangulator.points[nArray2[0]]);
            triangulator.distances[n10].ind = nArray[0];
            ++n10;
            nArray[0] = triangulator.fetchNextData(nArray[0]);
            nArray2[0] = triangulator.fetchData(nArray[0]);
        }
        Bridge.sortDistance(triangulator.distances, n10);
        for (n8 = 0; n8 < n10; ++n8) {
            boolean bl;
            boolean bl2;
            nArray[0] = triangulator.distances[n8].ind;
            nArray2[0] = triangulator.fetchData(nArray[0]);
            if (nArray2[0] > n3 || !(bl2 = Numerics.isInCone(triangulator, n7 = triangulator.fetchData(n6 = triangulator.fetchPrevData(nArray[0])), nArray2[0], n5 = triangulator.fetchData(n4 = triangulator.fetchNextData(nArray[0])), n3, bl = triangulator.getAngle(nArray[0]) > 0)) || NoHash.noHashEdgeIntersectionExists(triangulator, bBox = new BBox(triangulator, nArray2[0], n3), -1, -1, nArray[0], -1)) continue;
            return true;
        }
        for (n8 = 0; n8 < n10; ++n8) {
            nArray[0] = triangulator.distances[n8].ind;
            nArray2[0] = triangulator.fetchData(nArray[0]);
            n6 = triangulator.fetchPrevData(nArray[0]);
            n7 = triangulator.fetchData(n6);
            n4 = triangulator.fetchNextData(nArray[0]);
            n5 = triangulator.fetchData(n4);
            bBox = new BBox(triangulator, nArray2[0], n3);
            if (NoHash.noHashEdgeIntersectionExists(triangulator, bBox, -1, -1, nArray[0], -1)) continue;
            return true;
        }
        nArray[0] = n;
        nArray2[0] = n2;
        return false;
    }

    static void findLeftMostVertex(Triangulator triangulator, int n, int[] nArray, int[] nArray2) {
        int n2 = n;
        int n3 = triangulator.fetchData(n2);
        nArray[0] = n2;
        nArray2[0] = n3;
        n2 = triangulator.fetchNextData(n2);
        n3 = triangulator.fetchData(n2);
        while (n2 != n) {
            if (n3 < nArray2[0]) {
                nArray[0] = n2;
                nArray2[0] = n3;
            } else if (n3 == nArray2[0] && triangulator.getAngle(n2) < 0) {
                nArray[0] = n2;
                nArray2[0] = n3;
            }
            n2 = triangulator.fetchNextData(n2);
            n3 = triangulator.fetchData(n2);
        }
    }

    static void simpleBridge(Triangulator triangulator, int n, int n2) {
        triangulator.rotateLinks(n, n2);
        int n3 = triangulator.fetchData(n);
        int n4 = triangulator.fetchNextData(n);
        int n5 = triangulator.fetchData(n4);
        int n6 = triangulator.fetchPrevData(n);
        int n7 = triangulator.fetchData(n6);
        int n8 = Numerics.isConvexAngle(triangulator, n7, n3, n5, n);
        triangulator.setAngle(n, n8);
        int n9 = triangulator.fetchData(n2);
        n4 = triangulator.fetchNextData(n2);
        n5 = triangulator.fetchData(n4);
        n6 = triangulator.fetchPrevData(n2);
        n7 = triangulator.fetchData(n6);
        n8 = Numerics.isConvexAngle(triangulator, n7, n9, n5, n2);
        triangulator.setAngle(n2, n8);
    }

    static void insertBridge(Triangulator triangulator, int n, int n2, int n3, int n4) {
        int n5 = triangulator.makeNode(n2);
        triangulator.insertAfter(n, n5);
        int n6 = triangulator.list[n].getCommonIndex();
        triangulator.list[n5].setCommonIndex(n6);
        int n7 = triangulator.makeNode(n4);
        triangulator.insertAfter(n3, n7);
        n6 = triangulator.list[n3].getCommonIndex();
        triangulator.list[n7].setCommonIndex(n6);
        triangulator.splitSplice(n, n5, n3, n7);
        int n8 = triangulator.fetchNextData(n);
        int n9 = triangulator.fetchData(n8);
        int n10 = triangulator.fetchPrevData(n);
        int n11 = triangulator.fetchData(n10);
        int n12 = Numerics.isConvexAngle(triangulator, n11, n2, n9, n);
        triangulator.setAngle(n, n12);
        n8 = triangulator.fetchNextData(n5);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n5);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n2, n9, n5);
        triangulator.setAngle(n5, n12);
        n8 = triangulator.fetchNextData(n3);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n3);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n4, n9, n3);
        triangulator.setAngle(n3, n12);
        n8 = triangulator.fetchNextData(n7);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n7);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n4, n9, n7);
        triangulator.setAngle(n7, n12);
    }

    static int l_comp(Left left, Left left2) {
        if (left.index < left2.index) {
            return -1;
        }
        if (left.index > left2.index) {
            return 1;
        }
        return 0;
    }

    static int d_comp(Distance distance, Distance distance2) {
        if (distance.dist < distance2.dist) {
            return -1;
        }
        if (distance.dist > distance2.dist) {
            return 1;
        }
        return 0;
    }

    static void sortLeft(Left[] leftArray, int n) {
        Left left = new Left();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (Bridge.l_comp(leftArray[i], leftArray[j]) <= 0) continue;
                left.copy(leftArray[i]);
                leftArray[i].copy(leftArray[j]);
                leftArray[j].copy(left);
            }
        }
    }

    static void sortDistance(Distance[] distanceArray, int n) {
        Distance distance = new Distance();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (Bridge.d_comp(distanceArray[i], distanceArray[j]) <= 0) continue;
                distance.copy(distanceArray[i]);
                distanceArray[i].copy(distanceArray[j]);
                distanceArray[j].copy(distance);
            }
        }
    }
}

