/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.j3d.geom.triangulation.BBox;
import org.j3d.geom.triangulation.Basic;
import org.j3d.geom.triangulation.Bridge;
import org.j3d.geom.triangulation.Distance;
import org.j3d.geom.triangulation.Heap;
import org.j3d.geom.triangulation.NoHash;
import org.j3d.geom.triangulation.Numerics;
import org.j3d.geom.triangulation.Triangulator;

class Desperate {
    Desperate() {
    }

    static boolean desperate(Triangulator triangulator, int n, int n2, boolean[] blArray) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        int[] nArray7 = new int[1];
        int[] nArray8 = new int[1];
        blArray[0] = false;
        if (Desperate.existsCrossOver(triangulator, n, nArray5, nArray, nArray6, nArray2, nArray7, nArray3, nArray8, nArray4)) {
            Desperate.handleCrossOver(triangulator, nArray5[0], nArray[0], nArray6[0], nArray2[0], nArray7[0], nArray3[0], nArray8[0], nArray4[0]);
            return false;
        }
        NoHash.prepareNoHashEdges(triangulator, n2, n2 + 1);
        if (Desperate.existsSplit(triangulator, n, nArray5, nArray, nArray6, nArray2)) {
            Desperate.handleSplit(triangulator, nArray5[0], nArray[0], nArray6[0], nArray2[0]);
            blArray[0] = true;
            return false;
        }
        return true;
    }

    static boolean existsCrossOver(Triangulator triangulator, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8) {
        nArray[0] = n;
        nArray2[0] = triangulator.fetchData(nArray[0]);
        nArray3[0] = triangulator.fetchNextData(nArray[0]);
        nArray4[0] = triangulator.fetchData(nArray3[0]);
        nArray5[0] = triangulator.fetchNextData(nArray3[0]);
        nArray6[0] = triangulator.fetchData(nArray5[0]);
        nArray7[0] = triangulator.fetchNextData(nArray5[0]);
        nArray8[0] = triangulator.fetchData(nArray7[0]);
        do {
            BBox bBox;
            BBox bBox2;
            if ((bBox2 = new BBox(triangulator, nArray2[0], nArray4[0])).BBoxOverlap(bBox = new BBox(triangulator, nArray6[0], nArray8[0])) && Numerics.segIntersect(triangulator, bBox2.imin, bBox2.imax, bBox.imin, bBox.imax, -1)) {
                return true;
            }
            nArray[0] = nArray3[0];
            nArray2[0] = nArray4[0];
            nArray3[0] = nArray5[0];
            nArray4[0] = nArray6[0];
            nArray5[0] = nArray7[0];
            nArray6[0] = nArray8[0];
            nArray7[0] = triangulator.fetchNextData(nArray5[0]);
            nArray8[0] = triangulator.fetchData(nArray7[0]);
        } while (nArray[0] != n);
        return false;
    }

    static void handleCrossOver(Triangulator triangulator, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl;
        int n9;
        int n10 = triangulator.getAngle(n);
        if (n10 < (n9 = triangulator.getAngle(n7))) {
            bl = true;
        } else if (n10 > n9) {
            bl = false;
        } else if (triangulator.earsSorted) {
            double d = Numerics.getRatio(triangulator, n6, n8, n2);
            double d2 = Numerics.getRatio(triangulator, n2, n4, n8);
            bl = !(d2 < d);
        } else {
            bl = true;
        }
        if (bl) {
            triangulator.deleteLinks(n3);
            triangulator.storeTriangle(n, n3, n5);
            triangulator.setAngle(n5, 1);
            Heap.insertIntoHeap(triangulator, 0.0, n5, n, n7);
        } else {
            triangulator.deleteLinks(n5);
            triangulator.storeTriangle(n3, n5, n7);
            triangulator.setAngle(n3, 1);
            Heap.insertIntoHeap(triangulator, 0.0, n3, n, n7);
        }
    }

    static boolean letsHope(Triangulator triangulator, int n) {
        int n2 = n;
        int n3 = triangulator.fetchData(n2);
        do {
            if (triangulator.getAngle(n2) > 0) {
                int n4 = triangulator.fetchPrevData(n2);
                int n5 = triangulator.fetchData(n4);
                int n6 = triangulator.fetchNextData(n2);
                int n7 = triangulator.fetchData(n6);
                Heap.insertIntoHeap(triangulator, 0.0, n2, n4, n6);
                return true;
            }
            n2 = triangulator.fetchNextData(n2);
            n3 = triangulator.fetchData(n2);
        } while (n2 != n);
        triangulator.setAngle(n, 1);
        int n8 = triangulator.fetchPrevData(n);
        int n9 = triangulator.fetchData(n8);
        int n10 = triangulator.fetchNextData(n);
        int n11 = triangulator.fetchData(n10);
        Heap.insertIntoHeap(triangulator, 0.0, n, n8, n10);
        n3 = triangulator.fetchData(n);
        return true;
    }

    static boolean existsSplit(Triangulator triangulator, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2;
        int n3;
        int n4;
        if (triangulator.numPoints > triangulator.maxNumDist) {
            triangulator.maxNumDist = triangulator.numPoints;
            triangulator.distances = new Distance[triangulator.maxNumDist];
            for (int i = 0; i < triangulator.maxNumDist; ++i) {
                triangulator.distances[i] = new Distance();
            }
        }
        nArray[0] = n;
        nArray2[0] = triangulator.fetchData(nArray[0]);
        int n5 = triangulator.fetchNextData(nArray[0]);
        int n6 = triangulator.fetchData(n5);
        int n7 = triangulator.fetchNextData(n5);
        if (Desperate.foundSplit(triangulator, n7, n4 = triangulator.fetchData(n7), n3 = triangulator.fetchPrevData(nArray[0]), nArray[0], nArray2[0], n2 = triangulator.fetchData(n3), n6, nArray3, nArray4)) {
            return true;
        }
        n2 = nArray2[0];
        nArray[0] = n5;
        nArray2[0] = n6;
        n5 = n7;
        n6 = n4;
        n7 = triangulator.fetchNextData(n5);
        n4 = triangulator.fetchData(n7);
        while (n7 != n) {
            if (Desperate.foundSplit(triangulator, n7, n4, n, nArray[0], nArray2[0], n2, n6, nArray3, nArray4)) {
                return true;
            }
            n2 = nArray2[0];
            nArray[0] = n5;
            nArray2[0] = n6;
            n5 = n7;
            n6 = n4;
            n7 = triangulator.fetchNextData(n5);
            n4 = triangulator.fetchData(n7);
        }
        return false;
    }

    static int windingNumber(Triangulator triangulator, int n, Point2f point2f) {
        int n2 = triangulator.fetchData(n);
        int n3 = triangulator.fetchNextData(n);
        int n4 = triangulator.fetchData(n3);
        double d = Numerics.angle(triangulator, point2f, triangulator.points[n2], triangulator.points[n4]);
        while (n3 != n) {
            n2 = n4;
            n3 = triangulator.fetchNextData(n3);
            n4 = triangulator.fetchData(n3);
            d += Numerics.angle(triangulator, point2f, triangulator.points[n2], triangulator.points[n4]);
        }
        int n5 = (int)((d += Math.PI) / (Math.PI * 2));
        return n5;
    }

    static boolean foundSplit(Triangulator triangulator, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        int n8 = 0;
        do {
            triangulator.distances[n8].dist = Numerics.baseLength((Tuple2f)triangulator.points[n5], (Tuple2f)triangulator.points[n2]);
            triangulator.distances[n8].ind = n;
            ++n8;
            n = triangulator.fetchNextData(n);
            n2 = triangulator.fetchData(n);
        } while (n != n3);
        Bridge.sortDistance(triangulator.distances, n8);
        for (int i = 0; i < n8; ++i) {
            BBox bBox;
            boolean bl;
            int n9;
            int n10;
            int n11;
            int n12;
            boolean bl2;
            nArray[0] = triangulator.distances[i].ind;
            nArray2[0] = triangulator.fetchData(nArray[0]);
            if (n5 == nArray2[0] || !(bl2 = Numerics.isInCone(triangulator, n12 = triangulator.fetchData(n11 = triangulator.fetchPrevData(nArray[0])), nArray2[0], n10 = triangulator.fetchData(n9 = triangulator.fetchNextData(nArray[0])), n5, bl = triangulator.getAngle(nArray[0]) > 0)) || !(bl2 = Numerics.isInCone(triangulator, n6, n5, n7, nArray2[0], bl = triangulator.getAngle(n4) > 0)) || NoHash.noHashEdgeIntersectionExists(triangulator, bBox = new BBox(triangulator, n5, nArray2[0]), -1, -1, n4, -1)) continue;
            Point2f point2f = new Point2f();
            Basic.vectorAdd2D((Tuple2f)triangulator.points[n5], (Tuple2f)triangulator.points[nArray2[0]], (Tuple2f)point2f);
            Basic.multScalar2D(0.5, (Tuple2f)point2f);
            if (Desperate.windingNumber(triangulator, n3, point2f) != 1) continue;
            return true;
        }
        return false;
    }

    static void handleSplit(Triangulator triangulator, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = triangulator.makeNode(n2);
        triangulator.insertAfter(n, n6);
        n5 = triangulator.list[n].getCommonIndex();
        triangulator.list[n6].setCommonIndex(n5);
        int n7 = triangulator.makeNode(n4);
        triangulator.insertAfter(n3, n7);
        n5 = triangulator.list[n3].getCommonIndex();
        triangulator.list[n7].setCommonIndex(n5);
        triangulator.splitSplice(n, n6, n3, n7);
        triangulator.storeChain(n);
        triangulator.storeChain(n3);
        int n8 = triangulator.fetchNextData(n);
        int n9 = triangulator.fetchData(n8);
        int n10 = triangulator.fetchPrevData(n);
        int n11 = triangulator.fetchData(n10);
        int n12 = Numerics.isConvexAngle(triangulator, n11, n2, n9, n);
        triangulator.setAngle(n, n12);
        n8 = triangulator.fetchNextData(n6);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n6);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n2, n9, n6);
        triangulator.setAngle(n6, n12);
        n8 = triangulator.fetchNextData(n3);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n3);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n4, n9, n3);
        triangulator.setAngle(n3, n12);
        n8 = triangulator.fetchNextData(n7);
        n9 = triangulator.fetchData(n8);
        n10 = triangulator.fetchPrevData(n7);
        n11 = triangulator.fetchData(n10);
        n12 = Numerics.isConvexAngle(triangulator, n11, n4, n9, n7);
        triangulator.setAngle(n7, n12);
    }
}

