/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import org.j3d.geom.triangulation.BBox;
import org.j3d.geom.triangulation.BottleNeck;
import org.j3d.geom.triangulation.Degenerate;
import org.j3d.geom.triangulation.Numerics;
import org.j3d.geom.triangulation.PntNode;
import org.j3d.geom.triangulation.Triangulator;

class NoHash {
    static final int NIL = -1;

    NoHash() {
    }

    static void insertAfterVtx(Triangulator triangulator, int n) {
        if (triangulator.vtxList == null) {
            int n2 = Math.max(triangulator.numVtxList + 1, 100);
            triangulator.vtxList = new PntNode[n2];
        } else if (triangulator.numVtxList >= triangulator.vtxList.length) {
            int n3 = Math.max(triangulator.numVtxList + 1, triangulator.vtxList.length + 100);
            PntNode[] pntNodeArray = triangulator.vtxList;
            triangulator.vtxList = new PntNode[n3];
            System.arraycopy(pntNodeArray, 0, triangulator.vtxList, 0, pntNodeArray.length);
        }
        triangulator.vtxList[triangulator.numVtxList] = new PntNode();
        triangulator.vtxList[triangulator.numVtxList].pnt = n;
        triangulator.vtxList[triangulator.numVtxList].next = triangulator.reflexVertices;
        triangulator.reflexVertices = triangulator.numVtxList++;
        ++triangulator.numReflex;
    }

    static void deleteFromList(Triangulator triangulator, int n) {
        if (triangulator.numReflex == 0) {
            return;
        }
        int n2 = triangulator.reflexVertices;
        int n3 = triangulator.vtxList[n2].pnt;
        if (n3 == n) {
            triangulator.reflexVertices = triangulator.vtxList[n2].next;
            --triangulator.numReflex;
        } else {
            int n4 = triangulator.vtxList[n2].next;
            while (n4 != -1) {
                n3 = triangulator.vtxList[n4].pnt;
                if (n3 == n) {
                    triangulator.vtxList[n2].next = triangulator.vtxList[n4].next;
                    n4 = -1;
                    --triangulator.numReflex;
                    continue;
                }
                n2 = n4;
                n4 = triangulator.vtxList[n2].next;
            }
        }
    }

    static boolean inVtxList(Triangulator triangulator, int n) {
        return 0 <= n && n < triangulator.numVtxList;
    }

    static void freeNoHash(Triangulator triangulator) {
        triangulator.noHashingEdges = false;
        triangulator.noHashingPnts = false;
        triangulator.numVtxList = 0;
    }

    static void prepareNoHashEdges(Triangulator triangulator, int n, int n2) {
        triangulator.loopMin = n;
        triangulator.loopMax = n2;
        triangulator.noHashingEdges = true;
    }

    static void prepareNoHashPnts(Triangulator triangulator, int n) {
        int n2;
        triangulator.numVtxList = 0;
        triangulator.reflexVertices = -1;
        int n3 = n2 = triangulator.loops[n];
        triangulator.numReflex = 0;
        int n4 = triangulator.fetchData(n3);
        do {
            if (triangulator.getAngle(n3) < 0) {
                NoHash.insertAfterVtx(triangulator, n3);
            }
            n3 = triangulator.fetchNextData(n3);
            n4 = triangulator.fetchData(n3);
        } while (n3 != n2);
        triangulator.noHashingPnts = true;
    }

    static boolean noHashIntersectionExists(Triangulator triangulator, int n, int n2, int n3, int n4, BBox bBox) {
        int[] nArray = new int[1];
        if (triangulator.numReflex <= 0) {
            return false;
        }
        if (n < bBox.imin) {
            bBox.imin = n;
        } else if (n > bBox.imax) {
            bBox.imax = n;
        }
        double d = triangulator.points[n].y;
        if (d < bBox.ymin) {
            bBox.ymin = d;
        } else if (d > bBox.ymax) {
            bBox.ymax = d;
        }
        int n5 = triangulator.reflexVertices;
        boolean bl = false;
        do {
            int n6;
            int n7;
            if (!bBox.pntInBBox(triangulator, n7 = triangulator.fetchData(n6 = triangulator.vtxList[n5].pnt))) continue;
            int n8 = triangulator.fetchNextData(n6);
            int n9 = triangulator.fetchData(n8);
            if (n6 == n2 || n6 == n8 || !(n7 == n ? Degenerate.handleDegeneracies(triangulator, n, n2, n3, n4, n7, n6) : n7 != n3 && n7 != n4 && (bl = Numerics.vtxInTriangle(triangulator, n, n3, n4, n7, nArray)))) continue;
            return true;
        } while ((n5 = triangulator.vtxList[n5].next) != -1);
        return false;
    }

    static void deleteReflexVertex(Triangulator triangulator, int n) {
        NoHash.deleteFromList(triangulator, n);
    }

    static boolean noHashEdgeIntersectionExists(Triangulator triangulator, BBox bBox, int n, int n2, int n3, int n4) {
        triangulator.identCntr = 0;
        for (int i = triangulator.loopMin; i < triangulator.loopMax; ++i) {
            int n5;
            int n6 = n5 = triangulator.loops[i];
            int n7 = triangulator.fetchData(n6);
            do {
                int n8;
                BBox bBox2;
                if (bBox.BBoxOverlap(bBox2 = new BBox(triangulator, n7, n8 = triangulator.fetchData(n6 = triangulator.fetchNextData(n6)))) && Numerics.segIntersect(triangulator, bBox.imin, bBox.imax, bBox2.imin, bBox2.imax, n4)) {
                    return true;
                }
                n7 = n8;
            } while (n6 != n5);
        }
        if (triangulator.identCntr >= 4) {
            return BottleNeck.checkBottleNeck(triangulator, n4, n, n2, n3);
        }
        return false;
    }
}

