/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import org.j3d.geom.triangulation.Numerics;
import org.j3d.geom.triangulation.Triangulator;

class Orientation {
    Orientation() {
    }

    static void adjustOrientation(Triangulator triangulator, int n, int n2) {
        int n3;
        int n4;
        if (triangulator.numLoops >= triangulator.maxNumPolyArea) {
            triangulator.maxNumPolyArea = triangulator.numLoops;
            double[] dArray = triangulator.polyArea;
            triangulator.polyArea = new double[triangulator.maxNumPolyArea];
            if (dArray != null) {
                System.arraycopy(dArray, 0, triangulator.polyArea, 0, dArray.length);
            }
        }
        for (n4 = n; n4 < n2; ++n4) {
            n3 = triangulator.loops[n4];
            triangulator.polyArea[n4] = Orientation.polygonArea(triangulator, n3);
        }
        double d = Math.abs(triangulator.polyArea[n]);
        int n5 = n;
        for (n4 = n + 1; n4 < n2; ++n4) {
            if (!(d < Math.abs(triangulator.polyArea[n4]))) continue;
            d = Math.abs(triangulator.polyArea[n4]);
            n5 = n4;
        }
        if (n5 != n) {
            n3 = triangulator.loops[n];
            triangulator.loops[n] = triangulator.loops[n5];
            triangulator.loops[n5] = n3;
            d = triangulator.polyArea[n];
            triangulator.polyArea[n] = triangulator.polyArea[n5];
            triangulator.polyArea[n5] = d;
        }
        if (triangulator.polyArea[n] < 0.0) {
            triangulator.swapLinks(triangulator.loops[n]);
        }
        for (n4 = n + 1; n4 < n2; ++n4) {
            if (!(triangulator.polyArea[n4] > 0.0)) continue;
            triangulator.swapLinks(triangulator.loops[n4]);
        }
    }

    static double polygonArea(Triangulator triangulator, int n) {
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = n;
        int n4 = triangulator.fetchData(n3);
        int n5 = triangulator.fetchNextData(n3);
        int n6 = triangulator.fetchData(n5);
        d = Numerics.stableDet2D(triangulator, n2, n4, n6);
        n3 = n5;
        n4 = n6;
        while (n3 != n) {
            n5 = triangulator.fetchNextData(n3);
            n6 = triangulator.fetchData(n5);
            d2 = Numerics.stableDet2D(triangulator, n2, n4, n6);
            d += d2;
            n3 = n5;
            n4 = n6;
        }
        return d;
    }

    static void determineOrientation(Triangulator triangulator, int n) {
        double d = Orientation.polygonArea(triangulator, n);
        if (d < 0.0) {
            triangulator.swapLinks(n);
            triangulator.ccwLoop = false;
        }
    }
}

