/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d;

import java.util.ArrayList;
import org.j3d.loaders.ac3d.Ac3dSurface;

public class Ac3dObject {
    private static float[] IDENTITY_MATRIX_ARRAY = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private String name;
    private String type;
    private float[] location;
    private float[] rotation;
    private float[] vertices;
    private String texture;
    private float[] textureRepeat;
    private String data;
    private String url;
    private float creaseAngle = 45.0f;
    private ArrayList<Ac3dObject> kids = new ArrayList();
    private ArrayList<Ac3dSurface> surfaces = new ArrayList();

    public Ac3dObject() {
        this.location = new float[3];
        this.textureRepeat = new float[2];
        this.textureRepeat[0] = 1.0f;
        this.textureRepeat[1] = 1.0f;
        this.rotation = new float[9];
        System.arraycopy(IDENTITY_MATRIX_ARRAY, 0, this.rotation, 0, 9);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setCreaseAngle(float f) {
        this.creaseAngle = f;
    }

    public float getCreaseAngle() {
        return this.creaseAngle;
    }

    public int getNumKids() {
        return this.kids.size();
    }

    public void addChild(Ac3dObject ac3dObject) {
        this.kids.add(ac3dObject);
    }

    public Ac3dObject getChild(int n) {
        if (n < 0 || n >= this.kids.size()) {
            return null;
        }
        return this.kids.get(n);
    }

    public void setNumvert(int n) {
        if (this.vertices == null) {
            this.vertices = new float[n * 3];
        } else if (this.vertices.length < n * 3) {
            float[] fArray = new float[n * 3];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertices.length);
            this.vertices = fArray;
        }
    }

    public int getNumvert() {
        return this.vertices.length / 3;
    }

    public void setLocation(float[] fArray) {
        this.location[0] = fArray[0];
        this.location[1] = fArray[1];
        this.location[2] = fArray[2];
    }

    public float[] getLocation() {
        return this.location;
    }

    public void setRotation(float[] fArray) {
        this.rotation[0] = fArray[0];
        this.rotation[1] = fArray[1];
        this.rotation[2] = fArray[2];
        this.rotation[3] = fArray[3];
        this.rotation[4] = fArray[4];
        this.rotation[5] = fArray[5];
        this.rotation[6] = fArray[6];
        this.rotation[7] = fArray[7];
        this.rotation[8] = fArray[8];
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public int getNumSurfaces() {
        return this.surfaces.size();
    }

    public void addSurface(Ac3dSurface ac3dSurface) {
        this.surfaces.add(ac3dSurface);
    }

    public Ac3dSurface getSurface(int n) {
        return this.surfaces.get(n);
    }

    public void addVertex(int n, float[] fArray) {
        this.vertices[3 * n] = fArray[0];
        this.vertices[3 * n + 1] = fArray[1];
        this.vertices[3 * n + 2] = fArray[2];
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void getVertex(int n, float[] fArray) {
        fArray[0] = this.vertices[3 * n];
        fArray[1] = this.vertices[3 * n + 1];
        fArray[2] = this.vertices[3 * n + 2];
    }

    public void setTexture(String string) {
        this.texture = string;
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTextureRepeat(float[] fArray) {
        this.textureRepeat[0] = fArray[0];
        this.textureRepeat[1] = fArray[1];
        this.textureRepeat[2] = fArray[2];
    }

    public float[] getTextureRepeat() {
        return this.textureRepeat;
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ name=\"");
        if (this.name == null) {
            stringBuffer.append("(not set)");
        } else {
            stringBuffer.append(this.name);
        }
        stringBuffer.append("\", type=\"");
        if (this.type == null) {
            stringBuffer.append("(not set)");
        } else {
            stringBuffer.append(this.type);
        }
        stringBuffer.append("\"");
        if (this.texture != null) {
            stringBuffer.append(", texture=\"");
            stringBuffer.append(this.texture);
            stringBuffer.append("\"");
        }
        if (this.url != null) {
            stringBuffer.append(", url=\"");
            stringBuffer.append(this.url);
            stringBuffer.append("\"");
        }
        if (this.data != null) {
            stringBuffer.append(", data=\"");
            stringBuffer.append(this.data);
            stringBuffer.append("\"");
        }
        stringBuffer.append(", numKids=");
        stringBuffer.append(this.kids.size());
        stringBuffer.append(", numvert=");
        if (this.vertices == null) {
            stringBuffer.append("0");
        } else {
            stringBuffer.append(this.vertices.length / 3);
        }
        stringBuffer.append(", location={");
        this.stringifyXf(this.location, stringBuffer);
        stringBuffer.append("}, rotation={");
        this.stringifyXf(this.rotation, stringBuffer);
        stringBuffer.append("}, numsurf=");
        stringBuffer.append(this.surfaces.size());
        stringBuffer.append("}, creaseAngle=");
        stringBuffer.append(this.creaseAngle);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void stringifyXf(float[] fArray, StringBuffer stringBuffer) {
        if (fArray.length > 0) {
            stringBuffer.append(fArray[0]);
            for (int i = 1; i < fArray.length; ++i) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[i]);
            }
        }
    }
}

