/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.loaders.InvalidFormatException;
import org.j3d.loaders.ParsingErrorException;
import org.j3d.loaders.UnsupportedFormatException;
import org.j3d.loaders.ac3d.Ac3dMaterial;
import org.j3d.loaders.ac3d.Ac3dObject;
import org.j3d.loaders.ac3d.Ac3dParseObserver;
import org.j3d.loaders.ac3d.Ac3dSurface;
import org.j3d.loaders.ac3d.LineTokenizer;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.I18nManager;

public class Ac3dParser {
    private static final String GENERAL_EXCEPTION_PROP = "org.j3d.loaders.ac3d.Ac3dParser.generalErrorMsg";
    private static final String TAG_FORMAT_PROP1 = "org.j3d.loaders.ac3d.Ac3dParser.tagParseCountMsg1";
    private static final String TAG_FORMAT_PROP2 = "org.j3d.loaders.ac3d.Ac3dParser.tagParseCountMsg2";
    private static final String TAG_FORMAT_PROP3 = "org.j3d.loaders.ac3d.Ac3dParser.tagParseCountMsg3";
    private static final String HEADER_TOO_SHORT_PROP = "org.j3d.loaders.ac3d.Ac3dParser.shortHeaderMsg";
    private static final String INVALID_PREAMBLE_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidPreambleMsg";
    private static final String UNSUPPORTED_VERSION_PROP = "org.j3d.loaders.ac3d.Ac3dParser.unsupportedVersionMsg";
    private static final String OBJECT_TOKEN_CNT_PROP = "org.j3d.loaders.ac3d.Ac3dParser.objectCountMsg";
    private static final String INVALID_OBJECT_CHILD_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidObjectChildMsg";
    private static final String INVALID_OBJECT_TOKEN_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidObjectTokenMsg";
    private static final String INVALID_SURFACE_CHILD_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidSurfaceChildMsg";
    private static final String INVALID_SURFACE_TOKEN_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidSurfaceTokenMsg";
    private static final String ILLEGAL_TOKEN_PROP = "org.j3d.loaders.ac3d.Ac3dParser.invalidTokenMsg";
    private static final String USER_MATERIAL_PROP = "org.j3d.loaders.ac3d.Ac3dParser.materialCallbackErrMsg";
    private static final String USER_OBJECT_PROP = "org.j3d.loaders.ac3d.Ac3dParser.objectCallbackErrMsg";
    private static final String USER_SURFACE_PROP = "org.j3d.loaders.ac3d.Ac3dParser.surfaceCallbackErrMsg";
    public static final int SUPPORTED_FORMAT_VERSION = 11;
    private static final String HEADER_PREAMBLE = "AC3D";
    private static final int MATERIAL_TOKEN = 1;
    private static final int OBJECT_TOKEN = 2;
    private static final int KIDS_TOKEN = 3;
    private static final int NUMVERT_TOKEN = 4;
    private static final int NAME_TOKEN = 5;
    private static final int LOCATION_TOKEN = 6;
    private static final int ROTATION_TOKEN = 7;
    private static final int NUMSURF_TOKEN = 8;
    private static final int SURF_TOKEN = 9;
    private static final int REFS_TOKEN = 10;
    private static final int MAT_TOKEN = 11;
    private static final int TEXTURE_TOKEN = 12;
    private static final int TEXTURE_REPEAT_TOKEN = 13;
    private static final int DATA_TOKEN = 14;
    private static final int URL_TOKEN = 15;
    private static final int CREASE_TOKEN = 16;
    private static final int RGB_TOKEN = 17;
    private static final int AMBIENT_TOKEN = 18;
    private static final int EMISSIVE_TOKEN = 19;
    private static final int SPECULAR_TOKEN = 20;
    private static final int SHININESS_TOKEN = 21;
    private static final int TRANSPARENCY_TOKEN = 22;
    private static HashMap<String, Integer> keywordsMap = new HashMap();
    private BufferedReader reader;
    private ArrayList<Ac3dMaterial> materials = new ArrayList();
    private ArrayList<Ac3dObject> objects = new ArrayList();
    private LineTokenizer lineTokenizer = new LineTokenizer();
    private int materialCount = 0;
    private Ac3dParseObserver observer;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public Ac3dParser() {
    }

    public Ac3dParser(Reader reader) {
        this();
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setParseObserver(Ac3dParseObserver ac3dParseObserver) {
        this.observer = ac3dParseObserver;
    }

    public void parse(boolean bl) throws IOException {
        String string;
        this.checkHeader();
        boolean bl2 = false;
        while ((string = this.reader.readLine()) != null && !bl2) {
            String string2;
            I18nManager i18nManager;
            String[] stringArray = this.lineTokenizer.enumerateTokens(string);
            try {
                int n = keywordsMap.get(stringArray[0]);
                switch (n) {
                    case 1: {
                        bl2 = this.parseMaterial(stringArray, bl);
                        break;
                    }
                    case 2: {
                        bl2 = this.parseObject(null, stringArray, bl);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                i18nManager = I18nManager.getManager();
                string2 = i18nManager.getString(ILLEGAL_TOKEN_PROP) + string;
                this.errorReporter.errorReport(string2, nullPointerException);
            }
            catch (Exception exception) {
                i18nManager = I18nManager.getManager();
                string2 = i18nManager.getString(ILLEGAL_TOKEN_PROP);
                this.errorReporter.errorReport(string2, exception);
            }
        }
    }

    public void reset(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.materials.clear();
        this.objects.clear();
        this.materialCount = 0;
    }

    public Ac3dMaterial[] getMaterials() {
        return this.materials.toArray(new Ac3dMaterial[0]);
    }

    public Ac3dObject[] getObjects() {
        return this.objects.toArray(new Ac3dObject[0]);
    }

    private void checkHeader() throws IOException {
        String string = this.reader.readLine();
        if (string.length() < 5) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(HEADER_TOO_SHORT_PROP);
            throw new InvalidFormatException(string2);
        }
        String string3 = string.substring(0, 3);
        if (!string3.equals(HEADER_PREAMBLE)) {
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(INVALID_PREAMBLE_PROP);
            throw new InvalidFormatException(string4);
        }
        string3 = string.substring(4, string.length());
        int n = Integer.valueOf(string3, 16);
        if (n > 11) {
            I18nManager i18nManager = I18nManager.getManager();
            String string5 = i18nManager.getString(UNSUPPORTED_VERSION_PROP);
            throw new UnsupportedFormatException(string5);
        }
    }

    private boolean parseMaterial(String[] stringArray, boolean bl) {
        int n;
        Ac3dMaterial ac3dMaterial = new Ac3dMaterial();
        if (stringArray.length > 1) {
            ac3dMaterial.setName(stringArray[1]);
        }
        block10: for (n = 2; n < stringArray.length; ++n) {
            switch (keywordsMap.get(stringArray[n])) {
                case 17: {
                    ac3dMaterial.setRGBColor(this.parseFloats(stringArray, n + 1, 3));
                    n += 3;
                    continue block10;
                }
                case 18: {
                    ac3dMaterial.setAmbientColor(this.parseFloats(stringArray, n + 1, 3));
                    n += 3;
                    continue block10;
                }
                case 19: {
                    ac3dMaterial.setEmissiveColor(this.parseFloats(stringArray, n + 1, 3));
                    n += 3;
                    continue block10;
                }
                case 20: {
                    ac3dMaterial.setSpecularColor(this.parseFloats(stringArray, n + 1, 3));
                    n += 3;
                    continue block10;
                }
                case 21: {
                    ac3dMaterial.setShininess(Ac3dParser.parseFloat(stringArray[n + 1]));
                    ++n;
                    continue block10;
                }
                case 22: {
                    ac3dMaterial.setTransparency(Ac3dParser.parseFloat(stringArray[n + 1]));
                    ++n;
                }
            }
        }
        ac3dMaterial.setIndex(this.materialCount);
        ++this.materialCount;
        if (bl) {
            this.materials.add(ac3dMaterial);
        }
        n = 0;
        if (this.observer != null) {
            try {
                n = !this.observer.materialComplete(ac3dMaterial) ? 1 : 0;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(USER_MATERIAL_PROP, exception);
            }
        }
        return n != 0;
    }

    private boolean parseObject(Ac3dObject ac3dObject, String[] stringArray, boolean bl) throws IOException {
        String string;
        if (stringArray.length != 2) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(OBJECT_TOKEN_CNT_PROP);
            throw new ParsingErrorException(string2);
        }
        Ac3dObject ac3dObject2 = new Ac3dObject();
        ac3dObject2.setType(stringArray[1]);
        if (ac3dObject != null) {
            ac3dObject.addChild(ac3dObject2);
        } else if (bl) {
            this.objects.add(ac3dObject2);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2 && !bl3 && (string = this.reader.readLine()) != null) {
            Object object;
            String[] stringArray2 = this.lineTokenizer.enumerateTokens(string);
            Integer n = keywordsMap.get(stringArray2[0]);
            if (n == null) {
                I18nManager i18nManager = I18nManager.getManager();
                object = i18nManager.getString(INVALID_OBJECT_TOKEN_PROP) + stringArray2[0];
                this.errorReporter.warningReport((String)object, null);
                continue;
            }
            switch (n) {
                case 3: {
                    if (this.observer != null) {
                        try {
                            bl2 = !this.observer.objectComplete(ac3dObject, ac3dObject2);
                        }
                        catch (Exception exception) {
                            object = I18nManager.getManager();
                            String string3 = ((I18nManager)object).getString(USER_SURFACE_PROP);
                            this.errorReporter.errorReport(string3, exception);
                        }
                    }
                    if (!bl2) {
                        bl2 = this.parseKids(ac3dObject2, stringArray2, bl);
                    }
                    bl3 = true;
                    break;
                }
                case 4: {
                    this.parseVertices(ac3dObject2, stringArray2);
                    break;
                }
                case 5: {
                    this.parseName(ac3dObject2, stringArray2);
                    break;
                }
                case 6: {
                    this.parseLocation(ac3dObject2, stringArray2);
                    break;
                }
                case 7: {
                    this.parseRotation(ac3dObject2, stringArray2);
                    break;
                }
                case 8: {
                    bl2 = this.parseNumSurfaces(ac3dObject2, stringArray2);
                    break;
                }
                case 12: {
                    this.parseTexture(ac3dObject2, stringArray2);
                    break;
                }
                case 13: {
                    this.parseTextureRepeat(ac3dObject2, stringArray2);
                    break;
                }
                case 14: {
                    this.parseData(ac3dObject2, stringArray2);
                    break;
                }
                case 15: {
                    this.parseURL(ac3dObject2, stringArray2);
                    break;
                }
                case 16: {
                    this.parseCreaseAngle(ac3dObject2, stringArray2);
                    break;
                }
            }
        }
        return bl2;
    }

    private boolean parseKids(Ac3dObject ac3dObject, String[] stringArray, boolean bl) throws IOException {
        this.qualifyTagByAC3DObject(stringArray, 2);
        int n = this.parseDecimal(stringArray[1]);
        boolean bl2 = false;
        for (int i = 0; i < n && !bl2; ++i) {
            String string = this.reader.readLine();
            String[] stringArray2 = this.lineTokenizer.enumerateTokens(string);
            int n2 = keywordsMap.get(stringArray2[0]);
            if (n2 != 2) {
                I18nManager i18nManager = I18nManager.getManager();
                String string2 = i18nManager.getString(INVALID_OBJECT_CHILD_PROP) + stringArray2[0];
                throw new ParsingErrorException(string2);
            }
            bl2 = this.parseObject(ac3dObject, stringArray2, bl);
        }
        return bl2;
    }

    private void parseTextureRepeat(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setTextureRepeat(this.parseFloats(stringArray, 0, 2));
    }

    private void parseData(Ac3dObject ac3dObject, String[] stringArray) throws IOException {
        this.qualifyTagByAC3DObject(stringArray, 2);
        int n = this.parseDecimal(stringArray[1]);
        char[] cArray = new char[n];
        this.reader.read(cArray, 0, n);
        this.reader.readLine();
        String string = new String(cArray);
        ac3dObject.setData(string);
    }

    private void parseURL(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 1);
        ac3dObject.setURL(stringArray[1]);
    }

    private void parseCreaseAngle(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setCreaseAngle(Ac3dParser.parseFloat(stringArray[1]));
    }

    private boolean parseNumSurfaces(Ac3dObject ac3dObject, String[] stringArray) throws IOException {
        this.qualifyTagByAC3DObject(stringArray, 2);
        int n = this.parseDecimal(stringArray[1]);
        boolean bl = false;
        for (int i = 0; i < n && !bl; ++i) {
            bl = this.parseSurface(ac3dObject);
        }
        return bl;
    }

    private boolean parseSurface(Ac3dObject ac3dObject) throws IOException {
        String string = this.reader.readLine();
        String[] stringArray = this.lineTokenizer.enumerateTokens(string);
        int n = keywordsMap.get(stringArray[0]);
        if (n != 9) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(INVALID_SURFACE_CHILD_PROP);
            throw new ParsingErrorException(string2);
        }
        Ac3dSurface ac3dSurface = new Ac3dSurface();
        ac3dSurface.setFlags(this.parseHexidecimal(stringArray[1]));
        string = this.reader.readLine();
        stringArray = this.lineTokenizer.enumerateTokens(string);
        Integer n2 = keywordsMap.get(stringArray[0]);
        if (n2 == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string3 = i18nManager.getString(INVALID_SURFACE_TOKEN_PROP) + stringArray[0];
            this.errorReporter.warningReport(string3, null);
            return true;
        }
        this.parseMaterialRef(ac3dSurface, stringArray);
        string = this.reader.readLine();
        stringArray = this.lineTokenizer.enumerateTokens(string);
        n2 = keywordsMap.get(stringArray[0]);
        if (n2 == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(INVALID_SURFACE_TOKEN_PROP) + stringArray[0];
            this.errorReporter.warningReport(string4, null);
            return true;
        }
        this.parseSurfaceRefs(ac3dSurface, stringArray);
        ac3dObject.addSurface(ac3dSurface);
        boolean bl = false;
        if (this.observer != null) {
            try {
                bl = !this.observer.surfaceComplete(ac3dObject, ac3dSurface);
            }
            catch (Exception exception) {
                I18nManager i18nManager = I18nManager.getManager();
                String string5 = i18nManager.getString(USER_SURFACE_PROP);
                this.errorReporter.errorReport(string5, exception);
            }
        }
        return bl;
    }

    private void parseVertices(Ac3dObject ac3dObject, String[] stringArray) throws IOException {
        this.qualifyTagByAC3DObject(stringArray, 2);
        int n = this.parseDecimal(stringArray[1]);
        ac3dObject.setNumvert(n);
        for (int i = 0; i < n; ++i) {
            String string = this.reader.readLine();
            String[] stringArray2 = this.lineTokenizer.enumerateTokens(string);
            ac3dObject.addVertex(i, this.parseFloats(stringArray2, 0, 3));
        }
    }

    private void parseName(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setName(stringArray[1]);
    }

    private void parseTexture(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 2);
        ac3dObject.setTexture(stringArray[1]);
    }

    private void parseRotation(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 10);
        ac3dObject.setRotation(this.parseFloats(stringArray, 1, 9));
    }

    private void parseLocation(Ac3dObject ac3dObject, String[] stringArray) {
        this.qualifyTagByAC3DObject(stringArray, 4);
        ac3dObject.setLocation(this.parseFloats(stringArray, 1, 3));
    }

    private void parseMaterialRef(Ac3dSurface ac3dSurface, String[] stringArray) {
        ac3dSurface.setMaterial(this.parseDecimal(stringArray[1]));
    }

    private void parseSurfaceRefs(Ac3dSurface ac3dSurface, String[] stringArray) throws IOException {
        int n = this.parseDecimal(stringArray[1]);
        ac3dSurface.setNumrefs(n);
        for (int i = 0; i < n; ++i) {
            String string = this.reader.readLine();
            String[] stringArray2 = this.lineTokenizer.enumerateTokens(string);
            ac3dSurface.addRef(i, this.parseDecimal(stringArray2[0]), this.parseFloats(stringArray2, 1, 2));
        }
    }

    private void qualifyTagByAC3DObject(String[] stringArray, int n) throws ParsingErrorException {
        if (stringArray.length != n) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(TAG_FORMAT_PROP1);
            String string2 = i18nManager.getString(TAG_FORMAT_PROP2);
            String string3 = i18nManager.getString(TAG_FORMAT_PROP3);
            String string4 = string + stringArray[0] + string2 + n + string3 + stringArray.length;
            throw new ParsingErrorException(string4);
        }
    }

    private float[] parseFloats(String[] stringArray, int n, int n2) {
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = Ac3dParser.parseFloat(stringArray[n + i]);
        }
        return fArray;
    }

    private int parseDecimal(String string) {
        return Integer.valueOf(string);
    }

    private int parseHexidecimal(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2, string.length());
        }
        return Integer.valueOf(string, 16);
    }

    private static final float parseFloat(String string) {
        if (string.indexOf(".") < 0) {
            string = string + ".0";
        }
        return Float.valueOf(string).floatValue();
    }

    static {
        keywordsMap.put("MATERIAL", 1);
        keywordsMap.put("OBJECT", 2);
        keywordsMap.put("kids", 3);
        keywordsMap.put("numvert", 4);
        keywordsMap.put("name", 5);
        keywordsMap.put("loc", 6);
        keywordsMap.put("rot", 7);
        keywordsMap.put("numsurf", 8);
        keywordsMap.put("SURF", 9);
        keywordsMap.put("refs", 10);
        keywordsMap.put("mat", 11);
        keywordsMap.put("texture", 12);
        keywordsMap.put("data", 14);
        keywordsMap.put("texrep", 13);
        keywordsMap.put("url", 15);
        keywordsMap.put("crease", 16);
        keywordsMap.put("rgb", 17);
        keywordsMap.put("amb", 18);
        keywordsMap.put("emis", 19);
        keywordsMap.put("spec", 20);
        keywordsMap.put("shi", 21);
        keywordsMap.put("trans", 22);
    }
}

