/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.c3d;

public abstract class C3DParameter {
    public static final int CHAR_TYPE = 1;
    public static final int BYTE_TYPE = 2;
    public static final int INT_TYPE = 3;
    public static final int FLOAT_TYPE = 4;
    protected static final String LOCKED_PARAM_MSG = "This parameter is locked and cannot be modified";
    private final int paramType;
    protected String name;
    protected boolean locked;
    protected int id;
    protected String description;
    protected int[] dimensions;
    protected Object data;

    protected C3DParameter(int n, String string, boolean bl, int n2) {
        this.paramType = n;
        this.name = string;
        this.locked = bl;
        this.id = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof C3DParameter)) {
            return false;
        }
        C3DParameter c3DParameter = (C3DParameter)object;
        return c3DParameter.id == this.id && c3DParameter.name.equals(this.name) && c3DParameter.paramType == this.paramType;
    }

    public int getType() {
        return this.paramType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException(LOCKED_PARAM_MSG);
        }
        this.description = string;
    }

    public Object getValue() {
        return this.data;
    }

    public int numDimensions() {
        return this.dimensions == null ? 0 : this.dimensions.length;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }
}

