/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.InvalidFormatException;
import org.j3d.loaders.stl.LittleEndianConverter;
import org.j3d.loaders.stl.STLParser;

class STLBinaryParser
extends STLParser {
    private static int HEADER_SIZE = 84;
    private static int RECORD_SIZE = 50;
    private static int COMMENT_SIZE = 80;
    private BufferedInputStream itsStream;
    private byte[] itsReadBuffer = new byte[48];
    private int[] itsDataBuffer = new int[12];

    public void close() throws IOException {
        if (this.itsStream != null) {
            this.itsStream.close();
        }
    }

    public boolean parse(URL uRL) throws InvalidFormatException, IOException {
        int n;
        InputStream inputStream;
        block2: {
            inputStream = null;
            n = -1;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                n = uRLConnection.getContentLength();
            }
            catch (IOException iOException) {
                if (inputStream == null) break block2;
                inputStream.close();
            }
        }
        this.itsStream = new BufferedInputStream(inputStream);
        return this.parse(n);
    }

    public boolean parse(URL uRL, Component component) throws InvalidFormatException, IOException {
        int n;
        InputStream inputStream;
        block2: {
            inputStream = null;
            n = -1;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                n = uRLConnection.getContentLength();
            }
            catch (IOException iOException) {
                if (inputStream == null) break block2;
                inputStream.close();
            }
        }
        inputStream = new ProgressMonitorInputStream(component, "parsing " + uRL.toString(), inputStream);
        this.itsStream = new BufferedInputStream(inputStream);
        return this.parse(n);
    }

    private boolean parse(int n) throws InvalidFormatException, IOException {
        try {
            for (int i = 0; i < COMMENT_SIZE; ++i) {
                this.itsStream.read();
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (n != -1 && n != this.itsNumOfFacets[0] * RECORD_SIZE + HEADER_SIZE) {
                String string = "File size does not match the expected size forthe given number of facets. Given " + this.itsNumOfFacets[0] + " facets for a total size of " + (this.itsNumOfFacets[0] * RECORD_SIZE + HEADER_SIZE) + " but the file size is " + n;
                this.close();
                throw new InvalidFormatException(string);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        return false;
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws IOException {
        int n;
        LittleEndianConverter.read(this.itsReadBuffer, this.itsDataBuffer, 0, 12, (InputStream)this.itsStream);
        for (n = 0; n < 3; ++n) {
            dArray[n] = Float.intBitsToFloat(this.itsDataBuffer[n]);
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                dArray2[n][i] = Float.intBitsToFloat(this.itsDataBuffer[n * 3 + i + 3]);
            }
        }
        this.itsStream.read();
        this.itsStream.read();
        return true;
    }
}

