/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.terrain.FreeFormTerrainData;
import org.j3d.terrain.Landscape;
import org.j3d.terrain.StaticTerrainData;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.TiledTerrainData;
import org.j3d.terrain.roam.PatchGrid;
import org.j3d.terrain.roam.ROAMPatch;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TreeQueueManager;
import org.j3d.util.I18nManager;
import org.j3d.util.frustum.ViewFrustum;

public abstract class ROAMSplitMergeLandscape
extends Landscape {
    private static final String NEG_PATCH_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.negPatchSizeMsg";
    private static final String NOT_POW2_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.pow2PatchSizeMsg";
    private static final String GRID_W_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.gridWidthSizeMsg";
    private static final String GRID_D_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.gridDepthSizeMsg";
    private static final String INV_TERRAIN_TYPE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.unknownTerrainTypeMsg";
    private static final int DEFAULT_PATCH_SIZE = 65;
    private static final int AXIS_TILE_COUNT = 7;
    protected final int patchSize;
    private final int invPatchSize;
    private final int terrainDataType;
    private final float accuracy;
    private ArrayList patches = new ArrayList();
    private TreeQueueManager queueManager = new TreeQueueManager();
    private int triCount = 0;
    private Point3d maxViewBound;
    private Point3d minViewBound;
    private Rectangle oldTileBounds;
    private Rectangle reqdBounds;
    private LinkedList freePatchList;
    private ArrayList tempPatchList;
    private PatchGrid patchGrid;

    public ROAMSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        super(viewFrustum, terrainData);
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, 65);
        this.invPatchSize = 1 / this.patchSize;
    }

    public ROAMSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, int n) {
        super(viewFrustum, terrainData);
        if (n <= 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NEG_PATCH_SIZE_MSG_PROP);
            throw new IllegalArgumentException(string);
        }
        if (!this.power2Check(n - 1)) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NOT_POW2_MSG_PROP);
            throw new IllegalArgumentException(string);
        }
        this.terrainDataType = terrainData.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(terrainData, n);
        this.invPatchSize = 1 / n;
    }

    public void initialize(Tuple3f tuple3f, Vector3f vector3f) {
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 1: {
                this.createStaticPatches();
                break;
            }
            case 2: {
                this.minViewBound = new Point3d();
                this.maxViewBound = new Point3d();
                this.reqdBounds = new Rectangle();
                this.oldTileBounds = new Rectangle();
                this.freePatchList = new LinkedList();
                this.tempPatchList = new ArrayList();
                this.createTiledPatches(tuple3f, vector3f);
                break;
            }
            case 3: {
                this.createFreeFormPatches();
            }
        }
        this.setView(tuple3f, vector3f);
    }

    public void setView(Tuple3f tuple3f, Vector3f vector3f) {
        ROAMPatch rOAMPatch;
        int n;
        this.queueManager.clear();
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 2: {
                if (this.calculateViewTileBounds(tuple3f, vector3f)) break;
                this.patchGrid.prepareNewBounds(this.reqdBounds);
                this.clearOldTiledPatches();
                this.loadNewTiles(tuple3f);
                this.oldTileBounds.setBounds(this.reqdBounds);
                break;
            }
        }
        int n2 = this.patches.size();
        for (n = 0; n < n2; ++n) {
            rOAMPatch = (ROAMPatch)this.patches.get(n);
            rOAMPatch.setView(tuple3f, this.landscapeView, this.queueManager);
        }
        boolean bl = false;
        while (!bl) {
            TreeNode treeNode = this.queueManager.getSplitCandidate();
            TreeNode treeNode2 = this.queueManager.getMergeCandidate();
            if (treeNode2 == null && treeNode != null) {
                if (treeNode.variance > this.accuracy) {
                    treeNode.forceSplit(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode == null) {
                if (treeNode2.variance < this.accuracy) {
                    treeNode2.merge(this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode != null && (treeNode.variance > this.accuracy || treeNode.variance > treeNode2.variance)) {
                if (treeNode.variance > this.accuracy) {
                    treeNode.forceSplit(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                if (!(treeNode2.variance < this.accuracy)) continue;
                treeNode2.merge(this.queueManager);
                continue;
            }
            bl = true;
        }
        for (n = 0; n < n2; ++n) {
            rOAMPatch = (ROAMPatch)this.patches.get(n);
            rOAMPatch.updateGeometry();
        }
        this.queueManager.clear();
    }

    protected abstract ROAMPatch createPatch(int var1, int var2, int var3, int var4);

    protected abstract void updatePatch(ROAMPatch var1, int var2, int var3);

    protected abstract void addPatch(ROAMPatch var1);

    private int init(TerrainData terrainData, int n) {
        int n2 = n;
        switch (this.terrainDataType) {
            case 1: {
                StaticTerrainData staticTerrainData = (StaticTerrainData)terrainData;
                int n3 = staticTerrainData.getGridWidth();
                int n4 = staticTerrainData.getGridDepth();
                if (!this.checkPatchSide(n3, n)) {
                    I18nManager i18nManager = I18nManager.getManager();
                    String string = i18nManager.getString(GRID_W_SIZE_MSG_PROP) + n3;
                    throw new IllegalArgumentException(string);
                }
                if (this.checkPatchSide(n4, n)) break;
                I18nManager i18nManager = I18nManager.getManager();
                String string = i18nManager.getString(GRID_D_SIZE_MSG_PROP) + n4;
                throw new IllegalArgumentException(string);
            }
            case 3: {
                break;
            }
            case 2: {
                n2 = ((TiledTerrainData)terrainData).getTileSize();
                break;
            }
            default: {
                n2 = 0;
                I18nManager i18nManager = I18nManager.getManager();
                String string = i18nManager.getString(INV_TERRAIN_TYPE_MSG_PROP);
                System.out.println(string);
            }
        }
        return n2;
    }

    private void createTiledPatches(Tuple3f tuple3f, Vector3f vector3f) {
        TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
        this.calculateViewTileBounds(tuple3f, vector3f);
        tiledTerrainData.setActiveBounds(this.reqdBounds);
        this.oldTileBounds.setBounds(this.reqdBounds);
        this.patchGrid = new PatchGrid(this.reqdBounds);
        ROAMPatch rOAMPatch = null;
        int n = this.reqdBounds.x * this.patchSize;
        int n2 = this.reqdBounds.x;
        int n3 = n;
        for (int i = 0; i < this.reqdBounds.width; ++i) {
            int n4 = this.reqdBounds.y * this.patchSize;
            int n5 = this.reqdBounds.y;
            int n6 = n4;
            for (int j = 0; j < this.reqdBounds.height; ++j) {
                rOAMPatch = this.createPatch(i, j, n2, n5);
                rOAMPatch.setOrigin(n3, n6);
                this.patchGrid.addPatch(rOAMPatch, n2, n5);
                rOAMPatch.makeActive();
                this.patches.add(rOAMPatch);
                this.triCount += 2;
                this.addPatch(rOAMPatch);
                ++n5;
                ++n4;
                n6 += this.patchSize;
            }
            ++n2;
            ++n;
            n3 += this.patchSize;
        }
    }

    private void createFreeFormPatches() {
        FreeFormTerrainData freeFormTerrainData = (FreeFormTerrainData)this.terrainData;
        System.out.println("Free-form terrain not implemented yet");
    }

    private void createStaticPatches() {
        StaticTerrainData staticTerrainData = (StaticTerrainData)this.terrainData;
        int n = staticTerrainData.getGridDepth() - this.patchSize;
        int n2 = staticTerrainData.getGridWidth() - this.patchSize;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("ROAMPatch size is greater than the grid cell size");
        }
        ROAMPatch[] rOAMPatchArray = new ROAMPatch[n2];
        ROAMPatch rOAMPatch = null;
        ROAMPatch rOAMPatch2 = null;
        if (n2 == 0) {
            for (int i = 0; i <= n; i += this.patchSize) {
                rOAMPatch2 = this.createPatch(0, i, 0, 0);
                rOAMPatch2.setOrigin(0, i);
                rOAMPatch2.setSouthNeighbour(rOAMPatch);
                rOAMPatch2.makeActive();
                this.patches.add(rOAMPatch2);
                this.triCount += 2;
                this.addPatch(rOAMPatch2);
                rOAMPatch = rOAMPatch2;
            }
            rOAMPatch = null;
        } else {
            for (int i = 0; i <= n2; i += this.patchSize) {
                for (int j = 0; j <= n; j += this.patchSize) {
                    int n3 = j * this.invPatchSize;
                    rOAMPatch2 = this.createPatch(i, j, 0, 0);
                    rOAMPatch2.setOrigin(i, j);
                    rOAMPatch2.setWestNeighbour(rOAMPatchArray[n3]);
                    rOAMPatch2.setSouthNeighbour(rOAMPatch);
                    rOAMPatch2.makeActive();
                    this.patches.add(rOAMPatch2);
                    this.triCount += 2;
                    this.addPatch(rOAMPatch2);
                    rOAMPatch = rOAMPatch2;
                    rOAMPatchArray[n3] = rOAMPatch2;
                }
                rOAMPatch = null;
            }
        }
    }

    private boolean power2Check(int n) {
        int n2 = n;
        while ((n2 & 1) == 0) {
            n2 >>= 1;
        }
        return (n2 | 1) == 1;
    }

    private boolean checkPatchSide(int n, int n2) {
        int n3 = n - 1;
        return n3 % n2 == 0;
    }

    private boolean calculateViewTileBounds(Tuple3f tuple3f, Vector3f vector3f) {
        TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
        float f = (float)tiledTerrainData.getGridXStep();
        float f2 = (float)tiledTerrainData.getGridYStep();
        int n = tiledTerrainData.getTileSize();
        float[] fArray = new float[3];
        tiledTerrainData.getCoordinate(fArray, 0, 0);
        float f3 = tuple3f.x - fArray[0];
        float f4 = fArray[2] - tuple3f.z;
        int n2 = (int)Math.floor(f3 / (f * (float)n));
        int n3 = (int)Math.floor(f4 / (f2 * (float)n));
        if (vector3f.x == 0.0f && vector3f.z == 0.0f) {
            n2 -= 3;
            n3 -= 3;
        } else {
            float f5 = Math.abs(vector3f.x / vector3f.z);
            if (vector3f.x >= 0.0f) {
                if (vector3f.z <= 0.0f) {
                    if (f5 < 0.5f) {
                        --n2;
                    } else if (f5 > 2.0f) {
                        --n3;
                    }
                } else {
                    --n3;
                    if (f5 < 0.5f) {
                        --n2;
                    }
                }
            } else if (vector3f.z <= 0.0f) {
                --n2;
                if (f5 > 2.0f) {
                    --n3;
                }
            } else {
                --n2;
                --n3;
            }
            this.reqdBounds.x = n2;
            this.reqdBounds.y = n3;
            this.reqdBounds.width = 7;
            this.reqdBounds.height = 7;
        }
        return this.oldTileBounds.equals(this.reqdBounds);
    }

    private void clearOldTiledPatches() {
        int n = this.patches.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ROAMPatch rOAMPatch = (ROAMPatch)this.patches.get(i);
            if (this.reqdBounds.contains(rOAMPatch.getTileOrigin())) continue;
            rOAMPatch.clear();
            this.freePatchList.add(rOAMPatch);
            this.tempPatchList.add(rOAMPatch);
            bl = true;
        }
        if (bl) {
            this.patches.removeAll(this.tempPatchList);
            this.tempPatchList.clear();
        }
    }

    private void loadNewTiles(Tuple3f tuple3f) {
        int n;
        int n2;
        int n3;
        int n4;
        TiledTerrainData tiledTerrainData;
        ROAMPatch rOAMPatch = null;
        float f = 1.0f / (float)this.patchSize;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.reqdBounds.x - this.oldTileBounds.x;
        n5 = n7 <= 0 ? this.reqdBounds.x : this.reqdBounds.x + this.reqdBounds.width - n7;
        int n8 = Math.abs(n7);
        n7 = this.reqdBounds.y - this.oldTileBounds.y;
        n6 = n7 <= 0 ? this.reqdBounds.y : this.reqdBounds.y + this.reqdBounds.height - n7;
        int n9 = Math.abs(n7);
        int n10 = 0;
        int n11 = 0;
        if (n9 != 0) {
            tiledTerrainData = (TiledTerrainData)this.terrainData;
            n4 = this.oldTileBounds.x - 1;
            n3 = n4 * this.patchSize;
            for (n10 = 0; n10 < this.reqdBounds.width; ++n10) {
                n3 += this.patchSize;
                ++n4;
                n2 = n6;
                n = (n2 - 1) * this.patchSize;
                for (n11 = 0; n11 < n9; ++n11) {
                    n += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        rOAMPatch = this.createPatch(n10, n11, n4, n2);
                        this.addPatch(rOAMPatch);
                    } else {
                        rOAMPatch = (ROAMPatch)this.freePatchList.remove(0);
                        this.updatePatch(rOAMPatch, n4, n2);
                    }
                    this.tempPatchList.add(rOAMPatch);
                    rOAMPatch.setOrigin(n3, n);
                    this.patchGrid.addPatch(rOAMPatch, n4, n2);
                    rOAMPatch.makeActive();
                    rOAMPatch.reset();
                    this.patches.add(rOAMPatch);
                    this.triCount += 2;
                    ++n2;
                }
            }
        }
        if (n8 != 0) {
            n4 = n5 - 1;
            n9 = this.reqdBounds.height;
            tiledTerrainData = (TiledTerrainData)this.terrainData;
            n3 = n4 * this.patchSize;
            for (n10 = 0; n10 < n8; ++n10) {
                n3 += this.patchSize;
                n2 = n6;
                n = (n2 - 1) * this.patchSize;
                ++n4;
                for (n11 = 0; n11 < n9; ++n11) {
                    int n12 = (int)((float)n2 * f);
                    n += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        rOAMPatch = this.createPatch(n10, n11, n4, n2);
                        this.addPatch(rOAMPatch);
                    } else {
                        rOAMPatch = (ROAMPatch)this.freePatchList.remove(0);
                        this.updatePatch(rOAMPatch, n4, n2);
                    }
                    this.tempPatchList.add(rOAMPatch);
                    rOAMPatch.setOrigin(n3, n);
                    this.patchGrid.addPatch(rOAMPatch, n4, n2);
                    rOAMPatch.makeActive();
                    rOAMPatch.reset();
                    this.patches.add(rOAMPatch);
                    this.triCount += 2;
                    ++n2;
                }
            }
        }
        int n13 = this.tempPatchList.size();
        for (n10 = 0; n10 < n13; ++n10) {
            rOAMPatch = (ROAMPatch)this.tempPatchList.get(n10);
            rOAMPatch.updateEdges(tuple3f, this.queueManager);
        }
        this.tempPatchList.clear();
    }
}

