/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.io.InvalidClassException;
import org.j3d.util.I18nManager;

public class DynamicClassLoader {
    private static final String NULL_NAME_MSG_PROP = "org.j3d.util.DynamicClassLoader.nullClassNameMsg";
    private static final String NULL_BASE_MSG_PROP = "org.j3d.util.DynamicClassLoader.nullBaseClassNameMsg";
    private static final String BACKGROUND_MSG_PROP = "org.j3d.util.DynamicClassLoader.invalidBaseClassMsg";
    private static final String INIT_MSG_PROP = "org.j3d.util.DynamicClassLoader.badClassInitMsg";

    private DynamicClassLoader() {
    }

    public static Object loadBasicClass(String string) throws ClassNotFoundException, InvalidClassException {
        if (string == null || string.trim().length() == 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(NULL_NAME_MSG_PROP);
            throw new NullPointerException(string2);
        }
        Object var1_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_2 = clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            I18nManager i18nManager = I18nManager.getManager();
            String string3 = i18nManager.getString(INIT_MSG_PROP);
            throw new InvalidClassException(string3);
        }
        catch (LinkageError linkageError) {
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(INIT_MSG_PROP);
            throw new InvalidClassException(string4);
        }
        return var1_2;
    }

    public static Object loadCheckedClass(String string, String string2) throws ClassNotFoundException, InvalidClassException {
        if (string == null || string.trim().length() == 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string3 = i18nManager.getString(NULL_NAME_MSG_PROP);
            throw new NullPointerException(string3);
        }
        if (string2 == null || string2.trim().length() == 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(NULL_BASE_MSG_PROP);
            throw new NullPointerException(string4);
        }
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string2);
            object = DynamicClassLoader.loadCheckedClass(string, clazz);
        }
        catch (LinkageError linkageError) {
            I18nManager i18nManager = I18nManager.getManager();
            String string5 = i18nManager.getString(INIT_MSG_PROP);
            throw new InvalidClassException(string5);
        }
        return object;
    }

    public static Object loadCheckedClass(String string, Class clazz) throws ClassNotFoundException, InvalidClassException {
        Object object;
        if (string == null || string.trim().length() == 0) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(NULL_NAME_MSG_PROP);
            throw new NullPointerException(string2);
        }
        if (clazz == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string3 = i18nManager.getString(NULL_BASE_MSG_PROP);
            throw new NullPointerException(string3);
        }
        Object var2_4 = null;
        boolean bl = true;
        try {
            object = Class.forName(string);
            bl = DynamicClassLoader.backgroundChecks(object, clazz);
            if (bl) {
                var2_4 = ((Class)object).newInstance();
            }
        }
        catch (Exception exception) {
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(INIT_MSG_PROP);
            throw new InvalidClassException(string4);
        }
        if (!bl) {
            object = I18nManager.getManager();
            String string5 = ((I18nManager)object).getString(BACKGROUND_MSG_PROP);
            throw new InvalidClassException(string5);
        }
        return var2_4;
    }

    private static boolean backgroundChecks(Class clazz, Class clazz2) {
        Class clazz3;
        boolean bl = false;
        bl = clazz2.isAssignableFrom(clazz);
        if (!bl && (clazz3 = clazz.getSuperclass()) != null) {
            bl = DynamicClassLoader.backgroundChecks(clazz3, clazz2);
        }
        return bl;
    }
}

