/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.j3d.util.I18nManager;

public class IntHashMap {
    private static final String NO_VALUE_ERR_PROP = "org.j3d.util.IntHashMap.noCompareValueMsg";
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private ArrayList entryCache;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.entryCache = new ArrayList(n);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NO_VALUE_ERR_PROP);
            throw new NullPointerException(string);
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public int[] keySet() {
        int[] nArray = new int[this.count];
        int n = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                nArray[n++] = entry.key;
                entry = entry.next;
            }
        }
        return nArray;
    }

    public int[] keySet(int[] nArray) {
        int[] nArray2 = nArray == null || nArray.length < this.count ? new int[this.count] : nArray;
        int n = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                nArray2[n++] = entry.key;
                entry = entry.next;
            }
        }
        return nArray2;
    }

    public int[] keySetSorted() {
        int[] nArray = this.keySet();
        Arrays.sort(nArray);
        return nArray;
    }

    public int[] keySetSorted(int[] nArray) {
        int[] nArray2 = this.keySet(nArray);
        Arrays.sort(nArray2);
        return nArray2;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = this.getNewEntry();
        entry.set(n2, n, object, entryArray[n3]);
        entryArray[n3] = entry;
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                this.releaseEntry(entry);
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        if (this.count == 0) {
            return;
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            if (entry == null) continue;
            while (entry.next != null) {
                entry.value = null;
                this.releaseEntry(entry);
                Entry entry2 = entry.next;
                entry.next = null;
                entry = entry2;
            }
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private Entry getNewEntry() {
        int n = this.entryCache.size();
        Entry entry = n == 0 ? new Entry() : (Entry)this.entryCache.remove(n - 1);
        return entry;
    }

    private void releaseEntry(Entry entry) {
        this.entryCache.add(entry);
    }

    private static class Entry {
        int hash;
        int key;
        Object value;
        Entry next;

        protected Entry() {
        }

        protected Entry(int n, int n2, Object object, Entry entry) {
            this.hash = n;
            this.key = n2;
            this.value = object;
            this.next = entry;
        }

        protected void set(int n, int n2, Object object, Entry entry) {
            this.hash = n;
            this.key = n2;
            this.value = object;
            this.next = entry;
        }
    }
}

