/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cart;

import database.SplittingRule;
import database.VectorSet;
import util.OutputType;

import java.io.Serializable;
import java.util.Arrays;


/**
 *
 * @author rbanalagay
 */
public class Node implements Serializable{
    
    private SplittingRule rule = null;
    private Node leftChild = null;
    private Node rightChild = null;
    private double[] nodeValues;
    private double FUDGE_FACTOR = 3;
    private static final long serialVersionUID = 42L; 
    public Node(SplittingRule rule,double fudgeFactor)
    {
        this.rule = rule;
    }
    public Node(double[] nodeValues,double fudgeFactor)
    {
        this.nodeValues = nodeValues;
    }
    public void setLeftChild(Node leftChild)
    {
        this.leftChild = leftChild;
    }
    public void setRightChild(Node rightChild)
    {
        this.rightChild = rightChild;
    }

    public double getEstimate(String[] inputVector,double fudgeFactor)
    {
        if(rule!=null)
        {
            if(rule.goLeft(inputVector))
                return leftChild.getEstimate(inputVector,fudgeFactor);
            else
                return rightChild.getEstimate(inputVector,fudgeFactor);
        }
        else
        {
            /*double maxValue = 0.0;
            for(double current:nodeValues)
            {
                if(current>maxValue)
                    maxValue = current;
            }
            return maxValue;*/
            /*String value = "";
            value +="Result: ";
            for(double d : nodeValues)
            {
                value+=d+",";
            }
            value = value.substring(0,value.length()-1);
            System.out.println(value);*/
            return getMean()+fudgeFactor*getStDev();
            
        }
    }
    public void updateVals(String[] inputVector, double newValue)
    {
        if(rule!=null)
        {
            if(rule.goLeft(inputVector))
                leftChild.updateVals(inputVector,newValue);
            else
                rightChild.updateVals(inputVector,newValue);
        }
        else
        {
            double[] copy = Arrays.copyOf(nodeValues, nodeValues.length+1);
            nodeValues = copy;
            nodeValues[nodeValues.length-1] = newValue;
        }        
    }
    

    private double getMean()
    {
        double mean = 0.0;
        for(double current : nodeValues)
        {
            mean += current;
        }
        return mean/((double)nodeValues.length);
    }
    
    private double getStDev()
    {
        double mean = getMean();
        double errorSum = 0.0;
        
        for(double current: nodeValues)
        {
            errorSum += (mean-current)*(mean-current);
        }
        errorSum = errorSum/((double)nodeValues.length);
        return Math.sqrt(errorSum);
    }
    public void print(String prefix, boolean isTail) {
        String value = "";//(leftChild!=null && rightChild!=null) ? "Rule:"+
                //rule.toString() : "Vectors:"+nodeValues.length;
        
        if(leftChild!=null && rightChild!=null)
            value="Rule: "+rule.toString();
        else
        {
            value +="Values: ";
            for(double d : nodeValues)
            {
                value+=d+",";
            }
            value = value.substring(0,value.length()-1);
        }
        
        
        
        System.out.println(prefix + (isTail ? "└── " : "├── ") + value);
        
        if (leftChild!=null)
        {
            leftChild.print(prefix + (isTail ? "    " : "│   "), false); 
        }
        if(rightChild!=null)
        {
            rightChild.print(prefix + (isTail ?"    " : "│   "), true);
        }
      
    }


}
