/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package database;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.*;
import java.util.ArrayList;

/**
 * Represents the Hypervisor Database.  Encapsulates SQL connections
 * with the DB and exposes the basic query commands needed for training the 
 * hypervisor
 * @author rbanalagay
 */
public class HypervisorDatabase {
    
    
    private static final String DATABASE_USERNAME = "hypervisor_user";
    private static final String DATABASE_PASSWORD = "hypervisor_pass";
    private static final String DATABASE_NAME = "hypervisor";
    private static final String DATABASE_ADDRESS = 
            "jdbc:mysql://127.0.0.1:3306/"+DATABASE_NAME;

    
    private static HypervisorDatabase hypervisorDBInstance = null; 
    private static MessageDigest hasher;
    private static Charset charset;
    private Statement statement;

    private HypervisorDatabase() 
            throws SQLException, ClassNotFoundException, 
            InstantiationException, IllegalAccessException,
            NoSuchAlgorithmException
    {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
	Connection connection = 
                DriverManager.getConnection(DATABASE_ADDRESS,
                DATABASE_USERNAME, DATABASE_PASSWORD);
	statement = connection.createStatement();    
        hasher = MessageDigest.getInstance("MD5");
        charset = Charset.forName("UTF-8");
    }
    
    public static HypervisorDatabase getHypervisorDBInstance() 
            throws SQLException, ClassNotFoundException, 
            InstantiationException, IllegalAccessException,
            NoSuchAlgorithmException 
    {
        if(hypervisorDBInstance == null)
            hypervisorDBInstance = new HypervisorDatabase();
        
        return hypervisorDBInstance;
    }
    
    
    
    /**
     * Gets the list of Algorithm names stored in the hypervisor database
     * @return String array of algorithm names
     */
    public String[] getAvailableAlgorithmNames() throws SQLException
    {
        ResultSet results = 
                statement.executeQuery("SELECT * FROM module_name_lookup");

        ArrayList<String> algNames = new ArrayList<String>();
        while(results.next())
        {
            String s = results.getString(2);
            //if(!s.contains("MeanB0") && !s.contains("FromPAR") && !s.contains("ExtractFileCollection"))
                algNames.add(s);
        }
        
        results.close();
        return algNames.toArray(new String[algNames.size()]);
    }
    
    /**
     * Shuffles the entries for each of the tables in the database
     * @throws SQLException 
     */
    public void shuffle() throws SQLException
    {
        String[] names = getAvailableAlgorithmNames();
        for(String current : names)
        {
            VectorSet dbEntries = getTableEntries(current);
            if(dbEntries !=null)
            {
                String hashName = String.format("%1$032X",
                        new BigInteger(1,getHash(current)));
                statement.execute("CREATE TABLE temp SELECT * FROM "
                        +hashName+" ORDER BY RAND()");
                statement.execute("DROP TABLE "+hashName);
                statement.execute("CREATE TABLE "+hashName+
                        " SELECT * FROM temp ORDER BY RAND()");
                statement.execute("DROP TABLE temp");
            }
        }
    }
    
    public VectorSet getTableEntries(String algName)
    {
        try
        {
            String hashName = String.format("%1$032X",
                    new BigInteger(1,getHash(algName)));
            ResultSet results = 
                    statement.executeQuery("SELECT * FROM "+hashName);

            int inputSize = results.findColumn("machineID")-1;
            ArrayList<DatabaseEntry> tableEntries = 
                    new ArrayList<DatabaseEntry>();
            while(results.next())
            {
                //Get the inputs and put them in a string array
                String[] currentInputs = new String[inputSize];
                for(int i=0; i<currentInputs.length; i++)
                    currentInputs[i] = results.getString("input"+i);

                String machineID = results.getString("machineID");
                String isUseGrid = results.getString("usingGrid");
                int usedTime = results.getInt("usedTime");
                int usedMem = results.getInt("usedMem");


                DatabaseEntry currentEntry = 
                        new DatabaseEntry(currentInputs, machineID, 
                        isUseGrid, usedTime, usedMem);
                tableEntries.add(currentEntry);
            }
            return new VectorSet(tableEntries.toArray(
                    new DatabaseEntry[tableEntries.size()]));
        }
        catch(SQLException e)
        {
            return null;
        }
        
    }
    
    public static byte[] getHash(String stringToHash)
    {   
        if(hasher==null)
        {
            try{
            hasher = MessageDigest.getInstance("MD5");
            }catch (NoSuchAlgorithmException e){return null;}
        }
        if(charset==null)
        {
            charset = Charset.forName("UTF-8"); 
        }
        return hasher.digest(stringToHash.getBytes(charset));
    }
}
